/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.SystemActionViewerFilter;
import org.eclipse.rse.ui.view.SystemResourceSelectionForm;
import org.eclipse.rse.ui.view.SystemResourceSelectionInputProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemRemoteResourceDialog
extends SystemPromptDialog {
    private SystemResourceSelectionForm _form;
    private SystemResourceSelectionInputProvider _inputProvider;
    private Object _preSelection;
    private IValidatorRemoteSelection _selectionValidator;
    private boolean _multipleSelectionMode;
    private boolean _showPropertySheet = false;
    private IHost _outputConnection;
    private SystemActionViewerFilter _customViewerFilter;

    public SystemRemoteResourceDialog(Shell shell, String title, SystemResourceSelectionInputProvider inputProvider) {
        super(shell, title);
        this._inputProvider = inputProvider;
    }

    protected Control createInner(Composite parent) {
        this._form = new SystemResourceSelectionForm(this.getShell(), parent, this, this._inputProvider, this.getVerbage(), this._multipleSelectionMode, this.getMessageLine());
        this.initForm();
        this.createMessageLine(parent);
        return this._form.getInitialFocusControl();
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        ISystemMessageLine msgLine = super.createMessageLine(c);
        this._form.setMessageLine(msgLine);
        return this.fMessageLine;
    }

    public void initForm() {
        this._form.setPreSelection(this._preSelection);
        if (this._customViewerFilter != null) {
            this._form.applyViewerFilter(this._customViewerFilter);
        } else {
            this._form.applyViewerFilter(this.getViewerFilter());
        }
        this._form.setSelectionValidator(this._selectionValidator);
        this._form.setShowPropertySheet(this._showPropertySheet);
        this._form.setSelectionTreeToolTipText(this.getTreeTip());
    }

    public void setDefaultSystemConnection(IHost connection, boolean onlyConnection) {
        this._inputProvider.setSystemConnection(connection, onlyConnection);
    }

    public void setSystemTypes(String[] types) {
        this._inputProvider.setSystemTypes(types);
    }

    protected Control getInitialFocusControl() {
        return this._form.getInitialFocusControl();
    }

    public void setPreSelection(Object selection) {
        this._preSelection = selection;
        if (this._form != null) {
            this._form.setPreSelection(selection);
        }
    }

    public void setSelectionValidator(IValidatorRemoteSelection validator) {
        this._selectionValidator = validator;
    }

    public void setCustomViewerFilter(SystemActionViewerFilter viewerFilter) {
        this._customViewerFilter = viewerFilter;
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this._multipleSelectionMode = multiple;
    }

    public void setMessage(String message) {
        this._form.setMessage(message);
    }

    public void setSelectionTreeToolTipText(String tip) {
        this._form.setSelectionTreeToolTipText(tip);
    }

    public void setShowPropertySheet(boolean show) {
        this._showPropertySheet = show;
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        if (show) {
            this._showPropertySheet = initialState;
            this.setShowDetailsButton(true, !initialState);
        }
    }

    public Object getSelectedObject() {
        if (this.getOutputObject() instanceof Object[]) {
            return ((Object[])this.getOutputObject())[0];
        }
        return this.getOutputObject();
    }

    public Object[] getSelectedObjects() {
        if (this.getOutputObject() instanceof Object[]) {
            return (Object[])this.getOutputObject();
        }
        if (this.getOutputObject() instanceof Object) {
            return new Object[]{this.getOutputObject()};
        }
        return null;
    }

    public IHost getSelectedConnection() {
        return this._form.getSelectedConnection();
    }

    protected boolean processOK() {
        boolean closeDialog = this._form.verify();
        if (closeDialog) {
            this._outputConnection = this._form.getSelectedConnection();
            if (this._multipleSelectionMode) {
                this.setOutputObject(this._form.getSelectedObjects());
            } else {
                this.setOutputObject(this._form.getSelectedObject());
            }
        } else {
            this.setOutputObject(null);
        }
        return closeDialog;
    }

    protected boolean processDetails(boolean hideMode) {
        this._form.toggleShowPropertySheet(this.getShell(), this.getContents());
        return true;
    }

    public abstract SystemActionViewerFilter getViewerFilter();

    public abstract String getVerbage();

    public abstract String getTreeTip();
}

