/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.ISystemTypedObject;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;
import org.eclipse.rse.ui.validators.ValidatorConnectionName;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;
import org.eclipse.rse.ui.view.ISystemPropertyConstants;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SystemRenameSingleDialog
extends SystemPromptDialog
implements ISystemMessages,
ISystemPropertyConstants,
Runnable {
    public static final boolean COLLISION_MODE = true;
    private Button overwriteRadio;
    private Button renameRadio;
    private boolean overwriteMode = true;
    private Composite renameGroup;
    private Text newName;
    private String promptLabel;
    private String promptTip;
    private String newNameString;
    private String inputName = "";
    private Label resourceTypePrompt;
    private Label resourceTypeValue;
    private Label verbageLabel;
    private Label renameLabel;
    private SystemMessage errorMessage;
    private ISystemValidator nameValidator;
    private ValidatorUniqueString uniqueNameValidator;
    private boolean initialized = false;
    private boolean copyCollisionMode = false;
    private boolean isRemote = true;
    private ISystemViewElementAdapter adapter = null;
    private Object inputElement = null;
    private String description = null;

    public SystemRenameSingleDialog(Shell shell) {
        this(shell, SystemResources.RESID_RENAME_TITLE);
        String singleTitle = SystemResources.RESID_RENAME_SINGLE_TITLE;
        if (!singleTitle.startsWith("Missing")) {
            this.setTitle(singleTitle);
        }
    }

    public SystemRenameSingleDialog(Shell shell, String title) {
        super(shell, title);
        this.setBlockOnOpen(true);
        this.setHelp("org.eclipse.rse.ui.drns0000");
    }

    public SystemRenameSingleDialog(Shell shell, boolean copyCollisionMode, Object inputObject, ISystemValidator nameValidator) {
        this(shell);
        this.setInputObject(inputObject);
        this.setCopyCollisionMode(copyCollisionMode);
        this.setNameValidator(nameValidator);
    }

    public void setPromptLabel(String label, String tooltip) {
        this.promptLabel = label;
        this.promptTip = tooltip;
    }

    public void setCopyCollisionMode(boolean copyCollisionMode) {
        if (copyCollisionMode) {
            if (this.inputObject != null && this.inputObject instanceof IHost) {
                this.setHelp("org.eclipse.rse.ui.dccc0000");
            } else {
                this.setHelp("org.eclipse.rse.ui.drns0001");
            }
            this.setTitle(SystemResources.RESID_COLLISION_RENAME_TITLE);
        } else if (this.copyCollisionMode) {
            this.setHelp("org.eclipse.rse.ui.drns0000");
            String singleTitle = SystemResources.RESID_RENAME_SINGLE_TITLE;
            if (!singleTitle.startsWith("Missing")) {
                this.setTitle(singleTitle);
            } else {
                this.setTitle(SystemResources.RESID_RENAME_TITLE);
            }
        }
        this.copyCollisionMode = copyCollisionMode;
    }

    public boolean getCopyCollisionMode() {
        return this.copyCollisionMode;
    }

    public void setNameValidator(ISystemValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        return this.newName;
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 1;
        Composite composite = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        Object inputObject = this.getInputObject();
        if (this.copyCollisionMode) {
            this.verbageLabel = SystemWidgetHelpers.createLabel(composite, " ", nbrColumns);
            SystemWidgetHelpers.createLabel(composite, " ", nbrColumns);
        } else if (this.description != null) {
            this.verbageLabel = SystemWidgetHelpers.createLabel(composite, this.description, nbrColumns);
            SystemWidgetHelpers.createLabel(composite, " ", nbrColumns);
        }
        if (this.copyCollisionMode) {
            this.overwriteRadio = SystemWidgetHelpers.createRadioButton(composite, this, SystemResources.RESID_SIMPLE_RENAME_RADIO_OVERWRITE_LABEL, SystemResources.RESID_SIMPLE_RENAME_RADIO_OVERWRITE_TOOLTIP);
            this.overwriteRadio.setSelection(true);
            this.renameRadio = SystemWidgetHelpers.createRadioButton(composite, this, SystemResources.RESID_SIMPLE_RENAME_RADIO_RENAME_LABEL, SystemResources.RESID_SIMPLE_RENAME_RADIO_RENAME_TOOLTIP);
        }
        int nbrRenameColumns = 2;
        this.renameGroup = SystemWidgetHelpers.createComposite(composite, nbrRenameColumns);
        this.resourceTypePrompt = SystemWidgetHelpers.createLabel(this.renameGroup, SystemResources.RESID_SIMPLE_RENAME_RESOURCEPROMPT_LABEL);
        this.resourceTypeValue = SystemWidgetHelpers.createLabel(this.renameGroup, "");
        this.resourceTypeValue.setToolTipText(SystemResources.RESID_SIMPLE_RENAME_RESOURCEPROMPT_TOOLTIP);
        if (this.promptLabel == null) {
            String labelText = this.copyCollisionMode ? SystemResources.RESID_COLLISION_RENAME_LABEL : SystemResources.RESID_SIMPLE_RENAME_PROMPT_LABEL;
            labelText = SystemWidgetHelpers.appendColon(labelText);
            this.renameLabel = SystemWidgetHelpers.createLabel(this.renameGroup, labelText);
            this.newName = SystemWidgetHelpers.createTextField(this.renameGroup, null);
        } else {
            this.renameLabel = SystemWidgetHelpers.createLabel(this.renameGroup, this.promptLabel);
            this.newName = SystemWidgetHelpers.createTextField(this.renameGroup, null);
            if (this.promptTip != null) {
                this.newName.setToolTipText(this.promptTip);
            }
        }
        if (inputObject != null) {
            this.initializeInput();
        }
        this.setPageComplete(false);
        this.newName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemRenameSingleDialog.this.validateNameInput();
            }
        });
        if (this.copyCollisionMode) {
            this.enableRename(false);
        }
        return composite;
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
        if (this.newName != null) {
            this.initializeInput();
        }
    }

    private void initializeInput() {
        if (!this.initialized) {
            Shell shell;
            Display display;
            int maxLen;
            this.inputElement = this.getInputElement(this.inputObject);
            this.adapter = this.getAdapter(this.inputElement);
            if (this.adapter != null) {
                this.inputName = this.adapter.getName(this.inputElement);
            } else if (this.inputElement instanceof ISystemTypedObject) {
                this.inputName = ((ISystemTypedObject)this.inputElement).getName();
            } else if (this.inputElement instanceof IResource) {
                this.inputName = ((IResource)this.inputElement).getName();
            } else if (this.inputElement instanceof String) {
                this.inputName = (String)this.inputElement;
            }
            this.newName.setText(this.inputName);
            if (this.copyCollisionMode) {
                this.verbageLabel.setText(SystemMessage.sub((String)SystemResources.RESID_COLLISION_RENAME_VERBAGE, (String)"&1", (String)this.inputName));
            }
            if (this.nameValidator == null && this.adapter != null) {
                this.nameValidator = this.adapter.getNameValidator(this.inputElement);
            }
            if (this.nameValidator != null && this.nameValidator instanceof ISystemValidator && (maxLen = this.nameValidator.getMaximumNameLength()) != -1) {
                this.newName.setTextLimit(maxLen);
            }
            if ((display = (shell = this.getShell()).getDisplay()) != null) {
                display.asyncExec((Runnable)this);
            } else {
                this.run();
            }
            if (this.inputElement instanceof ISystemFilterPoolReference) {
                this.inputElement = ((ISystemFilterPoolReference)this.inputElement).getReferencedFilterPool();
                this.adapter = this.getAdapter(this.inputElement);
            }
            if (this.adapter != null) {
                this.resourceTypeValue.setText(this.adapter.getType(this.inputElement));
            } else if (this.inputElement instanceof ISystemTypedObject) {
                this.resourceTypeValue.setText(((ISystemTypedObject)this.inputElement).getType());
            } else if (this.inputElement instanceof IResource) {
                if (this.inputElement instanceof IFolder || this.inputElement instanceof IProject) {
                    this.resourceTypeValue.setText(SystemViewResources.RESID_PROPERTY_FILE_TYPE_FOLDER_VALUE);
                } else {
                    this.resourceTypeValue.setText(SystemViewResources.RESID_PROPERTY_FILE_TYPE_FILE_VALUE);
                }
            }
            this.initialized = true;
        }
    }

    public void run() {
        this.uniqueNameValidator = this.getUniqueNameValidator(this.inputElement, this.nameValidator);
    }

    protected ValidatorUniqueString getUniqueNameValidator(Object inputElement, ISystemValidator nameValidator) {
        ValidatorUniqueString uniqueNameValidator = null;
        ISystemRemoteElementAdapter ra = this.getRemoteAdapter(inputElement);
        if (ra != null) {
            boolean needUniqueNameValidator;
            this.isRemote = true;
            String[] names = null;
            boolean debug = false;
            boolean caseSensitive = ra.getSubSystem(inputElement).getSubSystemConfiguration().isCaseSensitive();
            boolean bl = needUniqueNameValidator = !(nameValidator instanceof ISystemValidatorUniqueString);
            if (!needUniqueNameValidator) {
                String[] existingNames = ((ISystemValidatorUniqueString)((Object)nameValidator)).getExistingNamesList();
                boolean bl2 = needUniqueNameValidator = existingNames == null || existingNames.length == 0;
            }
            if (needUniqueNameValidator) {
                super.setBusyCursor(true);
                try {
                    Shell shell = this.getShell();
                    IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
                    RSEUIPlugin.getTheSystemRegistry().clearRunnableContext();
                    names = ra.getRemoteParentNamesInUse(shell, inputElement);
                    RSEUIPlugin.getTheSystemRegistry().setRunnableContext(shell, irc);
                }
                catch (Exception exc) {
                    SystemBasePlugin.logError("Exception getting parent's child names in rename dialog", exc);
                }
                if (names != null && names.length > 0) {
                    uniqueNameValidator = new ValidatorUniqueString(names, caseSensitive);
                    uniqueNameValidator.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1006"), RSEUIPlugin.getPluginMessage("RSEG1007"));
                    if (debug) {
                        System.out.println("Name validator set. Names = ");
                        int idx = 0;
                        while (idx < names.length) {
                            System.out.println("..." + idx + ": " + names[idx]);
                            ++idx;
                        }
                    }
                }
                super.setBusyCursor(false);
            }
        } else {
            this.isRemote = false;
        }
        this.newName.setFocus();
        return uniqueNameValidator;
    }

    protected Object getInputElement(Object inputObject) {
        if (inputObject instanceof IStructuredSelection) {
            inputObject = ((IStructuredSelection)inputObject).getFirstElement();
        }
        if (inputObject instanceof SystemSimpleContentElement) {
            inputObject = ((SystemSimpleContentElement)inputObject).getData();
        }
        return inputObject;
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getAdapter(o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    protected boolean processOK() {
        this.newNameString = this.newName.getText();
        this.newNameString = !this.isRemote ? this.newNameString.trim() : SystemRenameSingleDialog.trimTrailing(this.newNameString);
        boolean closeDialog = this.verify();
        if (closeDialog && this.inputElement instanceof IHost && !(closeDialog = ValidatorConnectionName.validateNameNotInUse(this.newNameString, this.getShell()))) {
            this.newName.setFocus();
        }
        if (closeDialog) {
            this.setOutputObject(this.newNameString);
        }
        return closeDialog;
    }

    public static String trimTrailing(String text) {
        return ("." + text).trim().substring(1);
    }

    public boolean verify() {
        if (this.copyCollisionMode && this.overwriteMode) {
            return true;
        }
        SystemMessage errMsg = null;
        Text controlInError = null;
        this.clearErrorMessage();
        errMsg = this.validateNameInput(this.newNameString);
        if (errMsg != null) {
            controlInError = this.newName;
        } else if (this.isRemote && this.checkIfWillBeFilteredOut(this.inputElement, this.newNameString)) {
            return false;
        }
        if (errMsg != null) {
            controlInError.setFocus();
        }
        return errMsg == null;
    }

    protected boolean checkIfWillBeFilteredOut(Object remoteObject, String newName) {
        return false;
    }

    protected SystemMessage validateNameInput() {
        this.newNameString = this.newName.getText();
        this.newNameString = !this.isRemote ? this.newNameString.trim() : SystemRenameSingleDialog.trimTrailing(this.newNameString);
        return this.validateNameInput(this.newNameString);
    }

    protected SystemMessage validateNameInput(String theNewName) {
        this.errorMessage = null;
        if (theNewName == null) {
            this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1006");
        } else {
            if (this.nameValidator != null) {
                this.errorMessage = this.nameValidator.validate(theNewName);
            } else if (theNewName.length() == 0) {
                this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1006");
            }
            if (this.errorMessage == null && this.adapter != null && this.adapter.namesAreEqual(this.inputElement, theNewName)) {
                this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1009").makeSubstitution((Object)this.inputName);
            }
        }
        if (this.errorMessage == null && this.uniqueNameValidator != null) {
            this.errorMessage = this.uniqueNameValidator.validate(theNewName);
        }
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete();
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.copyCollisionMode && this.overwriteMode) {
            return true;
        }
        if (this.errorMessage == null) {
            String theNewName = this.newName.getText().trim();
            boolean bl = pageComplete = theNewName.length() > 0;
            if (pageComplete && this.adapter != null) {
                pageComplete = !this.adapter.namesAreEqual(this.inputElement, theNewName);
            }
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public String getNewName() {
        return this.newNameString;
    }

    public String[] getNewNameArray() {
        String[] newNames = new String[]{this.newNameString};
        return newNames;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.overwriteRadio) {
            this.enableRename(!this.overwriteRadio.getSelection());
        }
    }

    private void enableRename(boolean flag) {
        if (this.newName != null) {
            this.renameLabel.setEnabled(flag);
            this.newName.setEnabled(flag);
            this.resourceTypePrompt.setEnabled(flag);
            this.resourceTypeValue.setEnabled(flag);
            this.overwriteMode = !flag;
            this.setPageComplete();
        }
    }
}

