/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.ISystemCopyTargetSelectionCallback;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentProvider;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class SystemSimpleCopyDialog
extends SystemPromptDialog
implements ISystemMessages,
ISelectionChangedListener {
    private String promptString;
    private Label prompt;
    private TreeViewer tree;
    private SystemSimpleContentProvider provider = new SystemSimpleContentProvider();
    private SystemSimpleContentElement copyTreeContent;
    private SystemSimpleContentElement initialSelection;
    private ISystemCopyTargetSelectionCallback caller = null;
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    private Object targetContainer = null;

    public SystemSimpleCopyDialog(Shell shell, String prompt, int mode, ISystemCopyTargetSelectionCallback caller, SystemSimpleContentElement copyTreeContent, SystemSimpleContentElement selection) {
        super(shell, mode == 0 ? SystemResources.RESID_COPY_TITLE : SystemResources.RESID_MOVE_TITLE);
        this.caller = caller;
        if (prompt == null) {
            prompt = mode == 0 ? SystemResources.RESID_COPY_PROMPT : SystemResources.RESID_MOVE_PROMPT;
        }
        this.promptString = prompt;
        this.copyTreeContent = copyTreeContent;
        this.initialSelection = selection;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        return this.tree.getControl();
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 1;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        this.prompt = SystemWidgetHelpers.createLabel(composite_prompts, this.promptString);
        this.tree = new TreeViewer(new Tree(composite_prompts, 2052));
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.widthHint = 300;
        treeData.heightHint = 200;
        treeData.verticalAlignment = 2;
        treeData.grabExcessVerticalSpace = true;
        this.tree.getTree().setLayoutData((Object)treeData);
        this.tree.setContentProvider((IContentProvider)this.provider);
        this.tree.setLabelProvider((IBaseLabelProvider)this.provider);
        if (this.copyTreeContent != null) {
            this.tree.setInput((Object)this.copyTreeContent);
        }
        if (this.initialSelection != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)this.initialSelection), true);
        }
        this.setPageComplete();
        this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
        return composite_prompts;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        SystemSimpleContentElement element = (SystemSimpleContentElement)sel.getFirstElement();
        element.setSelected(true);
        this.setPageComplete();
    }

    public SystemSimpleContentElement getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.tree.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        return (SystemSimpleContentElement)sel.getFirstElement();
    }

    public boolean isSelectionEmpty() {
        IStructuredSelection sel = (IStructuredSelection)this.tree.getSelection();
        return sel.isEmpty();
    }

    public void clearSelection() {
        this.tree.setSelection(null);
    }

    protected boolean processOK() {
        boolean closeDialog = this.verify();
        if (closeDialog) {
            SystemSimpleContentElement seldObj = this.getSelectedElement();
            if (seldObj != null) {
                this.targetContainer = seldObj.getData();
                this.setOutputObject(this.targetContainer);
            } else {
                closeDialog = false;
                this.setPageComplete(false);
            }
        }
        return closeDialog;
    }

    public boolean close() {
        return super.close();
    }

    public boolean verify() {
        Object errMsg = null;
        Object controlInError = null;
        this.clearErrorMessage();
        if (errMsg != null) {
            controlInError.setFocus();
        }
        return errMsg == null;
    }

    public boolean isPageComplete() {
        boolean pageComplete;
        boolean bl = pageComplete = !this.isSelectionEmpty();
        if (pageComplete) {
            pageComplete = this.caller.isValidTargetParent(this.getSelectedElement());
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public Object getTargetContainer() {
        return this.targetContainer;
    }
}

