/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.ISystemPromptDialog;
import org.eclipse.rse.ui.wizards.ISystemWizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemWizardDialog
extends WizardDialog
implements ISystemPromptDialog {
    protected ISystemWizard wizard;
    protected String helpId;

    public SystemWizardDialog(Shell shell, ISystemWizard wizard) {
        super(shell, (IWizard)wizard);
        this.wizard = wizard;
        wizard.setSystemWizardDialog(this);
    }

    public SystemWizardDialog(Shell shell, ISystemWizard wizard, Object inputObject) {
        super(shell, (IWizard)wizard);
        this.wizard = wizard;
        this.setInputObject(inputObject);
        wizard.setSystemWizardDialog(this);
    }

    public void setInputObject(Object inputObject) {
        this.wizard.setInputObject(inputObject);
    }

    public Object getInputObject() {
        return this.wizard.getInputObject();
    }

    public Object getOutputObject() {
        return this.wizard.getOutputObject();
    }

    public boolean wasCancelled() {
        return this.wizard.wasCancelled();
    }

    public void setHelp(String id) {
        this.helpId = id;
        if (this.wizard instanceof ISystemWizard) {
            this.wizard.setHelp(id);
        }
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    protected Control createDialogArea(Composite parent) {
        boolean needsMonitor = this.wizard.needsProgressMonitor();
        Control ctrl = super.createDialogArea(parent);
        if (!needsMonitor) {
            IProgressMonitor pm = this.getProgressMonitor();
            ((ProgressMonitorPart)pm).dispose();
        }
        if (needsMonitor && RSEUIPlugin.isTheSystemRegistryActive()) {
            RSEUIPlugin.getTheSystemRegistry().setRunnableContext(this.getShell(), (IRunnableContext)this);
            this.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RSEUIPlugin.getTheSystemRegistry().clearRunnableContext();
                }
            });
        }
        return ctrl;
    }

    public void updateSize(IWizardPage page) {
        super.updateSize(page);
    }

    public int publicConvertWidthInCharsToPixels(int chars) {
        return this.convertWidthInCharsToPixels(chars);
    }

    public int publicConvertHeightInCharsToPixels(int chars) {
        return this.convertHeightInCharsToPixels(chars);
    }
}

