/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogInterface;
import org.eclipse.rse.ui.filters.SystemFilterPoolManagerUIProvider;
import org.eclipse.rse.ui.filters.SystemFilterUIHelpers;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.rse.ui.filters.dialogs.SystemFilterWorkWithFilterPoolsDialog;
import org.eclipse.rse.ui.validators.ValidatorFilterPoolName;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterWorkWithFilterPoolsAction
extends SystemFilterAbstractFilterPoolAction
implements SystemFilterPoolManagerUIProvider {
    private ValidatorFilterPoolName poolNameValidator = null;

    public SystemFilterWorkWithFilterPoolsAction(Shell parent) {
        super(parent, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.workwithfilterpoolsIcon"), SystemResources.ACTION_WORKWITH_FILTERPOOLS_LABEL, SystemResources.ACTION_WORKWITH_FILTERPOOLS_TOOLTIP);
        this.setContextMenuGroup("group.workwith");
        this.allowOnMultipleSelection(false);
        this.setHelp("org.eclipse.rse.ui.actn0044");
        this.setDialogHelp("org.eclipse.rse.ui.dwfp0000");
    }

    public SystemFilterWorkWithFilterPoolsAction(Shell parent, boolean cascadingAction) {
        super(parent, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.workwithfilterpoolsIcon"), cascadingAction ? SystemResources.ACTION_WORKWITH_FILTERPOOLS_LABEL : SystemResources.ACTION_WORKWITH_WWFILTERPOOLS_LABEL, cascadingAction ? SystemResources.ACTION_WORKWITH_FILTERPOOLS_TOOLTIP : SystemResources.ACTION_WORKWITH_WWFILTERPOOLS_TOOLTIP);
        if (cascadingAction) {
            this.setContextMenuGroup("group.workwith");
        } else {
            this.setContextMenuGroup("group.reorganize");
        }
        this.allowOnMultipleSelection(false);
        this.setHelp("org.eclipse.rse.ui.actn0044");
        this.setDialogHelp("org.eclipse.rse.ui.dwfp0000");
    }

    public SystemFilterWorkWithFilterPoolsAction(Shell parent, String title) {
        super(parent, title);
        this.setContextMenuGroup("group.reorganize");
        this.allowOnMultipleSelection(false);
        this.setHelp("org.eclipse.rse.ui.actn0044");
        this.setDialogHelp("org.eclipse.rse.ui.dwfp0000");
    }

    protected void init() {
        super.init();
        this.dlgInputs.prompt = SystemResources.RESID_WORKWITHFILTERPOOLS_PROMPT;
        this.dlgInputs.title = SystemResources.RESID_WORKWITHFILTERPOOLS_TITLE;
    }

    public void reset() {
    }

    public void setFilterPoolNameValidator(ValidatorFilterPoolName pnv) {
        this.poolNameValidator = pnv;
    }

    public boolean checkObjectType(Object selectedObject) {
        return true;
    }

    public SystemFilterPoolDialogInterface createFilterPoolDialog(Shell parent) {
        SystemFilterWorkWithFilterPoolsDialog dialog = new SystemFilterWorkWithFilterPoolsDialog(parent, this.getDialogTitle(), this.getDialogPrompt(), this);
        if (this.poolNameValidator != null) {
            dialog.setFilterPoolNameValidator(this.poolNameValidator);
        }
        return dialog;
    }

    public SystemSimpleContentElement getTreeModel() {
        ISystemFilterPoolManager[] mgrs = this.getFilterPoolManagers();
        SystemSimpleContentElement input = SystemFilterUIHelpers.getFilterPoolModel(this.getFilterPoolManagerProvider(), mgrs);
        return input;
    }

    public SystemSimpleContentElement getTreeModelPreSelection(SystemSimpleContentElement input) {
        ISystemFilterPoolManager initialSelection;
        ISystemFilterPoolReferenceManagerProvider sprmp = this.getReferenceManagerProviderSelection();
        SystemSimpleContentElement initialElementSelection = null;
        if (sprmp != null && (initialSelection = sprmp.getSystemFilterPoolReferenceManager().getDefaultSystemFilterPoolManager()) != null) {
            initialElementSelection = SystemFilterUIHelpers.getDataElement(input, initialSelection);
        }
        return initialElementSelection;
    }

    protected Object getDialogValue(Dialog dlg) {
        return null;
    }

    public void doOKprocessing(Object dlgValue) {
    }
}

