/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.rse.ui.view.team.SystemTeamViewSubSystemFactoryNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SystemTeamViewSubSystemFactoryPropertyPage
extends SystemBasePropertyPage
implements ISystemMessages {
    protected Label labelType;
    protected Label labelName;
    protected Label labelId;
    protected Label labelVendor;
    protected Label labelTypes;
    protected String errorMessage;
    protected boolean initDone = false;

    protected Control createContentArea(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        this.labelType = this.createLabeledLabel(composite_prompts, SystemPropertyResources.RESID_PROPERTY_TYPE_LABEL, SystemPropertyResources.RESID_PROPERTY_TYPE_TOOLTIP);
        this.labelType.setText(SystemViewResources.RESID_PROPERTY_TEAM_SSFACTORY_TYPE_VALUE);
        this.labelName = this.createLabeledLabel(composite_prompts, SystemPropertyResources.RESID_PROPERTY_NAME_LABEL, SystemPropertyResources.RESID_PROPERTY_NAME_TOOLTIP);
        this.labelId = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_SUBSYSFACTORY_ID_LABEL, SystemResources.RESID_PP_SUBSYSFACTORY_ID_TOOLTIP);
        this.labelVendor = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_SUBSYSFACTORY_VENDOR_LABEL, SystemResources.RESID_PP_SUBSYSFACTORY_VENDOR_TOOLTIP);
        this.labelTypes = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_SUBSYSFACTORY_TYPES_LABEL, SystemResources.RESID_PP_SUBSYSFACTORY_TYPES_TOOLTIP);
        this.addFillerLine(composite_prompts, nbrColumns);
        this.addSeparatorLine(composite_prompts, nbrColumns);
        SystemWidgetHelpers.createVerbage(composite_prompts, SystemResources.RESID_PP_SUBSYSFACTORY_VERBAGE, nbrColumns, false, 200);
        if (!this.initDone) {
            this.doInitializeFields();
        }
        return composite_prompts;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    protected ISubSystemConfiguration getSubSystemFactory() {
        IAdaptable element = this.getElement();
        SystemTeamViewSubSystemFactoryNode ssfNode = (SystemTeamViewSubSystemFactoryNode)element;
        return ssfNode.getSubSystemFactory();
    }

    protected void doInitializeFields() {
        this.initDone = true;
        ISubSystemConfiguration ssf = this.getSubSystemFactory();
        ISubSystemConfigurationProxy proxy = ssf.getSubSystemFactoryProxy();
        this.labelName.setText(ssf.getName());
        this.labelId.setText(proxy.getId());
        this.labelVendor.setText(proxy.getVendor());
        String systypes = "";
        String[] types = ssf.getSystemTypes();
        if (ssf.getSubSystemFactoryProxy().supportsAllSystemTypes()) {
            systypes = SystemResources.TERM_ALL;
        } else {
            int idx = 0;
            while (idx < types.length) {
                systypes = idx == 0 ? String.valueOf(systypes) + types[idx] : String.valueOf(systypes) + ", " + types[idx];
                ++idx;
            }
        }
        this.labelTypes.setText(systypes);
    }

    public boolean performOk() {
        boolean ok = true;
        return ok;
    }
}

