/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Vector;
import org.eclipse.rse.filters.ISystemFilterString;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorFilterString
extends ValidatorUniqueString
implements ISystemMessages,
ISystemValidator {
    public static final int MAX_FILTERSTRINGNAME_LENGTH = 1000;
    protected SystemMessage msg_Invalid;

    public ValidatorFilterString(Vector existingList, boolean caseSensitive) {
        super(existingList, caseSensitive);
        this.init();
    }

    public ValidatorFilterString(String[] existingList, boolean caseSensitive) {
        super(existingList, caseSensitive);
        this.init();
    }

    public ValidatorFilterString(ISystemFilterString[] existingList, boolean caseSensitive) {
        super(ValidatorFilterString.convertFilterStringsToStrings(existingList), caseSensitive);
        this.init();
    }

    public ValidatorFilterString(boolean caseSensitive) {
        super(new String[0], caseSensitive);
        this.init();
    }

    public void setDuplicateFilterStringErrorMessage(SystemMessage msg) {
        super.setErrorMessages(null, this.msg_NonUnique);
    }

    protected static String[] convertFilterStringsToStrings(ISystemFilterString[] filterStrings) {
        if (filterStrings == null) {
            return new String[0];
        }
        String[] strings = new String[filterStrings.length];
        int idx = 0;
        while (idx < filterStrings.length) {
            strings[idx] = filterStrings[idx].getString();
            ++idx;
        }
        return strings;
    }

    private void init() {
        this.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1045"), RSEUIPlugin.getPluginMessage("RSEG1046"), RSEUIPlugin.getPluginMessage("RSEG1047"));
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    public String toString() {
        return "ValidatorFilterString class";
    }

    public SystemMessage isSyntaxOk(String newText) {
        return null;
    }

    public int getMaximumNameLength() {
        return 1000;
    }
}

