/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.servicesubsystem.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.ISystemFilterString;
import org.eclipse.rse.filters.SystemFilterPoolWrapperInformation;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemClearPasswordAction;
import org.eclipse.rse.ui.actions.SystemConnectAction;
import org.eclipse.rse.ui.actions.SystemDisconnectAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.filters.actions.ISystemNewFilterActionConfigurator;
import org.eclipse.rse.ui.filters.actions.SystemChangeFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterCascadingNewFilterPoolReferenceAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterCopyFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterCopyFilterPoolAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterMoveDownFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterMoveDownFilterPoolReferenceAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterMoveFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterMoveFilterPoolAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterMoveUpFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterMoveUpFilterPoolReferenceAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterNewFilterPoolAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterRemoveFilterPoolReferenceAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterSelectFilterPoolsAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterWorkWithFilterPoolsAction;
import org.eclipse.rse.ui.filters.actions.SystemNewFilterAction;
import org.eclipse.rse.ui.filters.dialogs.SystemChangeFilterDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.ISystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.propertypages.SystemChangeFilterPropertyPage;
import org.eclipse.rse.ui.propertypages.SystemFilterStringPropertyPage;
import org.eclipse.rse.ui.propertypages.SystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.widgets.IBMServerLauncherForm;
import org.eclipse.rse.ui.widgets.IServerLauncherForm;
import org.eclipse.rse.ui.wizards.ISystemNewConnectionWizardPage;
import org.eclipse.rse.ui.wizards.SubSystemServiceWizardPage;
import org.eclipse.rse.ui.wizards.SystemSubSystemsPropertiesWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class SubsystemFactoryAdapter
implements ISubsystemConfigurationAdapter,
ISystemNewFilterActionConfigurator {
    protected Hashtable imageTable = null;
    private IAction[] subSystemActions = null;
    private IAction[] filterPoolActions = null;
    private IAction[] filterPoolReferenceActions = null;
    private IAction[] filterActions = null;
    static /* synthetic */ Class class$0;

    public void addCommonRemoteActions(ISubSystemConfiguration factory, SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystem subsystem) {
    }

    public ISystemNewConnectionWizardPage[] getNewConnectionWizardPages(ISubSystemConfiguration factory, IWizard wizard) {
        if (factory instanceof IServiceSubSystemConfiguration) {
            SubSystemServiceWizardPage page = new SubSystemServiceWizardPage(wizard, factory);
            return new ISystemNewConnectionWizardPage[]{page};
        }
        List pages = this.getSubSystemPropertyPages(factory);
        if (pages != null && pages.size() > 0) {
            SystemSubSystemsPropertiesWizardPage page = new SystemSubSystemsPropertiesWizardPage(wizard, factory, pages);
            return new ISystemNewConnectionWizardPage[]{page};
        }
        return new ISystemNewConnectionWizardPage[0];
    }

    public ISystemSubSystemPropertyPageCoreForm getSubSystemPropertyPageCoreFrom(ISubSystemConfiguration factory, ISystemMessageLine msgLine, Object caller) {
        return new SystemSubSystemPropertyPageCoreForm(msgLine, caller);
    }

    protected List getSubSystemPropertyPages(ISubSystemConfiguration factory) {
        ArrayList<PropertyPage> propertyPages = new ArrayList<PropertyPage>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] propertyPageExtensions = registry.getConfigurationElementsFor("org.eclipse.ui", "propertyPages");
        int i = 0;
        while (i < propertyPageExtensions.length) {
            IConfigurationElement configurationElement = propertyPageExtensions[i];
            String objectClass = configurationElement.getAttribute("objectClass");
            String name = configurationElement.getAttribute("name");
            Class<?> objCls = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                objCls = Class.forName(objectClass, false, loader);
            }
            catch (Exception exception) {}
            if (objCls != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.core.subsystems.ISubSystem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(objCls) && factory.isFactoryFor(objCls)) {
                    try {
                        PropertyPage page = (PropertyPage)configurationElement.createExecutableExtension("class");
                        page.setTitle(name);
                        propertyPages.add(page);
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
        return propertyPages;
    }

    public ImageDescriptor getImage(ISubSystemConfiguration factory) {
        return factory.getImage();
    }

    public Image getGraphicsImage(ISubSystemConfiguration factory) {
        ImageDescriptor id = this.getImage(factory);
        if (id != null) {
            Image image = null;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable();
            } else {
                image = (Image)this.imageTable.get(id);
            }
            if (image == null) {
                image = id.createImage();
                this.imageTable.put(id, image);
            }
            return image;
        }
        return null;
    }

    public ImageDescriptor getLiveImage(ISubSystemConfiguration factory) {
        return factory.getLiveImage();
    }

    public Image getGraphicsLiveImage(ISubSystemConfiguration factory) {
        ImageDescriptor id = this.getLiveImage(factory);
        if (id != null) {
            Image image = null;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable();
            } else {
                image = (Image)this.imageTable.get(id);
            }
            if (image == null) {
                image = id.createImage();
                this.imageTable.put(id, image);
            }
            return image;
        }
        return null;
    }

    public IAction[] getSubSystemActions(ISubSystemConfiguration factory, ISubSystem selectedSubSystem, Shell shell) {
        int idx;
        Vector ourChildActions = this.getAdditionalSubSystemActions(factory, selectedSubSystem, shell);
        Vector childActions = new Vector();
        if (ourChildActions != null) {
            int idx2 = 0;
            while (idx2 < ourChildActions.size()) {
                childActions.addElement(ourChildActions.elementAt(idx2));
                ++idx2;
            }
        }
        if (factory.supportsFilters()) {
            IAction[] newFilterActions;
            IAction[] newFPActions;
            boolean showFilterPools = factory.showFilterPools();
            if (showFilterPools && (newFPActions = this.getSubSystemNewFilterPoolActions(factory, selectedSubSystem, shell)) != null) {
                idx = 0;
                while (idx < newFPActions.length) {
                    if (newFPActions[idx] instanceof SystemFilterAbstractFilterPoolAction) {
                        SystemFilterAbstractFilterPoolAction fpAction = (SystemFilterAbstractFilterPoolAction)newFPActions[idx];
                        fpAction.setFilterPoolManagerNamePreSelection(selectedSubSystem.getSystemProfile().getName());
                        fpAction.setFilterPoolManagerProvider(factory);
                    }
                    childActions.addElement(newFPActions[idx]);
                    ++idx;
                }
            }
            if (showFilterPools) {
                childActions.addElement(new SystemFilterSelectFilterPoolsAction(shell));
                childActions.addElement(new SystemFilterWorkWithFilterPoolsAction(shell));
            }
            if (!showFilterPools && (newFilterActions = this.getNewFilterPoolFilterActions(factory, null, shell)) != null && newFilterActions.length > 0) {
                idx = 0;
                while (idx < newFilterActions.length) {
                    if (newFilterActions[idx] instanceof SystemNewFilterAction) {
                        ((SystemNewFilterAction)newFilterActions[idx]).setCallBackConfigurator(this, selectedSubSystem);
                    }
                    ++idx;
                }
                idx = 0;
                while (idx < newFilterActions.length) {
                    childActions.addElement(newFilterActions[idx]);
                    ++idx;
                }
            }
        }
        if (factory.supportsSubSystemConnect()) {
            this.addConnectOrDisconnectAction(childActions, shell, selectedSubSystem);
        }
        if (this.subSystemActions == null) {
            int nbrBaseActions = 0;
            if (factory.supportsSubSystemConnect() && factory.supportsUserId()) {
                ++nbrBaseActions;
            }
            this.subSystemActions = new IAction[nbrBaseActions];
            int ssIdx = 0;
            if (factory.supportsSubSystemConnect() && factory.supportsUserId()) {
                this.subSystemActions[ssIdx++] = new SystemClearPasswordAction(shell);
            }
        }
        IAction[] allActions = new IAction[childActions.size() + this.subSystemActions.length];
        int allIndex = 0;
        idx = 0;
        while (idx < childActions.size()) {
            allActions[allIndex++] = (IAction)childActions.elementAt(idx);
            ++idx;
        }
        idx = 0;
        while (idx < this.subSystemActions.length) {
            allActions[allIndex++] = this.subSystemActions[idx];
            ++idx;
        }
        return allActions;
    }

    private void addConnectOrDisconnectAction(Vector actions, Shell shell, ISubSystem selectedSS) {
        boolean connected = selectedSS.isConnected();
        if (connected) {
            actions.addElement(new SystemDisconnectAction(shell));
        } else {
            actions.addElement(new SystemConnectAction(shell));
        }
    }

    public void configureNewFilterAction(ISubSystemConfiguration factory, SystemNewFilterAction newFilterAction, Object callerData) {
        newFilterAction.setFromRSE(true);
        boolean showFilterPools = factory.showFilterPools();
        if (!showFilterPools) {
            ISubSystem selectedSubSystem = (ISubSystem)callerData;
            boolean advancedUser = false;
            ISystemFilterPoolReferenceManager refMgr = selectedSubSystem.getSystemFilterPoolReferenceManager();
            ISystemFilterPool[] refdPools = refMgr.getReferencedSystemFilterPools();
            if (refdPools.length == 0) {
                SystemBasePlugin.logInfo("SubSystemFactoryImpl::getSubSystemActions - getReferencedSystemFilterPools returned array of length zero.");
            } else if (refdPools.length > 1) {
                int idx = 0;
                while (!advancedUser && idx < refdPools.length) {
                    if (!refdPools[idx].isDefault() && refdPools[idx].getOwningParentName() == null) {
                        advancedUser = true;
                    }
                    ++idx;
                }
            }
            if (advancedUser) {
                newFilterAction.setAllowFilterPoolSelection(refdPools);
            } else {
                boolean anyAdded = false;
                SystemFilterPoolWrapperInformation poolWrapperInfo = this.getNewFilterWizardPoolWrapperInformation();
                ISystemProfile[] activeProfiles = RSEUIPlugin.getTheSystemRegistry().getActiveSystemProfiles();
                ISystemProfile activeProfile = selectedSubSystem.getHost().getSystemProfile();
                int idx = 0;
                while (idx < activeProfiles.length) {
                    ISystemFilterPool defaultPool = this.getDefaultSystemFilterPool(factory, activeProfiles[idx]);
                    if (defaultPool != null) {
                        poolWrapperInfo.addWrapper(activeProfiles[idx].getName(), defaultPool, activeProfiles[idx] == activeProfile);
                        anyAdded = true;
                    }
                    ++idx;
                }
                if (anyAdded) {
                    newFilterAction.setAllowFilterPoolSelection(poolWrapperInfo);
                }
            }
        }
    }

    public ISystemFilterPool getDefaultSystemFilterPool(ISubSystemConfiguration factory, ISystemProfile profile) {
        ISystemFilterPool pool = null;
        ISystemFilterPoolManager mgr = factory.getFilterPoolManager(profile);
        pool = mgr.getFirstDefaultSystemFilterPool();
        return pool;
    }

    protected SystemFilterPoolWrapperInformation getNewFilterWizardPoolWrapperInformation() {
        return new SystemFilterPoolWrapperInformation(SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_LABEL, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_TOOLTIP, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_VERBAGE);
    }

    protected IAction[] getSubSystemNewFilterPoolActions(ISubSystemConfiguration factory, ISubSystem selectedSubSystem, Shell shell) {
        IAction[] actions = new IAction[2];
        actions[0] = new SystemFilterNewFilterPoolAction(shell);
        ((ISystemAction)actions[0]).setHelp("org.eclipse.rse.ui.actn0040");
        ((SystemFilterNewFilterPoolAction)actions[0]).setDialogHelp("org.eclipse.rse.ui.wnfp0000");
        actions[1] = new SystemFilterCascadingNewFilterPoolReferenceAction(shell, selectedSubSystem.getSystemFilterPoolReferenceManager());
        ((ISystemAction)actions[1]).setHelp("org.eclipse.rse.ui.actn0041");
        return actions;
    }

    protected Vector getAdditionalSubSystemActions(ISubSystemConfiguration factory, ISubSystem selectedSubSystem, Shell shell) {
        return null;
    }

    public ImageDescriptor getSystemFilterPoolManagerImage() {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemprofileIcon");
    }

    public ImageDescriptor getSystemFilterPoolImage(ISystemFilterPool filterPool) {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
    }

    public ImageDescriptor getSystemFilterImage(ISystemFilter filter) {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon");
    }

    public ImageDescriptor getSystemFilterStringImage(ISystemFilterString filterString) {
        return this.getSystemFilterStringImage(filterString.getString());
    }

    public ImageDescriptor getSystemFilterStringImage(String filterStringString) {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterstringIcon");
    }

    public IAction[] getFilterPoolActions(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        int idx;
        IAction[] newActions;
        Vector childActions = new Vector();
        Vector ourChildActions = this.getAdditionalFilterPoolActions(factory, selectedPool, shell);
        if (ourChildActions != null) {
            int idx2 = 0;
            while (idx2 < ourChildActions.size()) {
                childActions.addElement(ourChildActions.elementAt(idx2));
                ++idx2;
            }
        }
        if ((newActions = this.getNewFilterPoolFilterActions(factory, selectedPool, shell)) != null) {
            idx = 0;
            while (idx < newActions.length) {
                childActions.addElement(newActions[idx]);
                ++idx;
            }
        }
        if (this.filterPoolActions == null) {
            int nbr = 2;
            this.filterPoolActions = new IAction[nbr];
            SystemFilterCopyFilterPoolAction copyAction = new SystemFilterCopyFilterPoolAction(shell);
            copyAction.setPromptString(SystemResources.RESID_COPY_TARGET_PROFILE_PROMPT);
            copyAction.setHelp("org.eclipse.rse.ui.actn0060");
            copyAction.setDialogHelp("org.eclipse.rse.ui.dcfp0000");
            SystemFilterMoveFilterPoolAction moveAction = new SystemFilterMoveFilterPoolAction(shell);
            moveAction.setPromptString(SystemResources.RESID_MOVE_TARGET_PROFILE_PROMPT);
            moveAction.setHelp("org.eclipse.rse.ui.actn0061");
            moveAction.setDialogHelp("org.eclipse.rse.ui.dmfp0000");
            this.filterPoolActions[0] = copyAction;
            this.filterPoolActions[1] = moveAction;
        }
        idx = 0;
        while (idx < this.filterPoolActions.length) {
            childActions.addElement(this.filterPoolActions[idx]);
            ++idx;
        }
        IAction[] allFilterPoolActions = new IAction[childActions.size()];
        int idx3 = 0;
        while (idx3 < childActions.size()) {
            allFilterPoolActions[idx3] = (IAction)childActions.elementAt(idx3);
            ++idx3;
        }
        return allFilterPoolActions;
    }

    protected Vector getAdditionalFilterPoolActions(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        return null;
    }

    protected IAction[] getNewFilterPoolFilterActions(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        IAction[] actions = new IAction[]{this.getNewFilterPoolFilterAction(factory, selectedPool, shell)};
        return actions;
    }

    protected IAction getNewFilterPoolFilterAction(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        SystemNewFilterAction action = new SystemNewFilterAction(shell, selectedPool);
        action.setHelp("org.eclipse.rse.ui.actn0042");
        action.setDialogHelp("org.eclipse.rse.ui.wnfr0000");
        return action;
    }

    protected IAction getNewNestedFilterAction(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        return this.getNewFilterPoolFilterAction(factory, selectedFilter.getParentFilterPool(), shell);
    }

    protected IAction getChangeFilterAction(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        SystemChangeFilterAction action = new SystemChangeFilterAction(shell);
        action.setHelp("org.eclipse.rse.ui.actn0081");
        action.setDialogHelp("org.eclipse.rse.ui.dufr0000");
        return action;
    }

    public void customizeChangeFilterPropertyPage(ISubSystemConfiguration factory, SystemChangeFilterPropertyPage page, ISystemFilter selectedFilter, Shell shell) {
        boolean singleFilterString;
        IAction changeAction = this.getChangeFilterAction(factory, selectedFilter, shell);
        if (changeAction instanceof SystemChangeFilterAction) {
            SystemChangeFilterAction changeFilterAction = (SystemChangeFilterAction)changeAction;
            changeFilterAction.setSelection((ISelection)new StructuredSelection((Object)selectedFilter));
            Dialog dlg = changeFilterAction.createDialog(shell);
            if (dlg instanceof SystemChangeFilterDialog) {
                SystemChangeFilterDialog changeFilterDlg = (SystemChangeFilterDialog)dlg;
                page.setDuplicateFilterStringErrorMessage(changeFilterDlg.getDuplicateFilterStringErrorMessage());
                page.setFilterStringEditPane(changeFilterDlg.getFilterStringEditPane(shell));
                page.setFilterStringValidator(changeFilterDlg.getFilterStringValidator());
                page.setListLabel(changeFilterDlg.getListLabel(), changeFilterDlg.getListTip());
                page.setParentPoolPromptLabel(changeFilterDlg.getParentPoolPromptLabel(), changeFilterDlg.getParentPoolPromptTip());
                page.setNamePromptLabel(changeFilterDlg.getNamePromptLabel(), changeFilterDlg.getNamePromptTip());
                page.setNewListItemText(changeFilterDlg.getNewListItemText());
                page.setDescription(changeFilterDlg.getTitle());
            }
        }
        if (selectedFilter.isNonChangable()) {
            page.setEditable(false);
        }
        boolean bl = singleFilterString = selectedFilter.isSingleFilterStringOnly() || selectedFilter.isNonChangable() && selectedFilter.getFilterStringCount() == 1;
        if (singleFilterString) {
            page.setSupportsMultipleStrings(false);
        }
    }

    public void customizeFilterStringPropertyPage(ISubSystemConfiguration factory, SystemFilterStringPropertyPage page, ISystemFilterString selectedFilterString, Shell shell) {
        ISystemFilter selectedFilter = selectedFilterString.getParentSystemFilter();
        IAction changeAction = this.getChangeFilterAction(factory, selectedFilter, shell);
        if (changeAction instanceof SystemChangeFilterAction) {
            SystemChangeFilterAction changeFilterAction = (SystemChangeFilterAction)changeAction;
            changeFilterAction.setSelection((ISelection)new StructuredSelection((Object)selectedFilter));
            Dialog dlg = changeFilterAction.createDialog(shell);
            if (dlg instanceof SystemChangeFilterDialog) {
                SystemChangeFilterDialog changeFilterDlg = (SystemChangeFilterDialog)dlg;
                page.setDuplicateFilterStringErrorMessage(changeFilterDlg.getDuplicateFilterStringErrorMessage());
                page.setFilterStringEditPane(changeFilterDlg.getFilterStringEditPane(shell));
                page.setFilterStringValidator(changeFilterDlg.getFilterStringValidator());
                page.setDescription(changeFilterDlg.getTitle());
            }
        }
        if (selectedFilter.isNonChangable()) {
            page.setEditable(false);
        }
    }

    public IAction[] getFilterPoolReferenceActions(ISubSystemConfiguration factory, ISystemFilterPoolReference selectedPoolRef, Shell shell) {
        ISystemFilterPool selectedPool = selectedPoolRef.getReferencedFilterPool();
        Vector childActions = this.getAdditionalFilterPoolReferenceActions(factory, selectedPool, shell);
        int nbrChildActions = 0;
        if (childActions != null) {
            nbrChildActions = childActions.size();
        }
        int fpIdx = 0;
        if (this.filterPoolReferenceActions == null) {
            int nbr = 3;
            this.filterPoolReferenceActions = new IAction[nbr + nbrChildActions];
            this.filterPoolReferenceActions[fpIdx++] = this.getRemoveFilterPoolReferenceAction(factory, selectedPool, shell);
            this.filterPoolReferenceActions[fpIdx] = new SystemFilterMoveUpFilterPoolReferenceAction(shell);
            ((ISystemAction)this.filterPoolReferenceActions[fpIdx++]).setHelp("org.eclipse.rse.ui.actn0063");
            this.filterPoolReferenceActions[fpIdx] = new SystemFilterMoveDownFilterPoolReferenceAction(shell);
            ((ISystemAction)this.filterPoolReferenceActions[fpIdx++]).setHelp("org.eclipse.rse.ui.actn0064");
        }
        if (childActions != null) {
            int idx = 0;
            while (idx < nbrChildActions) {
                this.filterPoolReferenceActions[fpIdx++] = (IAction)childActions.elementAt(idx);
                ++idx;
            }
        }
        return this.filterPoolReferenceActions;
    }

    protected Vector getAdditionalFilterPoolReferenceActions(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        return null;
    }

    protected IAction getRemoveFilterPoolReferenceAction(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        SystemFilterRemoveFilterPoolReferenceAction action = new SystemFilterRemoveFilterPoolReferenceAction(shell);
        action.setHelp("org.eclipse.rse.ui.actn0062");
        return action;
    }

    public ISystemFilter createFilterByPrompting(ISubSystemConfiguration factory, ISystemFilterReference referenceToPromptableFilter, Shell shell) throws Exception {
        ISystemFilter filterPrompt = referenceToPromptableFilter.getReferencedFilter();
        ISystemFilterPool selectedPool = filterPrompt.getParentFilterPool();
        SystemNewFilterAction action = new SystemNewFilterAction(shell, selectedPool);
        Object simulatedSelectedParent = null;
        if (!factory.showFilterPools()) {
            simulatedSelectedParent = referenceToPromptableFilter.getProvider();
            action.setCallBackConfigurator(this, simulatedSelectedParent);
        } else {
            simulatedSelectedParent = referenceToPromptableFilter.getParentSystemFilterReferencePool();
            action.setCallBackConfigurator(this, referenceToPromptableFilter.getProvider());
        }
        action.setSelection((ISelection)new StructuredSelection(simulatedSelectedParent));
        action.run();
        ISystemFilter newFilter = action.getNewFilter();
        return newFilter;
    }

    public IAction[] getFilterActions(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        IAction chgFilterAction;
        IAction newNestedFilterAction;
        Vector childActions = new Vector();
        Vector ourChildActions = this.getAdditionalFilterActions(factory, selectedFilter, shell);
        int pasteIndex = -1;
        if (ourChildActions != null) {
            int idx = 0;
            while (idx < ourChildActions.size()) {
                if (ourChildActions.elementAt(idx) instanceof SystemPasteFromClipboardAction) {
                    pasteIndex = idx;
                } else {
                    childActions.addElement(ourChildActions.elementAt(idx));
                }
                ++idx;
            }
        }
        if (this.filterActions == null) {
            int additionalActions = 4;
            if (pasteIndex > -1) {
                ++additionalActions;
            }
            int fsIdx = 0;
            this.filterActions = new IAction[additionalActions];
            SystemFilterCopyFilterAction copyAction = new SystemFilterCopyFilterAction(shell);
            copyAction.setPromptString(SystemResources.RESID_COPY_TARGET_FILTERPOOL_PROMPT);
            copyAction.setHelp("org.eclipse.rse.ui.actn0082");
            copyAction.setDialogHelp("org.eclipse.rse.ui.dcfr0000");
            this.filterActions[fsIdx++] = copyAction;
            if (pasteIndex > -1) {
                this.filterActions[fsIdx++] = (IAction)ourChildActions.elementAt(pasteIndex);
            }
            SystemFilterMoveFilterAction moveAction = new SystemFilterMoveFilterAction(shell);
            moveAction.setPromptString(SystemResources.RESID_MOVE_TARGET_FILTERPOOL_PROMPT);
            moveAction.setHelp("org.eclipse.rse.ui.actn0083");
            moveAction.setDialogHelp("org.eclipse.rse.ui.dmfr0000");
            this.filterActions[fsIdx++] = moveAction;
            this.filterActions[fsIdx] = new SystemFilterMoveUpFilterAction(shell);
            ((SystemFilterMoveUpFilterAction)this.filterActions[fsIdx++]).setHelp("org.eclipse.rse.ui.actn0084");
            this.filterActions[fsIdx] = new SystemFilterMoveDownFilterAction(shell);
            ((SystemFilterMoveDownFilterAction)this.filterActions[fsIdx++]).setHelp("org.eclipse.rse.ui.actn0085");
        }
        if (factory.supportsNestedFilters() && (newNestedFilterAction = this.getNewNestedFilterAction(factory, selectedFilter, shell)) != null) {
            childActions.addElement(newNestedFilterAction);
        }
        if ((chgFilterAction = this.getChangeFilterAction(factory, selectedFilter, shell)) != null) {
            childActions.addElement(chgFilterAction);
        }
        IAction[] allFilterActions = new IAction[childActions.size() + this.filterActions.length];
        int allIdx = 0;
        if (childActions != null) {
            int idx = 0;
            while (idx < childActions.size()) {
                allFilterActions[allIdx++] = (IAction)childActions.elementAt(idx);
                ++idx;
            }
        }
        int idx = 0;
        while (idx < this.filterActions.length) {
            allFilterActions[allIdx++] = this.filterActions[idx];
            ++idx;
        }
        return allFilterActions;
    }

    protected Vector getAdditionalFilterActions(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        return null;
    }

    public IAction[] getFilterReferenceActions(ISubSystemConfiguration factory, ISystemFilterReference selectedFilterRef, Shell shell) {
        Vector childActions = this.getAdditionalFilterReferenceActions(factory, selectedFilterRef, shell);
        int nbrChildActions = 0;
        if (childActions != null) {
            nbrChildActions = childActions.size();
        } else {
            childActions = new Vector();
        }
        IAction[] allFilterRefActions = new IAction[nbrChildActions];
        int idx = 0;
        while (idx < nbrChildActions) {
            allFilterRefActions[idx] = (IAction)childActions.elementAt(idx);
            ++idx;
        }
        return allFilterRefActions;
    }

    protected Vector getAdditionalFilterReferenceActions(ISubSystemConfiguration factory, ISystemFilterReference selectedFilterRef, Shell shell) {
        return null;
    }

    public IServerLauncherForm getServerLauncherForm(ISubSystemConfiguration factory, Shell shell, ISystemMessageLine msgLine) {
        return new IBMServerLauncherForm(shell, msgLine);
    }

    public void renameSubSystemProfile(ISubSystemConfiguration factory, String oldProfileName, String newProfileName) {
        ISystemProfile profile = factory.getSystemProfile(newProfileName);
        factory.renameFilterPoolManager(profile);
        ISystemFilterPool defaultPoolForThisProfile = factory.getDefaultFilterPool(profile, oldProfileName);
        if (defaultPoolForThisProfile != null) {
            try {
                factory.getFilterPoolManager(profile).renameSystemFilterPool(defaultPoolForThisProfile, SubSystemConfiguration.getDefaultFilterPoolName(newProfileName, factory.getId()));
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Unexpected error renaming default filter pool " + SubSystemConfiguration.getDefaultFilterPoolName(newProfileName, factory.getId()), exc);
                System.out.println("Unexpected error renaming default filter pool " + SubSystemConfiguration.getDefaultFilterPoolName(newProfileName, factory.getId()) + ": " + exc);
            }
        }
    }
}

