/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.ISystemFilterString;
import org.eclipse.rse.filters.ISystemFilterStringReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.SystemMessageObject;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.SystemAbstractAPIProvider;

public class SystemViewAPIProviderForFilterStrings
extends SystemAbstractAPIProvider
implements ISystemMessages {
    protected ISubSystem subsystem = null;
    protected ISystemFilterPool filterPool = null;
    protected ISystemFilterPoolReference filterPoolReference = null;
    protected ISystemFilterReference filterReference = null;
    protected ISystemFilter filter = null;
    protected ISystemFilterString filterString = null;
    protected ISystemFilterStringReference filterStringReference = null;

    public SystemViewAPIProviderForFilterStrings(ISystemFilterStringReference filterStringReference) {
        this.setFilterStringReference(filterStringReference);
    }

    public ISubSystem getSubSystem() {
        return this.subsystem;
    }

    public ISystemFilterPoolReference getSystemFilterPoolReference() {
        return this.filterPoolReference;
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this.filterPool;
    }

    public ISystemFilterReference getSystemFilterReference() {
        return this.filterReference;
    }

    public ISystemFilter getSystemFilter() {
        return this.filter;
    }

    public ISystemFilterStringReference getSystemFilterStringReference() {
        return this.filterStringReference;
    }

    public ISystemFilterString getSystemFilterString() {
        return this.filterString;
    }

    public void setFilterStringReference(ISystemFilterStringReference filterStringReference) {
        this.filterStringReference = filterStringReference;
        this.filterString = filterStringReference.getReferencedFilterString();
        this.filterReference = filterStringReference.getParent();
        this.filter = this.filterReference.getReferencedFilter();
        this.filterPoolReference = this.filterReference.getParentSystemFilterReferencePool();
        this.filterPool = this.filterPoolReference.getReferencedFilterPool();
        this.subsystem = (ISubSystem)this.filterPoolReference.getProvider();
    }

    public Object[] getSystemViewRoots() {
        ISubSystem ss = this.subsystem;
        ISystemFilterStringReference element = this.filterStringReference;
        Object[] children = null;
        try {
            children = ss.resolveFilterString(this.filterStringReference.getString(), this.getShell());
            if (children == null || children.length == 0) {
                children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1100"), 3, element)};
            }
        }
        catch (InterruptedException interruptedException) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, element)};
            System.out.println("Canceled.");
        }
        catch (Exception exc) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, element)};
            System.out.println("Exception resolving filter strings: " + exc.getClass().getName() + ", " + exc.getMessage());
            exc.printStackTrace();
        }
        return children;
    }

    public boolean hasSystemViewRoots() {
        return true;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return false;
    }

    public boolean showActions() {
        return true;
    }
}

