/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class SystemViewDataDragAdapter
extends DragSourceAdapter {
    ISelectionProvider _selectionProvider;
    public static final char CONNECTION_DELIMITER = ':';
    public static final char RESOURCE_SEPARATOR = '|';
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SystemViewDataDragAdapter(ISelectionProvider provider) {
        this._selectionProvider = provider;
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
    }

    private void serializeObject(Object dragObject, ISystemDragDropAdapter adapter, StringBuffer dataStream) {
        ISubSystem subSystem = null;
        if (dragObject instanceof ISubSystem) {
            subSystem = (ISubSystem)dragObject;
            String subSystemId = RSEUIPlugin.getTheSystemRegistry().getAbsoluteNameForSubSystem(subSystem);
            dataStream.append(subSystemId);
        } else if (dragObject instanceof IHost) {
            IHost connection = (IHost)dragObject;
            String connectionId = RSEUIPlugin.getTheSystemRegistry().getAbsoluteNameForConnection(connection);
            dataStream.append(connectionId);
        } else {
            subSystem = adapter.getSubSystem(dragObject);
            if (subSystem != null) {
                String subSystemId = RSEUIPlugin.getTheSystemRegistry().getAbsoluteNameForSubSystem(subSystem);
                dataStream.append(subSystemId);
            }
            String objectId = adapter.getAbsoluteName(dragObject);
            dataStream.append(":");
            dataStream.append(objectId);
        }
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this._selectionProvider.getSelection();
        RSEUIPlugin.getTheSystemRegistry();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            while (iterator.hasNext()) {
                Object dragObject = iterator.next();
                if (dragObject instanceof IAdaptable) {
                    ISystemDragDropAdapter adapter;
                    IAdaptable iAdaptable = (IAdaptable)dragObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) == null || !adapter.canDrag(dragObject)) {
                        event.doit = false;
                        event.detail = 0;
                        continue;
                    }
                    if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                        if (!(adapter instanceof ISystemRemoteElementAdapter)) continue;
                        if (((ISystemRemoteElementAdapter)((Object)adapter)).canEdit(dragObject)) {
                            event.doit = true;
                            continue;
                        }
                        event.doit = false;
                        event.detail = 0;
                        return;
                    }
                    event.doit = true;
                    continue;
                }
                event.doit = false;
                event.detail = 0;
                return;
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        ISelection selection = this._selectionProvider.getSelection();
        RSEUIPlugin.getTheSystemRegistry();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
                StringBuffer dataStream = new StringBuffer("");
                Iterator iterator = ss.iterator();
                while (iterator.hasNext()) {
                    ISystemDragDropAdapter adapter;
                    Object dragObject = iterator.next();
                    if (!(dragObject instanceof IAdaptable)) continue;
                    IAdaptable iAdaptable = (IAdaptable)dragObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) == null || !adapter.canDrag(dragObject)) continue;
                    this.serializeObject(dragObject, adapter, dataStream);
                    if (!iterator.hasNext()) continue;
                    dataStream.append('|');
                }
                PluginTransferData data = new PluginTransferData("org.eclipse.rse.ui.view.DropActions", dataStream.toString().getBytes());
                event.data = data;
                if (dataStream.length() > 0) {
                    event.doit = true;
                    event.detail = 1;
                } else {
                    event.doit = false;
                    event.detail = 2000;
                }
            } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                String[] fileNames = new String[ss.size()];
                Iterator iterator = ss.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                }
                if (i > 0) {
                    event.data = fileNames;
                }
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                String[] texts = new String[ss.size()];
                Iterator iterator = ss.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    ISystemViewElementAdapter adapter;
                    Object dragObject = iterator.next();
                    if (!(dragObject instanceof IAdaptable)) continue;
                    IAdaptable iAdaptable = (IAdaptable)dragObject;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                    texts[i] = adapter.getText(dragObject);
                    ++i;
                }
                if (i > 0) {
                    event.data = texts;
                }
            } else if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                EditorInputTransfer.EditorInputData[] inputData = new EditorInputTransfer.EditorInputData[ss.size()];
                Iterator iterator = ss.iterator();
                int i = 0;
                IEditorRegistry editRegistry = RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
                while (iterator.hasNext()) {
                    ISystemEditableRemoteObject editable;
                    ISystemRemoteElementAdapter adapter;
                    Object adapterObj;
                    Object dragObject = iterator.next();
                    IAdaptable iAdaptable = (IAdaptable)dragObject;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapterObj = iAdaptable.getAdapter((Class)clazz)) == null || !(adapter = (ISystemRemoteElementAdapter)adapterObj).canEdit(dragObject) || (editable = adapter.getEditableRemoteObject(dragObject)) == null) continue;
                    try {
                        Shell shell = event.display.getActiveShell();
                        if (!editable.download(shell)) continue;
                        editable.addAsListener();
                        editable.setLocalResourceProperties();
                        IFile theFile = editable.getLocalResource();
                        IEditorDescriptor preferredEditor = editRegistry.getDefaultEditor(theFile.getName());
                        if (preferredEditor == null) {
                            preferredEditor = this.getDefaultTextEditor();
                        }
                        FileEditorInput fileInput = new FileEditorInput(theFile);
                        inputData[i] = EditorInputTransfer.createEditorInputData((String)preferredEditor.getId(), (IEditorInput)fileInput);
                        ++i;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (i > 0) {
                    event.data = inputData;
                } else {
                    event.detail = 0;
                }
            }
        }
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }
}

