/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.search;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemRemoveElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableTreeViewProvider;
import org.eclipse.rse.ui.view.SystemView;
import org.eclipse.rse.ui.view.search.SystemSearchClearHistoryAction;
import org.eclipse.rse.ui.view.search.SystemSearchCopyToClipboardAction;
import org.eclipse.rse.ui.view.search.SystemSearchHistoryAction;
import org.eclipse.rse.ui.view.search.SystemSearchRemoveAllMatchesAction;
import org.eclipse.rse.ui.view.search.SystemSearchRemoveSelectedMatchesAction;
import org.eclipse.rse.ui.view.search.SystemSearchTableView;
import org.eclipse.rse.ui.view.search.SystemSearchViewContentProvider;
import org.eclipse.rse.ui.view.search.SystemSearchViewLabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class SystemSearchViewPart
extends ViewPart
implements ISystemResourceChangeListener,
IMenuListener,
ISelectionChangedListener,
ISystemMessageLine,
IRSEViewPart {
    private PageBook pageBook;
    private StructuredViewer currentViewer;
    private IActionBars actionBars;
    private IMenuManager mMgr;
    private IToolBarManager tbMgr;
    private IStatusLineManager slMgr;
    private static final String MENU_HISTORY_GROUP_NAME = "historyGroup";
    private static final String MENU_CLEAR_HISTORY_GROUP_NAME = "clearHistoryGroup";
    private ArrayList viewers = new ArrayList();
    private ArrayList historyActions = new ArrayList();
    private CancelAction cancelAction;
    private SystemSearchClearHistoryAction clearHistoryAction;
    private SystemSearchRemoveSelectedMatchesAction removeSelectedAction;
    private SystemSearchRemoveAllMatchesAction removeAllAction;
    private SystemSearchCopyToClipboardAction copyAction;
    private SystemPasteFromClipboardAction pasteAction;
    private String _message;
    private String _errorMessage;
    private SystemMessage sysErrorMessage;
    private IStatusLineManager _statusLine = null;

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        IViewSite site = this.getViewSite();
        this.actionBars = site.getActionBars();
        this.mMgr = this.actionBars.getMenuManager();
        this.tbMgr = this.actionBars.getToolBarManager();
        this._statusLine = this.actionBars.getStatusLineManager();
        this.initToolBarActions(this.tbMgr);
        this.slMgr = this.actionBars.getStatusLineManager();
        this.actionBars.updateActionBars();
        RSEUIPlugin.getTheSystemRegistry().addSystemResourceChangeListener(this);
        SystemWidgetHelpers.setHelp((Control)this.pageBook, "org.eclipse.rse.ui.srch0000");
    }

    private void initToolBarActions(IToolBarManager tbMgr) {
        if (this.cancelAction == null) {
            this.cancelAction = new CancelAction();
            if (this.currentViewer == null) {
                this.cancelAction.setEnabled(false);
            } else if (this.currentViewer.getInput() == null) {
                this.cancelAction.setEnabled(false);
            } else {
                this.cancelAction.setEnabled(true);
            }
        }
        if (this.removeSelectedAction == null) {
            this.removeSelectedAction = new SystemSearchRemoveSelectedMatchesAction(this, this.getShell());
            if (this.currentViewer == null) {
                this.removeSelectedAction.setEnabled(false);
            } else {
                this.removeSelectedAction.setEnabled(this.isRemoveSelectedEnabled());
            }
        }
        if (this.removeAllAction == null) {
            this.removeAllAction = new SystemSearchRemoveAllMatchesAction(this, this.getShell());
            if (this.currentViewer == null) {
                this.removeAllAction.setEnabled(false);
            } else {
                Object input = this.currentViewer.getInput();
                this.removeAllAction.setEnabled(this.isRemoveAllEnabled((IAdaptable)input));
            }
        }
        tbMgr.add((IAction)this.cancelAction);
        tbMgr.add((IAction)this.removeSelectedAction);
        tbMgr.add((IAction)this.removeAllAction);
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        Clipboard clipboard = registry.getSystemClipboard();
        Shell shell = registry.getShell();
        this.copyAction = new SystemSearchCopyToClipboardAction(shell, clipboard);
        this.pasteAction = new SystemPasteFromClipboardAction(shell, clipboard);
        CellEditorActionHandler editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        editorActionHandler.setCopyAction((IAction)this.copyAction);
        editorActionHandler.setPasteAction((IAction)this.pasteAction);
        editorActionHandler.setDeleteAction((IAction)this.removeSelectedAction);
    }

    private boolean isRemoveSelectedEnabled() {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strSel = (IStructuredSelection)selection;
            return strSel.getFirstElement() != this.currentViewer.getInput();
        }
        return false;
    }

    private boolean isRemoveAllEnabled(IAdaptable input) {
        if (input == null) {
            return false;
        }
        ISystemViewElementAdapter adapter = this.getAdapter(input);
        if (adapter == null) {
            return false;
        }
        return adapter.hasChildren(input);
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void addSearchResult(IAdaptable resultSet) {
        ISystemViewElementAdapter adapter = this.getAdapter(resultSet);
        if (adapter == null) {
            return;
        }
        if (resultSet instanceof IHostSearchResultSet) {
            this.currentViewer = this.createSearchResultsTable((IHostSearchResultSet)resultSet, adapter);
        } else {
            this.currentViewer = this.createSearchResultsTree(resultSet, adapter);
            TreeViewer treeViewer = (TreeViewer)this.currentViewer;
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener((IMenuListener)this);
            Tree tree = (Tree)treeViewer.getControl();
            Menu menu = menuMgr.createContextMenu((Control)tree);
            tree.setMenu(menu);
        }
        this.currentViewer.setInput((Object)resultSet);
        this.currentViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.currentViewer);
        this.currentViewer.addDoubleClickListener((IDoubleClickListener)new SystemSearchDoubleClickListener());
        SystemWidgetHelpers.setHelp(this.currentViewer.getControl(), "org.eclipse.rse.ui.srch0000");
        this.viewers.add(this.currentViewer);
        String title = adapter.getText(resultSet);
        this.setContentDescription(title);
        int num = this.viewers.size() - 1;
        SystemSearchHistoryAction historyAction = new SystemSearchHistoryAction(title, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemsearchresultIcon"), this, num);
        this.historyActions.add(historyAction);
        if (this.viewers.size() == 1) {
            this.mMgr.add((IContributionItem)new GroupMarker(MENU_HISTORY_GROUP_NAME));
            this.mMgr.add((IContributionItem)new Separator(MENU_CLEAR_HISTORY_GROUP_NAME));
            this.clearHistoryAction = new SystemSearchClearHistoryAction(this, this.getShell());
            this.mMgr.appendToGroup(MENU_CLEAR_HISTORY_GROUP_NAME, (IAction)this.clearHistoryAction);
        }
        this.mMgr.appendToGroup(MENU_HISTORY_GROUP_NAME, (IAction)historyAction);
        this.actionBars.updateActionBars();
        this.pageBook.showPage(this.currentViewer.getControl());
        if (this.cancelAction != null) {
            this.cancelAction.updateEnableState(resultSet);
        }
        if (this.removeSelectedAction != null) {
            this.removeSelectedAction.setEnabled(this.isRemoveSelectedEnabled());
        }
        if (this.removeAllAction != null) {
            this.removeAllAction.setEnabled(this.isRemoveAllEnabled(resultSet));
        }
    }

    private StructuredViewer createSearchResultsTree(IAdaptable resultSet, ISystemViewElementAdapter adapter) {
        Tree currentControl = new Tree((Composite)this.pageBook, 2);
        TreeViewer currentViewer = new TreeViewer(currentControl);
        currentViewer.setUseHashlookup(true);
        currentViewer.setAutoExpandLevel(-1);
        SystemSearchViewContentProvider contentProvider = new SystemSearchViewContentProvider();
        contentProvider.setViewPart(this);
        currentViewer.setContentProvider((IContentProvider)contentProvider);
        SystemSearchViewLabelProvider labelProvider = new SystemSearchViewLabelProvider();
        currentViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        return currentViewer;
    }

    private StructuredViewer createSearchResultsTable(IHostSearchResultSet resultSet, ISystemViewElementAdapter adapter) {
        Tree tabletree = new Tree((Composite)this.pageBook, 101122);
        SystemSearchTableView viewer = new SystemSearchTableView(tabletree, resultSet, this);
        viewer.setWorkbenchPart((IWorkbenchPart)this);
        this.getSite().registerContextMenu(viewer.getContextMenuManager(), (ISelectionProvider)viewer);
        return viewer;
    }

    public void dispose() {
        RSEUIPlugin.getTheSystemRegistry().removeSystemResourceChangeListener(this);
        this.clearViewers();
        this.viewers.clear();
        this.historyActions.clear();
        super.dispose();
    }

    private void clearViewers() {
        if (this.currentViewer != null) {
            this.currentViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (this.getSite().getSelectionProvider() == this.currentViewer) {
                this.getSite().setSelectionProvider(null);
            }
        }
        int i = 0;
        while (i < this.viewers.size()) {
            TreeViewer treeView;
            ISystemViewElementAdapter adapter;
            Object input;
            Object viewer = this.viewers.get(i);
            if (viewer instanceof SystemSearchTableView) {
                SystemSearchTableView tableView = (SystemSearchTableView)viewer;
                input = tableView.getInput();
                if (input instanceof IHostSearchResultSet) {
                    IHostSearchResultSet set = (IHostSearchResultSet)input;
                    set.dispose();
                }
                tableView.dispose();
            } else if (viewer instanceof TreeViewer && (adapter = this.getAdapter(input = (treeView = (TreeViewer)viewer).getInput())) != null && adapter instanceof ISystemRemoveElementAdapter) {
                ISystemRemoveElementAdapter rmAdapter = (ISystemRemoveElementAdapter)((Object)adapter);
                rmAdapter.removeAllChildren(input);
                Control control = treeView.getControl();
                if (!control.isDisposed()) {
                    control.dispose();
                }
            }
            ++i;
        }
    }

    public void showSearchResult(int index) {
        if (this.currentViewer != null) {
            this.currentViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentViewer = (StructuredViewer)this.viewers.get(index);
        this.getSite().setSelectionProvider((ISelectionProvider)this.currentViewer);
        this.currentViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        IAdaptable resultSet = (IAdaptable)this.currentViewer.getInput();
        if (resultSet == null) {
            return;
        }
        ISystemViewElementAdapter adapter = this.getAdapter(resultSet);
        if (adapter == null) {
            return;
        }
        String title = adapter.getText(resultSet);
        this.setContentDescription(title);
        Control currentControl = this.currentViewer.getControl();
        this.pageBook.showPage(currentControl);
        if (this.cancelAction != null) {
            this.cancelAction.updateEnableState(resultSet);
        }
        if (this.removeSelectedAction != null) {
            this.removeSelectedAction.setEnabled(this.isRemoveSelectedEnabled());
        }
        if (this.removeAllAction != null) {
            this.removeAllAction.setEnabled(this.isRemoveAllEnabled(resultSet));
        }
    }

    public boolean deleteSelected() {
        if (this.currentViewer == null) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.currentViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object input = this.currentViewer.getInput();
        ISystemViewElementAdapter adapter = this.getAdapter(input);
        if (adapter == null || !(adapter instanceof ISystemRemoveElementAdapter)) {
            return false;
        }
        Iterator elements = selection.iterator();
        ArrayList removeElements = new ArrayList();
        while (elements.hasNext()) {
            Object element = elements.next();
            ((ISystemRemoveElementAdapter)((Object)adapter)).remove(input, element);
            removeElements.add(element);
        }
        if (this.currentViewer instanceof TreeViewer) {
            ((TreeViewer)this.currentViewer).remove(removeElements.toArray());
        }
        String title = adapter.getText(input);
        this.setContentDescription(title);
        if (this.cancelAction != null) {
            this.cancelAction.updateEnableState((IAdaptable)input);
        }
        if (this.removeSelectedAction != null) {
            this.removeSelectedAction.setEnabled(this.isRemoveSelectedEnabled());
        }
        if (this.removeAllAction != null) {
            this.removeAllAction.setEnabled(this.isRemoveAllEnabled((IAdaptable)input));
        }
        return true;
    }

    public boolean deleteAllPages() {
        this.pageBook.showPage(this.createDummyControl());
        this.clearViewers();
        this.currentViewer = null;
        this.viewers.clear();
        this.cancelAction.setEnabled(false);
        this.removeSelectedAction.setEnabled(false);
        this.removeAllAction.setEnabled(false);
        this.historyActions.clear();
        this.mMgr.removeAll();
        this.actionBars.updateActionBars();
        this.setContentDescription("");
        return true;
    }

    private Control createDummyControl() {
        Composite control = new Composite((Composite)this.pageBook, 0);
        return control;
    }

    public boolean deleteCurrentPage() {
        if (this.currentViewer != null) {
            this.currentViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (this.getSite().getSelectionProvider() == this.currentViewer) {
                this.getSite().setSelectionProvider(null);
            }
        } else {
            return false;
        }
        Object input = this.currentViewer.getInput();
        ISystemViewElementAdapter adapter = this.getAdapter(input);
        if (this.currentViewer instanceof SystemSearchTableView) {
            SystemSearchTableView tableView = (SystemSearchTableView)this.currentViewer;
            tableView.removeAsListener();
            if (input instanceof IHostSearchResultSet) {
                IHostSearchResultSet set = (IHostSearchResultSet)input;
                set.dispose();
            }
            SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)tableView.getContentProvider();
            provider.flushCache();
            tableView.refresh();
        } else if (this.currentViewer instanceof TreeViewer) {
            TreeViewer treeView = (TreeViewer)this.currentViewer;
            if (adapter != null && adapter instanceof ISystemRemoveElementAdapter) {
                ISystemRemoveElementAdapter rmAdapter = (ISystemRemoveElementAdapter)((Object)adapter);
                rmAdapter.removeAllChildren(input);
                treeView.refresh();
            }
        }
        String title = adapter.getText(input);
        this.setContentDescription(title);
        this.cancelAction.setEnabled(false);
        this.removeSelectedAction.setEnabled(false);
        this.removeAllAction.setEnabled(false);
        return true;
    }

    public ISystemViewElementAdapter getAdapter(Object element) {
        return SystemAdapterHelpers.getAdapter(element);
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        if (event.getType() == 150) {
            if (this.currentViewer == null) {
                return;
            }
            Object actualSource = event.getSource();
            if (actualSource instanceof IHostSearchResultConfiguration) {
                IHostSearchResultSet source = ((IHostSearchResultConfiguration)actualSource).getParentResultSet();
                ISystemViewElementAdapter adapter = this.getAdapter(source);
                if (adapter == null) {
                    return;
                }
                int index = -1;
                if (this.currentViewer.getInput() == source) {
                    String title = adapter.getText(source);
                    this.setContentDescription(title);
                    if (this.cancelAction != null) {
                        this.cancelAction.updateEnableState((IAdaptable)source);
                    }
                    if (this.removeSelectedAction != null) {
                        this.removeSelectedAction.setEnabled(this.isRemoveSelectedEnabled());
                    }
                    if (this.removeAllAction != null) {
                        this.removeAllAction.setEnabled(this.isRemoveAllEnabled((IAdaptable)source));
                    }
                    index = this.viewers.indexOf(this.currentViewer);
                } else {
                    int i = 0;
                    while (i < this.viewers.size()) {
                        SystemSearchTableView view = (SystemSearchTableView)this.viewers.get(i);
                        if (view.getInput() == source) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index >= 0) {
                    SystemSearchHistoryAction historyAction = (SystemSearchHistoryAction)((Object)this.historyActions.get(index));
                    historyAction.setText(adapter.getText(source));
                }
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.currentViewer.getSelection();
        if (selection == null) {
            return;
        }
        int selectionCount = selection.size();
        if (selectionCount == 0) {
            return;
        }
        if (selectionCount == 1 && selection.getFirstElement() == this.currentViewer.getInput()) {
            return;
        }
        SystemView.createStandardGroups(menu);
        SystemMenuManager ourMenu = new SystemMenuManager(menu);
        Object element = selection.getFirstElement();
        ISystemViewElementAdapter adapter = this.getAdapter(element);
        adapter.setViewer((Viewer)this.currentViewer);
        adapter.addActions(ourMenu, selection, this.getShell(), "group.adapters");
    }

    public boolean sameParent() {
        boolean same = true;
        Tree tree = null;
        if (!(this.currentViewer instanceof AbstractTreeViewer)) {
            return false;
        }
        tree = (Tree)this.currentViewer.getControl();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return true;
        }
        TreeItem prevParent = null;
        TreeItem currParent = null;
        int idx = 0;
        while (same && idx < items.length) {
            currParent = items[idx].getParentItem();
            if (idx > 0 && currParent != prevParent) {
                same = false;
            } else {
                prevParent = currParent;
            }
            ++idx;
        }
        return same;
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.fillContextMenu(menu);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.currentViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        if (this.currentViewer == null) {
            return null;
        }
        return this.currentViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.currentViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.currentViewer.setSelection(selection);
    }

    public void setViewPartTitle(String title) {
        this.setContentDescription(title);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.currentViewer) {
            this.removeSelectedAction.setEnabled(this.isRemoveSelectedEnabled());
        } else {
            this.removeSelectedAction.setEnabled(false);
        }
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            ISystemViewElementAdapter adapter = this.getAdapter(iter.next());
            adapter.setViewer((Viewer)this.currentViewer);
        }
        this.copyAction.setEnabled(this.copyAction.updateSelection(sel));
        this.pasteAction.setEnabled(this.pasteAction.updateSelection(sel));
    }

    public StructuredViewer getCurrentViewer() {
        return this.currentViewer;
    }

    public Viewer getRSEViewer() {
        return this.currentViewer;
    }

    public void clearErrorMessage() {
        this._errorMessage = null;
        this.sysErrorMessage = null;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(this._errorMessage);
        }
    }

    public void clearMessage() {
        this._message = null;
        if (this._statusLine != null) {
            this._statusLine.setMessage(this._message);
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this._message = message;
        if (this._statusLine != null) {
            this._statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    public class SystemSearchDoubleClickListener
    implements IDoubleClickListener {
        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                Object element = selection.getFirstElement();
                ISystemViewElementAdapter adapter = SystemSearchViewPart.this.getAdapter(element);
                adapter.setViewer((Viewer)SystemSearchViewPart.this.currentViewer);
                adapter.handleDoubleClick(element);
            }
        }
    }

    class SelectAllAction
    extends Action {
        public SelectAllAction() {
            super(SystemResources.ACTION_SELECT_ALL_LABEL, null);
        }

        public void run() {
            if (SystemSearchViewPart.this.currentViewer != null && SystemSearchViewPart.this.currentViewer instanceof TableViewer) {
                TableViewer viewer = (TableViewer)SystemSearchViewPart.this.currentViewer;
                viewer.getTable().selectAll();
                viewer.setSelection(viewer.getSelection());
            }
        }
    }

    public class CancelAction
    extends Action {
        public CancelAction() {
            super(SystemResources.ACTION_CANCEL_SEARCH_LABEL, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.stopIcon"));
            this.setToolTipText(SystemResources.ACTION_CANCEL_SEARCH_TOOLTIP);
        }

        public void run() {
            if (SystemSearchViewPart.this.currentViewer == null) {
                return;
            }
            Object input = SystemSearchViewPart.this.currentViewer.getInput();
            if (input != null && input instanceof IHostSearchResultSet) {
                IHostSearchResultSet resultSet = (IHostSearchResultSet)input;
                this.setEnabled(false);
                resultSet.cancel();
            }
        }

        public void updateEnableState(IAdaptable input) {
            if (input == null) {
                this.setEnabled(false);
            }
            if (input instanceof IHostSearchResultSet) {
                IHostSearchResultSet set = (IHostSearchResultSet)input;
                if (set.isRunning()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }
}

