/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeEvents;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.widgets.ISystemCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemHostCombo
extends Composite
implements ISelectionProvider,
ISystemCombo,
ISystemResourceChangeListener,
ISystemResourceChangeEvents,
DisposeListener {
    protected Label connectionLabel = null;
    protected Combo connectionCombo = null;
    protected Button newButton = null;
    protected boolean showNewButton = true;
    protected boolean showLabel = true;
    protected boolean showQualifiedNames;
    protected boolean listeningForConnectionEvents = false;
    private IHost[] connections = null;
    private SystemNewConnectionAction newConnectionAction = null;
    private String[] restrictSystemTypesTo = null;
    private int gridColumns = 2;
    private String label;
    private String populateSystemType = null;
    private String[] populateSystemTypes = null;
    private ISubSystemConfiguration populateSSFactory = null;
    private String populateSSFactoryId = null;
    private String populateSSFactoryCategory = null;
    private Cursor waitCursor;

    public SystemHostCombo(Composite parent, int style, String systemType, IHost defaultConnection, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = new String[1];
        this.restrictSystemTypesTo[0] = systemType;
        this.init(parent, showNewButton);
        this.populateSystemType = systemType;
        this.populateConnectionCombo(this.connectionCombo, systemType, defaultConnection, true);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, String[] systemTypes, IHost defaultConnection, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = systemTypes;
        this.init(parent, showNewButton);
        this.populateSystemTypes = systemTypes;
        this.populateConnectionCombo(this.connectionCombo, systemTypes, defaultConnection);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, ISubSystemConfiguration ssFactory, IHost defaultConnection, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = ssFactory.getSystemTypes();
        this.init(parent, showNewButton);
        this.populateSSFactory = ssFactory;
        this.populateConnectionCombo(this.connectionCombo, ssFactory, defaultConnection);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, IHost defaultConnection, String ssFactoryId, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = RSEUIPlugin.getTheSystemRegistry().getSubSystemConfiguration(ssFactoryId).getSystemTypes();
        this.init(parent, showNewButton);
        this.populateSSFactoryId = ssFactoryId;
        this.populateConnectionCombo(this.connectionCombo, ssFactoryId, defaultConnection);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, IHost defaultConnection, boolean showNewButton, String ssFactoryCategory) {
        this(parent, style, defaultConnection, showNewButton, ssFactoryCategory, true);
    }

    public SystemHostCombo(Composite parent, int style, IHost defaultConnection, boolean showNewButton, String ssFactoryCategory, boolean showLabel) {
        super(parent, style);
        if (showNewButton) {
            ISubSystemConfigurationProxy[] ssfProxies = RSEUIPlugin.getTheSystemRegistry().getSubSystemConfigurationProxiesByCategory(ssFactoryCategory);
            Vector<String> vTypes = new Vector<String>();
            int idx = 0;
            while (idx < ssfProxies.length) {
                String[] types = ssfProxies[idx].getSystemTypes();
                int jdx = 0;
                while (jdx < types.length) {
                    if (!vTypes.contains(types[jdx])) {
                        vTypes.addElement(types[jdx]);
                    }
                    ++jdx;
                }
                ++idx;
            }
            this.restrictSystemTypesTo = new String[vTypes.size()];
            idx = 0;
            while (idx < vTypes.size()) {
                this.restrictSystemTypesTo[idx] = (String)vTypes.elementAt(idx);
                ++idx;
            }
        }
        this.init(parent, showNewButton, showLabel);
        this.populateSSFactoryCategory = ssFactoryCategory;
        this.populateConnectionCombo(this.connectionCombo, defaultConnection, ssFactoryCategory);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public void setAutoUpperCase(boolean enable) {
    }

    protected void init(Composite parent, boolean showNewButton) {
        this.init(parent, showNewButton, true);
    }

    protected void init(Composite parent, boolean showNewButton, boolean showLabel) {
        this.showNewButton = showNewButton;
        this.showLabel = showLabel;
        this.showQualifiedNames = SystemPreferencesManager.getPreferencesManager().getQualifyConnectionNames();
        this.prepareComposite(3);
        if (showLabel) {
            this.connectionLabel = this.label == null ? SystemWidgetHelpers.createLabel(this, SystemResources.WIDGET_CONNECTION_LABEL) : SystemWidgetHelpers.createLabel(this, this.label);
        }
        this.connectionCombo = this.createConnectionCombo(this);
        if (showNewButton) {
            this.newConnectionAction = this.getNewConnectionAction(parent.getShell(), this);
            this.newConnectionAction.restrictSystemTypes(this.restrictSystemTypesTo);
            this.newButton = SystemHostCombo.createPushButton(this, SystemResources.WIDGET_BUTTON_NEWCONNECTION_LABEL, SystemResources.WIDGET_BUTTON_NEWCONNECTION_TOOLTIP);
            this.addOurButtonSelectionListener();
            if (!showLabel) {
                ((GridData)this.connectionCombo.getLayoutData()).horizontalSpan = 2;
            }
        } else {
            ((GridData)this.connectionCombo.getLayoutData()).horizontalSpan = showLabel ? 2 : 3;
        }
        this.addDisposeListener(this);
    }

    protected SystemNewConnectionAction getNewConnectionAction(Shell shell, ISelectionProvider selectionProvider) {
        return new SystemNewConnectionAction(shell, false, selectionProvider);
    }

    public IHost getHost() {
        IHost connection = null;
        int idx = this.connectionCombo.getSelectionIndex();
        if (idx >= 0 && this.connections != null && idx < this.connections.length) {
            connection = this.connections[idx];
        }
        return connection;
    }

    public Combo getCombo() {
        return this.connectionCombo;
    }

    public void setWidthHint(int widthHint) {
        ((GridData)this.getLayoutData()).widthHint = widthHint;
    }

    public void setButtonWidthHint(int widthHint) {
        if (this.newButton != null) {
            ((GridData)this.newButton.getLayoutData()).widthHint = widthHint;
        }
    }

    public void setButtonWidthHint(Control otherWidget) {
        if (this.newButton != null) {
            ((GridData)this.newButton.getLayoutData()).widthHint = otherWidget.getSize().x;
        }
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public Button getNewButton() {
        return this.newButton;
    }

    public Label getPromptLabel() {
        return this.connectionLabel;
    }

    public void setItems(String[] items) {
        this.connectionCombo.setItems(items);
    }

    public String[] getItems() {
        return this.connectionCombo.getItems();
    }

    public String getText() {
        return this.connectionCombo.getText();
    }

    public void setEnabled(boolean enabled) {
        this.connectionCombo.setEnabled(enabled);
        if (this.newButton != null) {
            this.newButton.setEnabled(enabled);
        }
    }

    public void setToolTipText(String tip) {
        if (this.connectionLabel != null) {
            this.connectionLabel.setToolTipText(tip);
        }
    }

    public void setNewButtonToolTipText(String tip) {
        if (this.newButton != null) {
            this.newButton.setToolTipText(tip);
        }
    }

    public void setButtonToolTipText(String tip) {
        this.setNewButtonToolTipText(tip);
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.connectionLabel != null) {
            this.connectionLabel.setText(label);
        }
    }

    public boolean setFocus() {
        return this.connectionCombo.setFocus();
    }

    public void setNewButtonFocus() {
        if (this.newButton != null) {
            this.newButton.setFocus();
        }
    }

    public void select(int selIdx) {
        this.connectionCombo.select(selIdx);
        Event e = new Event();
        this.connectionCombo.notifyListeners(13, e);
    }

    public void setSelectionIndex(int selIdx) {
        this.select(selIdx);
    }

    public void select(IHost connection) {
        if (this.connections != null) {
            int matchIdx = -1;
            int idx = 0;
            while (matchIdx == -1 && idx < this.connections.length) {
                if (connection == this.connections[idx]) {
                    matchIdx = idx;
                }
                ++idx;
            }
            if (matchIdx != -1) {
                this.select(matchIdx);
            }
        }
    }

    public void clearSelection() {
        this.connectionCombo.clearSelection();
        this.connectionCombo.deselectAll();
        Event e = new Event();
        this.connectionCombo.notifyListeners(13, e);
    }

    public void clearTextSelection() {
        this.connectionCombo.clearSelection();
    }

    public int getSelectionIndex() {
        return this.connectionCombo.getSelectionIndex();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.connectionCombo.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.connectionCombo.removeSelectionListener(listener);
    }

    public void addNewButtonSelectionListener(SelectionListener listener) {
        if (this.newButton != null) {
            this.newButton.addSelectionListener(listener);
        }
    }

    public void removeNewButtonSelectionListener(SelectionListener listener) {
        if (this.newButton != null) {
            this.newButton.removeSelectionListener(listener);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.connectionCombo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.connectionCombo.removeModifyListener(listener);
    }

    protected Composite prepareComposite(int numColumns) {
        this.gridColumns = numColumns;
        SystemHostCombo composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.showNewButton ? 250 : 200;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData(data);
        return composite;
    }

    protected Combo createConnectionCombo(Composite parent) {
        Combo combo = SystemHostCombo.createCombo(parent, true);
        this.setToolTipText(SystemResources.WIDGET_CONNECTION_TOOLTIP);
        return combo;
    }

    public static Combo createCombo(Composite parent, boolean readonly) {
        Combo combo = null;
        combo = !readonly ? new Combo(parent, 4) : new Combo(parent, 12);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected boolean populateConnectionCombo(Combo combo, String systemType, IHost defaultConnection, boolean preSelectIfNoMatch) {
        return this.populateConnectionCombo(combo, systemType, defaultConnection, preSelectIfNoMatch, false);
    }

    protected boolean populateConnectionCombo(Combo combo, String systemType, IHost defaultConnection, boolean preSelectIfNoMatch, boolean appendToCombo) {
        int idx;
        boolean matchFound = false;
        IHost[] additionalConnections = null;
        additionalConnections = systemType == null || systemType.equals("*") ? RSEUIPlugin.getTheSystemRegistry().getHosts() : RSEUIPlugin.getTheSystemRegistry().getHostsBySystemType(systemType);
        if (additionalConnections != null) {
            String[] connectionNames = new String[additionalConnections.length];
            int selectionIndex = -1;
            idx = 0;
            while (idx < connectionNames.length) {
                connectionNames[idx] = this.getConnectionName(additionalConnections[idx]);
                if (defaultConnection != null && additionalConnections[idx] == defaultConnection) {
                    selectionIndex = this.connections == null ? idx : this.connections.length + idx;
                }
                ++idx;
            }
            if (appendToCombo) {
                int i = 0;
                while (i < connectionNames.length) {
                    combo.add(connectionNames[i]);
                    ++i;
                }
            } else {
                combo.setItems(connectionNames);
            }
            if (selectionIndex >= 0) {
                this.select(selectionIndex);
                matchFound = true;
            } else if (preSelectIfNoMatch && combo.getItemCount() > 0) {
                this.select(0);
            }
        }
        if (this.connections == null) {
            this.connections = additionalConnections;
        } else if (additionalConnections != null && additionalConnections.length > 0) {
            IHost[] totalConnections = new IHost[this.connections.length + additionalConnections.length];
            int totalIdx = 0;
            idx = 0;
            while (idx < this.connections.length) {
                totalConnections[totalIdx++] = this.connections[idx];
                ++idx;
            }
            idx = 0;
            while (idx < additionalConnections.length) {
                totalConnections[totalIdx++] = additionalConnections[idx];
                ++idx;
            }
            this.connections = totalConnections;
        }
        return matchFound;
    }

    protected void populateConnectionCombo(Combo combo, String[] systemTypes, IHost defaultConnection) {
        boolean match = false;
        boolean anyMatch = false;
        int idx = 0;
        while (idx < systemTypes.length) {
            match = this.populateConnectionCombo(combo, systemTypes[idx], defaultConnection, false, true);
            if (match) {
                anyMatch = true;
            }
            ++idx;
        }
        if (!anyMatch && combo.getItemCount() > 0) {
            this.select(0);
        }
    }

    protected boolean populateConnectionCombo(Combo combo, ISubSystemConfiguration ssFactory, IHost defaultConnection) {
        this.connections = RSEUIPlugin.getTheSystemRegistry().getHostsBySubSystemConfiguration(ssFactory);
        return this.addConnections(combo, this.connections, defaultConnection);
    }

    protected boolean populateConnectionCombo(Combo combo, String ssFactoryId, IHost defaultConnection) {
        this.connections = RSEUIPlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationId(ssFactoryId);
        return this.addConnections(combo, this.connections, defaultConnection);
    }

    protected boolean populateConnectionCombo(Combo combo, IHost defaultConnection, String ssFactoryCategory) {
        this.connections = RSEUIPlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory(ssFactoryCategory);
        return this.addConnections(combo, this.connections, defaultConnection);
    }

    private boolean addConnections(Combo combo, IHost[] connections, IHost defaultConnection) {
        boolean matchFound = false;
        if (connections != null) {
            String[] connectionNames = new String[connections.length];
            int selectionIndex = -1;
            int idx = 0;
            while (idx < connectionNames.length) {
                connectionNames[idx] = this.getConnectionName(connections[idx]);
                if (defaultConnection != null && connections[idx] == defaultConnection) {
                    selectionIndex = idx;
                }
                ++idx;
            }
            combo.setItems(connectionNames);
            if (selectionIndex >= 0) {
                this.select(selectionIndex);
                matchFound = true;
            } else if (combo.getItemCount() > 0) {
                this.select(0);
            }
        }
        return matchFound;
    }

    protected static String sub(String msg, String subOld, String subNew) {
        StringBuffer temp = new StringBuffer();
        int lastHit = 0;
        int newHit = 0;
        newHit = msg.indexOf(subOld, lastHit);
        while (newHit != -1) {
            if (newHit >= 0) {
                temp.append(msg.substring(lastHit, newHit));
            }
            temp.append(subNew);
            lastHit = newHit += subOld.length();
            newHit = msg.indexOf(subOld, lastHit);
        }
        if (lastHit >= 0) {
            temp.append(msg.substring(lastHit));
        }
        return temp.toString();
    }

    private String getConnectionName(IHost conn) {
        if (this.showQualifiedNames) {
            return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
        }
        return conn.getAliasName();
    }

    public void refreshConnections() {
        this.connections = null;
        this.connectionCombo.removeAll();
        if (this.populateSystemType != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSystemType, null, false);
        } else if (this.populateSystemTypes != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSystemTypes, null);
        } else if (this.populateSSFactory != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSSFactory, null);
        } else if (this.populateSSFactoryId != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSSFactoryId, null);
        } else if (this.populateSSFactoryCategory != null) {
            this.populateConnectionCombo(this.connectionCombo, null, this.populateSSFactoryCategory);
        }
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        int type = event.getType();
        Object src = event.getSource();
        event.getParent();
        switch (type) {
            case 50: 
            case 53: 
            case 60: 
            case 65: {
                if (!(src instanceof IHost)) break;
                if (type == 65) {
                    this.showQualifiedNames = SystemPreferencesManager.getPreferencesManager().getQualifyConnectionNames();
                }
                this.refreshConnections();
            }
        }
    }

    public void listenToConnectionEvents(boolean start) {
        if (start) {
            this.listeningForConnectionEvents = true;
            RSEUIPlugin.getTheSystemRegistry().addSystemResourceChangeListener(this);
        } else {
            this.listeningForConnectionEvents = false;
            RSEUIPlugin.getTheSystemRegistry().removeSystemResourceChangeListener(this);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.listeningForConnectionEvents) {
            this.listeningForConnectionEvents = false;
            RSEUIPlugin.getTheSystemRegistry().removeSystemResourceChangeListener(this);
        }
    }

    protected void addOurButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemHostCombo.this.setBusyCursor(true);
                SystemHostCombo.this.newConnectionAction.run();
                SystemHostCombo.this.setBusyCursor(false);
                IHost newConnection = (IHost)SystemHostCombo.this.newConnectionAction.getValue();
                if (newConnection != null) {
                    if (SystemHostCombo.this.listeningForConnectionEvents) {
                        SystemHostCombo.this.select(newConnection);
                    } else if (SystemHostCombo.this.connections == null) {
                        SystemHostCombo.this.connections = new IHost[1];
                        ((SystemHostCombo)SystemHostCombo.this).connections[0] = newConnection;
                        SystemHostCombo.this.addConnections(SystemHostCombo.this.connectionCombo, SystemHostCombo.this.connections, newConnection);
                    } else {
                        IHost[] totalConnections = new IHost[SystemHostCombo.this.connections.length + 1];
                        int totalIdx = 0;
                        int idx = 0;
                        while (idx < SystemHostCombo.this.connections.length) {
                            totalConnections[totalIdx++] = SystemHostCombo.this.connections[idx];
                            ++idx;
                        }
                        totalConnections[totalIdx] = newConnection;
                        SystemHostCombo.this.connections = totalConnections;
                        SystemHostCombo.this.addConnections(SystemHostCombo.this.connectionCombo, SystemHostCombo.this.connections, newConnection);
                    }
                }
            }
        };
        this.newButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void addOurConnectionSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemHostCombo.this.setConnectionToolTipText();
            }
        };
        this.connectionCombo.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void setConnectionToolTipText() {
        String tooltipText = "";
        IHost currConn = this.getHost();
        if (currConn != null) {
            tooltipText = currConn.getHostName();
        }
        this.connectionCombo.setToolTipText(tooltipText);
    }

    protected static Button createPushButton(Composite group, String label) {
        Button button = new Button(group, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        button.setLayoutData((Object)data);
        return button;
    }

    protected static Button createPushButton(Composite group, String label, String tooltip) {
        Button button = SystemHostCombo.createPushButton(group, label);
        button.setToolTipText(tooltip);
        return button;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        StructuredSelection selection = StructuredSelection.EMPTY;
        IHost connection = this.getHost();
        if (connection != null) {
            selection = new StructuredSelection((Object)connection);
        }
        return selection;
    }

    public void setSelection(ISelection selection) {
    }

    public IHost[] getConnections() {
        return this.connections;
    }

    public void setConnections(IHost[] input) {
        this.connections = input;
    }

    protected void setBusyCursor(boolean setBusy) {
        if (setBusy) {
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            SystemPromptDialog.setDisplayCursor(this.getShell(), this.waitCursor);
        } else {
            SystemPromptDialog.setDisplayCursor(this.getShell(), null);
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
        }
    }
}

