/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemWizardDialog;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.rse.ui.wizards.ISystemWizard;
import org.eclipse.rse.ui.wizards.ISystemWizardPage;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractSystemWizard
extends Wizard
implements ISystemWizard {
    protected boolean finishPressed = true;
    protected boolean cancelled = false;
    protected Object input = null;
    protected Object output = null;
    protected IStructuredSelection selection = null;
    protected int minPageWidth;
    protected int minPageHeight;
    protected String helpId;
    protected Viewer viewer = null;
    protected String pageTitle;
    protected SystemWizardDialog owningDialog;
    private Cursor waitCursor;

    public AbstractSystemWizard() {
    }

    public AbstractSystemWizard(String title) {
        this.setWindowTitle(title);
    }

    public AbstractSystemWizard(String title, ImageDescriptor wizardImage) {
        this.setWindowTitle(title);
        this.setDefaultPageImageDescriptor(wizardImage);
    }

    public void setSystemWizardDialog(SystemWizardDialog dlg) {
        this.owningDialog = dlg;
    }

    public SystemWizardDialog getSystemWizardDialog() {
        return this.owningDialog;
    }

    public void updateSize() {
        if (this.owningDialog != null) {
            this.owningDialog.updateSize(this.getContainer().getCurrentPage());
        }
    }

    public void setWizardTitle(String title) {
        this.setWindowTitle(title);
    }

    public void setWizardPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getWizardPageTitle() {
        return this.pageTitle;
    }

    public void setWizardImage(ImageDescriptor wizardImage) {
        super.setDefaultPageImageDescriptor(wizardImage);
    }

    public void setHelp(String id) {
        this.helpId = id;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
        if (this.helpId != null && page instanceof ISystemWizardPage) {
            ISystemWizardPage swPage = (ISystemWizardPage)page;
            if (super.getPageCount() == 1 || swPage.getHelpContextId() == null) {
                swPage.setHelp(this.helpId);
            }
        }
    }

    public void setViewer(Viewer v) {
        this.viewer = v;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    protected ISystemTree getCurrentTreeView() {
        Viewer v = this.getViewer();
        if (v instanceof ISystemTree) {
            return (ISystemTree)v;
        }
        return null;
    }

    public void setInputObject(Object inputObject) {
        this.input = inputObject;
    }

    public Object getInputObject() {
        return this.input;
    }

    public Object getOutputObject() {
        return this.output;
    }

    protected void setOutputObject(Object outputObject) {
        this.output = outputObject;
    }

    public boolean wasCancelled() {
        if (this.cancelled) {
            return true;
        }
        return !this.finishPressed;
    }

    protected void setWasCancelled(boolean cancelled) {
        this.finishPressed = !cancelled;
    }

    public boolean performCancel() {
        this.cancelled = true;
        this.setWasCancelled(true);
        return super.performCancel();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setMinimumPageSize(int width, int height) {
        if (width <= 0) {
            width = 300;
        }
        if (height <= 0) {
            height = 225;
        }
        this.minPageWidth = width;
        this.minPageHeight = height;
    }

    public int getMinimumPageWidth() {
        return this.minPageWidth;
    }

    public int getMinimumPageHeight() {
        return this.minPageHeight;
    }

    protected void setPageError(IWizardPage pageInError) {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage != pageInError) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1240");
            if (currentPage instanceof AbstractSystemWizardPage) {
                ((AbstractSystemWizardPage)currentPage).setErrorMessage(msg);
            } else if (pageInError instanceof WizardPage) {
                ((WizardPage)currentPage).setErrorMessage(msg.getLevelOneText());
            }
        }
    }

    public int publicConvertWidthInCharsToPixels(int chars) {
        if (this.owningDialog != null) {
            return this.owningDialog.publicConvertWidthInCharsToPixels(chars);
        }
        return -1;
    }

    public int publicConvertHeightInCharsToPixels(int chars) {
        if (this.owningDialog != null) {
            return this.owningDialog.publicConvertHeightInCharsToPixels(chars);
        }
        return -1;
    }

    public void setBusyCursor(boolean setBusy) {
        if (setBusy) {
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            SystemPromptDialog.setDisplayCursor(this.getShell(), this.waitCursor);
        } else {
            SystemPromptDialog.setDisplayCursor(this.getShell(), null);
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
        }
    }

    public abstract void addPages();

    public abstract boolean performFinish();
}

