/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.rse.internal.logging.LabelUtil;
import org.eclipse.rse.logging.RemoteSystemsLoggingPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public abstract class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    private Button radioButton0;
    private Button radioButton1;
    private Button radioButton2;
    private Button radioButton3;
    private Button radioButtonLogFile;
    private Button radioButtonLogView;
    private Bundle bundle = null;

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite_tab = this.createComposite(parent, 2);
        String bundleName = (String)this.bundle.getHeaders().get("Bundle-Name");
        String topLabel1 = RemoteSystemsLoggingPlugin.getResourceString("LoggingPreferencePage.topLabel1");
        topLabel1 = MessageFormat.format(topLabel1, bundleName);
        this.createLabel(composite_tab, topLabel1);
        this.forceSpace(composite_tab);
        String topLabel2 = RemoteSystemsLoggingPlugin.getResourceString("LoggingPreferencePage.topLabel2");
        this.createLabel(composite_tab, topLabel2);
        this.tabForward(composite_tab);
        Composite composite1_radioButton = this.createComposite(composite_tab, 1);
        String text = RemoteSystemsLoggingPlugin.getResourceString("LoggingPreferencePage.errors_only");
        Set used = LabelUtil.usedFromString("ad");
        this.radioButton0 = this.createRadioButton(composite1_radioButton, LabelUtil.assignMnemonic(text, used));
        text = RemoteSystemsLoggingPlugin.getResourceString("LoggingPreferencePage.warnings_errors");
        this.radioButton1 = this.createRadioButton(composite1_radioButton, LabelUtil.assignMnemonic(text, used));
        text = RemoteSystemsLoggingPlugin.getResourceString("LoggingPreferencePage.info_debug");
        this.radioButton2 = this.createRadioButton(composite1_radioButton, LabelUtil.assignMnemonic(text, used));
        this.initializeValues();
        RemoteSystemsLoggingPlugin.out.logInfo("created LoggingPreferencePage");
        WorkbenchHelp.setHelp((Control)composite_tab, (String)"com.ibm.etools.systems.logging.pref0000");
        return new Composite(parent, 0);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        if (this.bundle != null) {
            AbstractUIPlugin plugin = this.getPlugin();
            if (plugin != null) {
                return plugin.getPreferenceStore();
            }
            return new PreferenceStore();
        }
        return new PreferenceStore();
    }

    protected abstract AbstractUIPlugin getPlugin();

    public void init(IWorkbench workbench) {
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.radioButton0.setSelection(false);
        this.radioButton1.setSelection(false);
        this.radioButton2.setSelection(false);
        if (this.radioButton3 != null) {
            this.radioButton3.setSelection(false);
        }
        int choice = store.getInt("debug_level");
        switch (choice) {
            case 0: {
                this.radioButton0.setSelection(true);
                break;
            }
            case 1: {
                this.radioButton1.setSelection(true);
                break;
            }
            case 2: {
                this.radioButton2.setSelection(true);
                break;
            }
            case 3: {
                if (this.radioButton3 != null) {
                    this.radioButton3.setSelection(true);
                    break;
                }
                this.radioButton2.setSelection(true);
            }
        }
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.radioButton0.setSelection(false);
        this.radioButton1.setSelection(false);
        this.radioButton2.setSelection(false);
        if (this.radioButton3 != null) {
            this.radioButton3.setSelection(false);
        }
        int choice = store.getDefaultInt("debug_level");
        switch (choice) {
            case 0: {
                this.radioButton0.setSelection(true);
                break;
            }
            case 1: {
                this.radioButton1.setSelection(true);
                break;
            }
            case 2: {
                this.radioButton2.setSelection(true);
                break;
            }
            case 3: {
                if (this.radioButton3 != null) {
                    this.radioButton3.setSelection(true);
                    break;
                }
                this.radioButton2.setSelection(true);
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        int choice = 0;
        if (this.radioButton1.getSelection()) {
            choice = 1;
        } else if (this.radioButton2.getSelection()) {
            choice = 2;
        } else if (this.radioButton3 != null && this.radioButton3.getSelection()) {
            choice = 3;
        }
        store.setValue("debug_level", choice);
    }

    private void tabForward(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    private void forceSpace(Composite parent) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            String nameSpace = config.getDeclaringExtension().getNamespace();
            this.bundle = Platform.getBundle((String)nameSpace);
        }
        catch (Exception e) {
            RemoteSystemsLoggingPlugin.out.logError("Failed to create LoggingPreferencePage.", e);
        }
    }
}

