/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.servicesubsystem;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.subsystems.shells.core.ShellStrings;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.progress.UIJob;

public class OutputRefreshJob
extends UIJob {
    private IRemoteCommandShell _command;
    private IRemoteOutput[] _outputs;
    private boolean _cwdChanged = false;
    private boolean _isComplete = false;

    public OutputRefreshJob(IRemoteCommandShell command, IRemoteOutput[] outputs, boolean cwdChanged) {
        super(ShellStrings.RSESubSystemOperation_Refresh_Output);
        this._command = command;
        this._cwdChanged = cwdChanged;
        this._outputs = outputs;
    }

    public boolean isComplete() {
        return this._isComplete;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            if (this._outputs != null) {
                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object[])this._outputs, 82, (Object)this._command));
                if (this._cwdChanged) {
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._command, 86, (Object)this._command.getCommandSubSystem()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._isComplete = true;
        return Status.OK_STATUS;
    }
}

