/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.model;

import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.swt.widgets.Display;

public class SimpleCommandOperation {
    private IRemoteCmdSubSystem _subsystem;
    private IRemoteFile _workingDirectory;
    private IRemoteCommandShell _cmdShell;
    private int _outputLineIndex = 0;

    public SimpleCommandOperation(IRemoteCmdSubSystem subsystem, IRemoteFile workingDirectory) {
        this._subsystem = subsystem;
        this._workingDirectory = workingDirectory;
    }

    public void runCommand(String command) throws Exception {
        Object[] result = this._subsystem.runCommand(command, null, this._workingDirectory, false);
        this._cmdShell = (IRemoteCommandShell)result[0];
    }

    public IRemoteCommandShell getCommandShell() {
        return this._cmdShell;
    }

    public void putInput(String input) throws Exception {
        if (this.isActive()) {
            this._subsystem.sendCommandToShell(input, null, this._cmdShell);
        }
    }

    public boolean isActive() {
        if (this._cmdShell != null) {
            return this._cmdShell.isActive();
        }
        return false;
    }

    protected boolean hasMoreOutput() {
        return this._cmdShell != null && this._cmdShell.listOutput().length > this._outputLineIndex;
    }

    public void cancelCommand() throws Exception {
        if (this._cmdShell != null && this._cmdShell.isActive()) {
            this._cmdShell.getCommandSubSystem().cancelShell(null, this._cmdShell);
        }
    }

    public String readLine(boolean waitForOutput) {
        if (this._cmdShell != null) {
            if (!this.hasMoreOutput() && waitForOutput) {
                while (!this.hasMoreOutput()) {
                    if (!this.isActive()) {
                        return null;
                    }
                    try {
                        Display d = Display.getCurrent();
                        if (d != null) {
                            while (d.readAndDispatch()) {
                            }
                        }
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Object output = this._cmdShell.getOutputAt(this._outputLineIndex);
            ++this._outputLineIndex;
            if (output instanceof IRemoteOutput) {
                return ((IRemoteOutput)output).getText();
            }
            if (output instanceof IRemoteFile) {
                return ((IRemoteFile)output).getLabel();
            }
        }
        return "";
    }
}

