/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.environment.EnvironmentMiner;

public class QueryPathThread
extends Thread {
    private DataStore _dataStore;
    private DataElement _status;

    public QueryPathThread(DataElement status) {
        this._status = status;
        this._dataStore = status.getDataStore();
    }

    public void run() {
        this.getPossibleCommands(this._status);
    }

    public List getPathEnvironment() {
        DataElement systemEnvironment;
        DataElement envMinerData = this._dataStore.findMinerInformation(EnvironmentMiner.MINER_ID);
        if (envMinerData != null && (systemEnvironment = this._dataStore.find(envMinerData, 2, "System Environment", 1)) != null) {
            boolean isIgnoreCase = System.getProperty("os.name").toLowerCase().startsWith("win");
            ArrayList vars = this._dataStore.searchForPattern(systemEnvironment, 2, "PATH=*", isIgnoreCase);
            if (vars == null || vars.size() == 0) {
                return new ArrayList();
            }
            DataElement pathVariable = (DataElement)vars.get(0);
            if (pathVariable != null) {
                String varStr = pathVariable.getValue();
                int separatorIndex = varStr.indexOf("=");
                if (separatorIndex > 0) {
                    varStr = varStr.substring(separatorIndex + 1, varStr.length());
                }
                return this.parsePathEnvironmentVariable(varStr);
            }
        }
        return null;
    }

    protected List parsePathEnvironmentVariable(String path) {
        ArrayList<String> addedPaths = new ArrayList<String>();
        ArrayList<File> addedFolders = new ArrayList<File>();
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
        char separator = isWindows ? (char)';' : ':';
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf(separator));
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (addedPaths.contains(token)) continue;
            addedPaths.add(token);
            File folder = new File(token);
            if (!folder.exists() || !folder.isDirectory()) continue;
            addedFolders.add(folder);
        }
        return addedFolders;
    }

    public void getPossibleCommands(DataElement status) {
        ArrayList<String> resolvedPaths = new ArrayList<String>();
        List paths = this.getPathEnvironment();
        int i = 0;
        while (i < paths.size()) {
            File folder = (File)paths.get(i);
            String abspath = folder.getAbsolutePath().toLowerCase();
            if (!resolvedPaths.contains(abspath)) {
                this.resolveCommandsInPath(folder, status);
                resolvedPaths.add(abspath);
            }
            ++i;
        }
        status.setAttribute(2, "done");
        this._dataStore.refresh(status);
    }

    private void resolveCommandsInPath(File file, DataElement status) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                File afile = files[i];
                if (afile.isFile() && !afile.isHidden()) {
                    String name = afile.getName();
                    DataElement fileObj = this._dataStore.createObject(status, "file", name);
                    fileObj.setAttribute(4, afile.getAbsolutePath());
                }
                ++i;
            }
        }
    }
}

