/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.dstore.universal.miners.IUniversalDataStoreConstants;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalFileSystemMiner;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.AbstractDStoreService;
import org.eclipse.rse.services.dstore.ServiceResources;
import org.eclipse.rse.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.services.dstore.files.DStoreVirtualHostFile;
import org.eclipse.rse.services.dstore.util.DownloadListener;
import org.eclipse.rse.services.dstore.util.FileSystemMessageUtil;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;

public class DStoreFileService
extends AbstractDStoreService
implements IFileService,
IUniversalDataStoreConstants {
    protected DataElement _uploadLogElement = null;
    protected Map _fileElementMap = new HashMap();
    private int _bufferUploadSize = 40960;
    private int _bufferDownloadSize = 40960;
    protected ISystemFileTypes _fileTypeRegistry;
    private static String[] _filterAttributes = new String[]{"attributes", "filter", "filter.id", "doc", "", "", DataStoreResources.FALSE, "2"};
    static /* synthetic */ Class class$0;

    public DStoreFileService(IDataStoreProvider dataStoreProvider, ISystemFileTypes fileTypeRegistry) {
        super(dataStoreProvider);
        this._fileTypeRegistry = fileTypeRegistry;
    }

    public String getName() {
        return ServiceResources.DStore_File_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_File_Service_Description;
    }

    public void setBufferUploadSize(int size) {
        this._bufferUploadSize = size;
    }

    public void setBufferDownloadSize(int size) {
        this._bufferDownloadSize = size;
    }

    protected int getBufferUploadSize() {
        return this._bufferUploadSize;
    }

    protected int getBufferDownloadSize() {
        return this._bufferDownloadSize;
    }

    protected String getMinerId() {
        return UniversalFileSystemMiner.MINER_ID;
    }

    protected String getByteStreamHandlerId() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.dstore.universal.miners.filesystem.UniversalByteStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    protected String getDataStoreRoot() {
        return this.getDataStore().getAttribute(7);
    }

    protected String prepareForDownload(String localPath) {
        int index = localPath.lastIndexOf(File.separator);
        String parentDir = localPath.substring(0, index + 1);
        this.setDataStoreRoot(parentDir);
        String dataStoreLocalPath = localPath.substring(index + 1);
        if (!dataStoreLocalPath.startsWith("/")) {
            dataStoreLocalPath = "/" + dataStoreLocalPath;
        }
        return dataStoreLocalPath;
    }

    protected void setDataStoreRoot(String root) {
        this.getDataStore().setAttribute(7, root);
    }

    protected DataElement findUploadLog() {
        DataElement minerInfo = this.getMinerElement();
        if (this._uploadLogElement == null || this._uploadLogElement.getDataStore() != this.getDataStore()) {
            this._uploadLogElement = this.getDataStore().find(minerInfo, 2, "universal.uploadlog", 2);
        }
        return this._uploadLogElement;
    }

    protected DataElement getAttributes(String fileNameFilter, boolean showHidden) {
        DataElement attributes = this.getDataStore().createTransientObject(_filterAttributes);
        String version = "version_1";
        StringBuffer buffer = new StringBuffer();
        String filter = fileNameFilter == null ? "*" : fileNameFilter;
        buffer.append(version).append("|").append(filter).append("|").append(showHidden);
        attributes.setAttribute(4, buffer.toString());
        return attributes;
    }

    /*
     * Exception decompiling
     */
    public boolean upload(IProgressMonitor monitor, InputStream inputStream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [6 : 382->385)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean upload(IProgressMonitor monitor, File file, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [11 : 562->565)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean download(IProgressMonitor monitor, String remoteParent, String remoteFile, File localFile, boolean isBinary, String encoding) {
        DataElement universaltemp = this.getMinerElement();
        if (!localFile.exists()) {
            File parentDir = localFile.getParentFile();
            parentDir.mkdirs();
        }
        try {
            if (localFile.exists()) {
                localFile.delete();
            }
            localFile.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
        int mode = isBinary ? -2 : -1;
        DataStore ds = this.getDataStore();
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
        DataElement de = this.getElementFor(remotePath);
        if (de.getType().equals("universal.FilterObject")) {
            DStoreHostFile hostFile = (DStoreHostFile)this.getFile(monitor, remoteParent, remoteFile);
            de = hostFile._element;
        }
        long fileLength = DStoreHostFile.getFileLength(de.getSource());
        DataElement remoteElement = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
        this.getDataStoreRoot();
        String dataStoreLocalPath = this.prepareForDownload(localFile.getAbsolutePath());
        DataElement localElement = ds.createObject(universaltemp, de.getType(), dataStoreLocalPath, encoding);
        DataElement bufferSizeElement = ds.createObject(universaltemp, "buffer_size", "" + this.getBufferDownloadSize(), "");
        DataElement queryCmd = this.getCommandDescriptor(de, "C_DOWNLOAD_FILE");
        ArrayList<DataElement> argList = new ArrayList<DataElement>();
        argList.add(remoteElement);
        argList.add(localElement);
        argList.add(bufferSizeElement);
        DataElement subject = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
        DataElement status = ds.command(queryCmd, argList, subject);
        if (status == null) {
            System.out.println("no download descriptor for " + remoteElement);
        }
        try {
            DownloadListener dlistener = new DownloadListener(monitor, status, localFile, remotePath, fileLength);
            try {
                dlistener.waitForUpdate();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            return false;
        }
        long localBytes = localFile.length();
        long lastLocalBytes = 0L;
        while (!(localBytes >= fileLength || monitor != null && monitor.isCanceled() || lastLocalBytes == localBytes)) {
            try {
                lastLocalBytes = localBytes;
                Thread.sleep(100L);
                localBytes = localFile.length();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public IHostFile getFile(IProgressMonitor monitor, String remoteParent, String name) {
        DataElement de = null;
        de = name.equals(".") && name.equals(remoteParent) ? this.getElementFor(name) : this.getElementFor(String.valueOf(remoteParent) + this.getSeparator(remoteParent) + name);
        this.dsQueryCommand(monitor, de, "C_QUERY_GET_REMOTE_OBJECT");
        return new DStoreHostFile(de);
    }

    protected String getSeparator(String parentPath) {
        if (parentPath == null || parentPath.length() < 2) {
            return "/";
        }
        if (parentPath.endsWith("#virtual#/")) {
            return "";
        }
        if (parentPath.endsWith("#virtual#")) {
            return "/";
        }
        if (parentPath.charAt(1) == ':') {
            if (parentPath.indexOf("#virtual#") != -1) {
                if (parentPath.endsWith("/")) {
                    return "";
                }
                return "/";
            }
            if (ArchiveHandlerManager.getInstance().isArchive(new File(parentPath))) {
                return "#virtual#/";
            }
            if (parentPath.endsWith("\\")) {
                return "";
            }
            return "\\";
        }
        if (parentPath.charAt(0) == '/') {
            if (ArchiveHandlerManager.getInstance().isArchive(new File(parentPath))) {
                return "#virtual#/";
            }
            if (parentPath.endsWith("/")) {
                return "";
            }
            return "/";
        }
        return "/";
    }

    protected IHostFile convertToHostFile(DataElement element) {
        String type = element.getType();
        DStoreHostFile file = null;
        file = type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") ? new DStoreVirtualHostFile(element) : new DStoreHostFile(element);
        String path = file.getAbsolutePath();
        this._fileElementMap.put(path, element);
        return file;
    }

    protected IHostFile[] convertToHostFiles(DataElement[] elements) {
        ArrayList<IHostFile> results = new ArrayList<IHostFile>();
        int i = 0;
        while (i < elements.length) {
            if (!elements[i].isDeleted()) {
                results.add(this.convertToHostFile(elements[i]));
            }
            ++i;
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public IHostFile getUserHome() {
        return this.getFile(null, ".", ".");
    }

    public IHostFile createFile(IProgressMonitor monitor, String remoteParent, String fileName) {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + fileName;
        DataElement de = this.getElementFor(remotePath);
        this.dsQueryCommand(monitor, de, "C_CREATE_FILE");
        return new DStoreHostFile(de);
    }

    public IHostFile createFolder(IProgressMonitor monitor, String remoteParent, String folderName) {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + folderName;
        DataElement de = this.getElementFor(remotePath);
        this.dsQueryCommand(monitor, de, "C_CREATE_FOLDER");
        return new DStoreHostFile(de);
    }

    public boolean delete(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + fileName;
        DataElement de = this.getElementFor(remotePath);
        DataElement status = this.dsStatusCommand(monitor, de, "C_DELETE");
        if (status == null) {
            return false;
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return true;
        }
        throw new SystemMessageException(this.getMessage("RSEF1300").makeSubstitution((Object)FileSystemMessageUtil.getSourceLocation(status)));
    }

    public boolean deleteBatch(IProgressMonitor monitor, String[] remoteParents, String[] fileNames) throws SystemMessageException {
        if (remoteParents.length == 1) {
            return this.delete(monitor, remoteParents[0], fileNames[0]);
        }
        ArrayList<DataElement> dataElements = new ArrayList<DataElement>(remoteParents.length);
        int i = 0;
        while (i < remoteParents.length) {
            String remotePath = String.valueOf(remoteParents[i]) + this.getSeparator(remoteParents[i]) + fileNames[i];
            DataElement de = this.getElementFor(remotePath);
            if (de != null) {
                dataElements.add(de);
            }
            ++i;
        }
        DataElement status = this.dsStatusCommand(monitor, (DataElement)dataElements.get(0), dataElements, "C_DELETE_BATCH");
        if (status == null) {
            return false;
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return true;
        }
        throw new SystemMessageException(this.getMessage("RSEF1300").makeSubstitution((Object)FileSystemMessageUtil.getSourceLocation(status)));
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName) {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + oldName;
        DataElement de = this.getElementFor(remotePath);
        de.setAttribute(4, newName);
        this.dsQueryCommand(monitor, de, "C_RENAME");
        return true;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName, IHostFile oldFile) {
        boolean retVal = this.rename(monitor, remoteParent, oldName, newName);
        String newPath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + newName;
        oldFile.renameTo(newPath);
        return retVal;
    }

    public boolean move(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) {
        String src = String.valueOf(srcParent) + this.getSeparator(srcParent) + srcName;
        String tgt = String.valueOf(tgtParent) + this.getSeparator(tgtParent) + tgtName;
        boolean bl = ArchiveHandlerManager.isVirtual((String)src) || ArchiveHandlerManager.isVirtual((String)tgt);
        if (this.copy(monitor, srcParent, srcName, tgtParent, tgtName)) {
            try {
                this.delete(monitor, srcParent, srcName);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isSpecialChar(char c) {
        return c == '$' || c == '`' || c == '\"' || c == '\\';
    }

    public boolean copy(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) {
        DataStore ds = this.getDataStore();
        String srcRemotePath = String.valueOf(srcParent) + this.getSeparator(srcParent) + srcName;
        DataElement srcDE = this.getElementFor(srcRemotePath);
        DataElement tgtDE = this.getElementFor(tgtParent);
        DataElement cpCmd = this.getCommandDescriptor(tgtDE, "C_COPY");
        if (cpCmd != null) {
            ArrayList<DataElement> args = new ArrayList<DataElement>();
            args.add(srcDE);
            DataElement nameObj = ds.createObject(null, "name", tgtName);
            args.add(nameObj);
            DataElement status = ds.command(cpCmd, args, tgtDE, true);
            try {
                this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                if (status.getAttribute(4).equals("failed")) {
                    status.getAttribute(3);
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    public boolean copyBatch(IProgressMonitor monitor, String[] srcParents, String[] srcNames, String tgtParent) {
        DataStore ds = this.getDataStore();
        DataElement tgtDE = this.getElementFor(tgtParent);
        DataElement cpCmd = this.getCommandDescriptor(tgtDE, "C_COPY_BATCH");
        if (cpCmd != null) {
            ArrayList<DataElement> args = new ArrayList<DataElement>();
            int i = 0;
            while (i < srcParents.length) {
                String srcRemotePath = String.valueOf(srcParents[i]) + this.getSeparator(srcParents[i]) + srcNames[i];
                DataElement srcDE = this.getElementFor(srcRemotePath);
                args.add(srcDE);
                ++i;
            }
            DataElement status = ds.command(cpCmd, args, tgtDE, true);
            try {
                this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                if (status.getAttribute(4).equals("failed")) {
                    status.getAttribute(3);
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        DataStore ds = this.getDataStore();
        DataElement universaltemp = this.getMinerElement();
        DataElement deObj = ds.createObject(universaltemp, "universal.FilterObject", "", "", "", false);
        DataElement[] results = this.dsQueryCommand(monitor, deObj, "C_QUERY_ROOTS");
        return this.convertToHostFiles(results);
    }

    public IHostFile[] getFolders(IProgressMonitor monitor, String remoteParent, String fileFilter) {
        return this.fetch(monitor, remoteParent, fileFilter, "C_QUERY_VIEW_FOLDERS");
    }

    public IHostFile[] getFiles(IProgressMonitor monitor, String remoteParent, String fileFilter) {
        return this.fetch(monitor, remoteParent, fileFilter, "C_QUERY_VIEW_FILES");
    }

    public IHostFile[] getFilesAndFolders(IProgressMonitor monitor, String remoteParent, String fileFilter) {
        return this.fetch(monitor, remoteParent, fileFilter, "C_QUERY_VIEW_ALL");
    }

    protected DataElement getElementFor(String path) {
        String normalizedPath;
        DataElement element;
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        if ((element = (DataElement)this._fileElementMap.get(normalizedPath = PathUtility.normalizeUnknown((String)path))) != null && element.isDeleted()) {
            this._fileElementMap.remove(normalizedPath);
            element = null;
        }
        if (element == null || element.isDeleted()) {
            DataElement universaltemp = this.getMinerElement();
            element = this.getDataStore().createObject(universaltemp, "universal.FilterObject", normalizedPath, normalizedPath, "", false);
        }
        return element;
    }

    protected IHostFile[] fetch(IProgressMonitor monitor, String remoteParent, String fileFilter, String queryType) {
        DataStore ds = this.getDataStore();
        DataElement deObj = this.getElementFor(remoteParent);
        if (deObj == null) {
            DataElement universaltemp = this.getMinerElement();
            ds.createObject(universaltemp, "universal.FilterObject", remoteParent, remoteParent, "", false);
        }
        DataElement attributes = this.getAttributes(fileFilter, true);
        ArrayList<DataElement> args = new ArrayList<DataElement>(1);
        args.add(attributes);
        DataElement[] results = this.dsQueryCommand(monitor, deObj, args, queryType);
        return this.convertToHostFiles(results);
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

