/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.shells;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.dstore.universal.miners.command.CommandMiner;
import org.eclipse.rse.dstore.universal.miners.environment.EnvironmentMiner;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.dstore.AbstractDStoreService;
import org.eclipse.rse.services.dstore.ServiceResources;
import org.eclipse.rse.services.dstore.shells.DStoreHostShell;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class DStoreShellService
extends AbstractDStoreService
implements IShellService {
    protected String[] _envVars;
    protected DataElement _envMinerElement;
    protected DataElement _envMinerStatus;

    public DStoreShellService(IDataStoreProvider dataStoreProvider) {
        super(dataStoreProvider);
    }

    public String getName() {
        return ServiceResources.DStore_Shell_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_Shell_Service_Description;
    }

    public IHostShell launchShell(IProgressMonitor monitor, String initialWorkingDirectory, String[] environment) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return this.launchShell(monitor, initialWorkingDirectory, null, environment);
    }

    public IHostShell launchShell(IProgressMonitor monitor, String initialWorkingDirectory, String encoding, String[] environment) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return new DStoreHostShell(this.getStatusMonitor(this.getDataStore()), this.getDataStore(), initialWorkingDirectory, ">", encoding, environment);
    }

    public IHostShell runCommand(IProgressMonitor monitor, String initialWorkingDirectory, String command, String[] environment) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return this.runCommand(monitor, initialWorkingDirectory, command, null, environment);
    }

    public IHostShell runCommand(IProgressMonitor monitor, String initialWorkingDirectory, String command, String encoding, String[] environment) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return new DStoreHostShell(this.getStatusMonitor(this.getDataStore()), this.getDataStore(), initialWorkingDirectory, command, encoding, environment);
    }

    public String[] getHostEnvironment() {
        if (this._envVars == null || this._envVars.length == 0) {
            DataElement systemEnvironment;
            ArrayList<String> envVars = new ArrayList<String>();
            DataStore ds = this.getDataStore();
            DataElement envMinerData = ds.findMinerInformation(this.getEnvSystemMinerId());
            if (envMinerData != null && (systemEnvironment = ds.find(envMinerData, 2, "System Environment", 1)) != null && systemEnvironment.getNestedSize() > 0) {
                int i = 0;
                while (i < systemEnvironment.getNestedSize()) {
                    DataElement var = systemEnvironment.get(i);
                    envVars.add(var.getValue());
                    ++i;
                }
            }
            this._envVars = envVars.toArray(new String[envVars.size()]);
        }
        return this._envVars;
    }

    protected String getMinerId() {
        return CommandMiner.MINER_ID;
    }

    protected String getEnvSystemMinerId() {
        return EnvironmentMiner.MINER_ID;
    }

    protected String getOldEnvSystemMinerId() {
        return "com.ibm.etools.systems.dstore.miners.environment.EnvironmentMiner";
    }

    public boolean isInitialized() {
        if (this._initializeStatus != null) {
            DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
            return smon.determineStatusDone(this._initializeStatus);
        }
        return false;
    }

    protected void waitForInitialize(IProgressMonitor monitor) {
        if (this._envMinerStatus != null) {
            DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
            try {
                smon.waitForUpdate(this._envMinerStatus, monitor);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.getMinerElement(this.getEnvSystemMinerId());
        }
        super.waitForInitialize(monitor);
    }

    public void uninitService(IProgressMonitor monitor) {
        super.uninitService(monitor);
    }

    protected void initMiner(IProgressMonitor monitor) {
        if (this.getServerVersion() >= 8) {
            String minerId = this.getEnvSystemMinerId();
            String message = SystemMessage.sub((String)ServiceResources.DStore_Service_ProgMon_Initializing_Message, (String)"&1", (String)minerId);
            monitor.beginTask(message, -1);
            DataStore ds = this.getDataStore();
            if ((this._envMinerElement == null || this._envMinerElement.getDataStore() != ds) && ds != null) {
                this._envMinerStatus = ds.activateMiner(minerId);
            }
            super.initMiner(monitor);
        }
    }
}

