/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.dstore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.dstore.core.client.ClientConnection;
import org.eclipse.dstore.core.client.ClientSSLProperties;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.java.RemoteClassLoader;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.dstore.core.model.ISSLProperties;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.connectorservice.dstore.RexecDstoreServer;
import org.eclipse.rse.connectorservice.dstore.util.ConnectionStatusListener;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitor;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitorFactory;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.rse.core.subsystems.AbstractConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IIBMServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.dstore.universal.miners.environment.EnvironmentMiner;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.SystemSignonInformation;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.actions.DisplayHidableSystemMessageAction;
import org.eclipse.rse.ui.actions.DisplaySystemMessageAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class DStoreConnectorService
extends AbstractConnectorService
implements IDataStoreProvider {
    private ClientConnection clientConnection = null;
    private ConnectionStatusListener _connectionStatusListener = null;
    private transient DataElement sysInfo = null;
    private transient DataElement installInfo = null;
    private transient DataElement clientIP = null;
    private static String DSTORE_PACKAGE = "org.eclipse.dstore.core";
    private Exception connectException;
    private IServerLauncher starter;

    public DStoreConnectorService(String name, String description, IHost host) {
        super(name, description, host, 0);
    }

    public int getServerVersion() {
        return this.clientConnection.getServerVersion();
    }

    public int getServerMinor() {
        return this.clientConnection.getServerMinor();
    }

    private String getSystemInfoProperty(String propertyName) {
        if (!this.isConnected()) {
            try {
                this.getPrimarySubSystem().connect();
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"UniversalSystem.getSystemInfoProperty: error during connect", (Throwable)e);
                return "";
            }
        }
        String propertyValue = null;
        DataElement envMinerData = null;
        DataStore ds = this.getDataStore();
        if (this.sysInfo == null && (envMinerData = ds.findMinerInformation(EnvironmentMiner.MINER_ID)) != null) {
            this.sysInfo = ds.find(envMinerData, 2, "systemInfo", 1);
        }
        if (this.sysInfo != null) {
            DataElement propertyNode = ds.find(this.sysInfo, 2, propertyName, 1);
            propertyValue = propertyNode != null ? propertyNode.getSource() : "";
        } else {
            SystemBasePlugin.logError((String)"UniversalSystem.getSystemInfoNode:  sysInfo node not found", null);
            SystemBasePlugin.logError((String)("UniversalSystem.getSystemInfoNode:  miner data = " + envMinerData), null);
            propertyValue = "";
        }
        return propertyValue;
    }

    public String getVersionReleaseModification() {
        if (!this.isConnected()) {
            return SystemPropertyResources.RESID_TERM_NOTAVAILABLE;
        }
        StringBuffer buffer = new StringBuffer(this.getSystemInfoProperty("os.name"));
        buffer.append(" ");
        buffer.append(this.getSystemInfoProperty("os.version"));
        return buffer.toString();
    }

    public String getHomeDirectory() {
        return this.getSystemInfoProperty("user.home");
    }

    public boolean runClassInstanceRemotely(IRemoteClassInstance instance) {
        DataStore dataStore = this.getDataStore();
        dataStore.registerLocalClassLoader(instance.getClass().getClassLoader());
        dataStore.runRemoteClassInstance(instance);
        return true;
    }

    public String getServerInstallPath() {
        if (this.clientConnection != null) {
            if (this.installInfo == null) {
                DataStore ds = this.clientConnection.getDataStore();
                this.installInfo = ds.queryInstall();
            }
            return this.installInfo.getAttribute(4);
        }
        return "";
    }

    public String getClientIP() {
        if (this.clientConnection != null && this.clientConnection.isConnected()) {
            if (this.clientIP == null) {
                DataStore ds = this.clientConnection.getDataStore();
                this.clientIP = ds.queryClientIP();
            }
            return this.clientIP.getAttribute(4);
        }
        return RSEUIPlugin.getLocalMachineIPAddress();
    }

    public String getTempDirectory() {
        return this.getSystemInfoProperty("temp.dir");
    }

    protected int getSocketTimeOutValue() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getInt("com.ibm.etools.systems.universal.ui.preferences.sockettimeout");
    }

    public void internalDisconnect(IProgressMonitor monitor) throws Exception {
        try {
            if (this.clientConnection != null) {
                if (this._connectionStatusListener != null && this._connectionStatusListener.isConnectionDown()) {
                    this.notifyError();
                } else {
                    this.fireCommunicationsEvent(3);
                }
                DataStore dataStore = this.getDataStore();
                if (dataStore != null && this._connectionStatusListener != null) {
                    dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this._connectionStatusListener);
                }
                this.clientConnection.disconnect();
                this.notifyDisconnection();
                this.clientConnection = null;
                this.clearPasswordCache(false);
                this.sysInfo = null;
                this.installInfo = null;
                this.clientIP = null;
            }
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    private IIBMServerLauncher getIBMServerLauncher() {
        IServerLauncherProperties sl = this.getRemoteServerLauncherProperties();
        if (sl != null && sl instanceof IIBMServerLauncher) {
            return (IIBMServerLauncher)sl;
        }
        return null;
    }

    protected void setPluginPathProperty() {
        Bundle bundle = RSEUIPlugin.getDefault().getBundle();
        URL pluginsURL = bundle.getEntry("/");
        try {
            String path = Platform.resolve((URL)pluginsURL).getPath();
            File systemsPluginDir = new File(path);
            path = systemsPluginDir.getParentFile().getAbsolutePath();
            String version = (String)bundle.getHeaders().get("Bundle-Version");
            String versionString = new PluginVersionIdentifier(version).toString();
            String dstorePath = this.getDStorePath(path, versionString);
            System.setProperty("A_PLUGIN_PATH", dstorePath);
        }
        catch (IOException iOException) {}
    }

    private String getDStorePath(String pluginDir, String version) {
        File dstorePath = new File(String.valueOf(pluginDir) + "/" + DSTORE_PACKAGE + "_" + version);
        if (!dstorePath.exists()) {
            dstorePath = new File(String.valueOf(pluginDir) + "/" + DSTORE_PACKAGE);
        }
        return dstorePath.getAbsolutePath();
    }

    public void setDaemonLaunchEnabled(SubSystem subsystemImpl, boolean enable) {
        this.enableServerLaunchType((ISubSystem)subsystemImpl, ServerLaunchType.DAEMON_LITERAL, enable);
    }

    public boolean getDaemonLaunchEnabled(SubSystem subsystemImpl) {
        return this.isEnabledServerLaunchType((ISubSystem)subsystemImpl, ServerLaunchType.DAEMON_LITERAL);
    }

    public void setRexecLaunchEnabled(SubSystem subsystemImpl, boolean enable) {
        this.enableServerLaunchType((ISubSystem)subsystemImpl, ServerLaunchType.REXEC_LITERAL, enable);
    }

    public boolean getRexecLaunchEnabled(SubSystem subsystemImpl) {
        return this.isEnabledServerLaunchType((ISubSystem)subsystemImpl, ServerLaunchType.REXEC_LITERAL);
    }

    public void setNoLaunchEnabled(SubSystem subsystemImpl, boolean enable) {
        this.enableServerLaunchType((ISubSystem)subsystemImpl, ServerLaunchType.RUNNING_LITERAL, enable);
    }

    public boolean getNoLaunchEnabled(SubSystem subsystemImpl) {
        return this.isEnabledServerLaunchType((ISubSystem)subsystemImpl, ServerLaunchType.RUNNING_LITERAL);
    }

    public IServerLauncher getRemoteServerLauncher() {
        if (this.starter == null) {
            this.starter = new RexecDstoreServer();
        }
        ((RexecDstoreServer)this.starter).setClientConnection(this.clientConnection);
        ((RexecDstoreServer)this.starter).setSocketTimeoutValue(this.getSocketTimeOutValue());
        return this.starter;
    }

    protected synchronized void internalConnect(IProgressMonitor monitor) throws Exception {
        DisplayHidableSystemMessageAction msgAction;
        SystemMessage cmsg;
        if (this.isConnected()) {
            return;
        }
        this.setPluginPathProperty();
        this.fireCommunicationsEvent(1);
        ConnectionStatus connectStatus = null;
        ConnectionStatus launchStatus = null;
        this.clientConnection = new ClientConnection(this.getPrimarySubSystem().getHost().getAliasName());
        this.clientConnection.setHost(this.getHostName());
        this.clientConnection.setPort(Integer.toString(this.getPort()));
        this.getPrimarySubSystem();
        IIBMServerLauncher serverLauncher = this.getIBMServerLauncher();
        ServerLaunchType serverLauncherType = null;
        boolean autoDetectSSL = true;
        if (serverLauncher != null) {
            serverLauncherType = serverLauncher.getServerLaunchType();
            autoDetectSSL = serverLauncher.getAutoDetectSSL();
        } else {
            System.out.println("server launcher is null");
        }
        long t1 = System.currentTimeMillis();
        SystemMessage msg = null;
        boolean launchFailed = false;
        int timeout = this.getSocketTimeOutValue();
        if (serverLauncherType == ServerLaunchType.REXEC_LITERAL) {
            if (monitor != null) {
                SystemMessage cmsg2 = RSEUIPlugin.getPluginMessage((String)"RSEC2310");
                monitor.subTask(cmsg2.getLevelOneText());
            }
            SystemSignonInformation info = this.getPasswordInformation();
            IServerLauncher starter = this.getRemoteServerLauncher();
            starter.setSignonInformation(info);
            starter.setServerLauncherProperties((IServerLauncherProperties)serverLauncher);
            if (autoDetectSSL) {
                timeout = 3000;
            } else {
                this.setSSLProperties(this.isUsingSSL());
            }
            int iServerPort = this.launchUsingRexec(monitor, info, (IServerLauncherProperties)serverLauncher);
            if (iServerPort != 0) {
                this.clientConnection.setPort("" + iServerPort);
                if (monitor != null) {
                    cmsg = RSEUIPlugin.getPluginMessage((String)"RSEC2312");
                    cmsg.makeSubstitution((Object)this.clientConnection.getPort());
                    monitor.subTask(cmsg.getLevelOneText());
                }
                if (!(connectStatus = this.clientConnection.connect(null, timeout)).isConnected() && connectStatus.getMessage().startsWith(ClientConnection.CANNOT_CONNECT) && autoDetectSSL && this.setSSLProperties(true) && (iServerPort = this.launchUsingRexec(monitor, info, (IServerLauncherProperties)serverLauncher)) != 0) {
                    this.clientConnection.setPort("" + iServerPort);
                    connectStatus = this.clientConnection.connect(null, timeout);
                }
            } else {
                launchFailed = true;
                connectStatus = new ConnectionStatus(false);
                msg = starter.getErrorMessage();
                String errorMsg = null;
                errorMsg = msg == null ? RSEUIPlugin.getPluginMessage((String)"RSEC1001").getLevelOneText() : msg.getLevelTwoText();
                connectStatus.setMessage(errorMsg);
            }
        } else if (serverLauncherType == ServerLaunchType.DAEMON_LITERAL) {
            if (monitor != null) {
                SystemMessage cmsg3 = RSEUIPlugin.getPluginMessage((String)"RSEC2311");
                monitor.subTask(cmsg3.getLevelOneText());
            }
            SystemSignonInformation info = this.getPasswordInformation();
            int daemonPort = serverLauncher.getDaemonPort();
            boolean usedSSL = false;
            launchStatus = this.launchServer(this.clientConnection, info, daemonPort, monitor);
            if (!launchStatus.isConnected() && !this.clientConnection.isKnownStatus(launchStatus.getMessage()) && this.setSSLProperties(true)) {
                usedSSL = true;
                launchStatus = this.launchServer(this.clientConnection, info, daemonPort, monitor);
            }
            if (!launchStatus.isConnected()) {
                String launchMsg = launchStatus.getMessage();
                if (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                    AbstractConnectorService.NewPasswordInfo newPasswordInfo = null;
                    while (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                        newPasswordInfo = this.promptForNewPassword(this.isPasswordExpired(launchMsg) ? RSEUIPlugin.getPluginMessage((String)"RSEG1036") : RSEUIPlugin.getPluginMessage((String)"RSEG1297"));
                        launchStatus = this.changePassword(this.clientConnection, this.getPasswordInformation(), (IServerLauncherProperties)serverLauncher, monitor, newPasswordInfo.newPassword);
                        launchMsg = launchStatus.getMessage();
                    }
                    if (newPasswordInfo != null) {
                        this.setPassword(info.getUserid(), newPasswordInfo.newPassword, newPasswordInfo.savePassword);
                        info = this.getPasswordInformation();
                    }
                    if (launchMsg != null && launchMsg.equals("attempt reconnect")) {
                        this.internalConnect(monitor);
                        return;
                    }
                } else {
                    launchFailed = true;
                    SystemBasePlugin.logError((String)("Error launching server: " + launchStatus.getMessage()), null);
                }
            }
            if (launchStatus.isConnected()) {
                if (monitor != null) {
                    cmsg = RSEUIPlugin.getPluginMessage((String)"RSEC2312");
                    cmsg.makeSubstitution((Object)this.clientConnection.getPort());
                    monitor.subTask(cmsg.getLevelOneText());
                }
                if (!(connectStatus = this.clientConnection.connect(launchStatus.getTicket(), timeout)).isConnected() && connectStatus.getMessage().startsWith(ClientConnection.CANNOT_CONNECT)) {
                    launchStatus = this.launchServer(this.clientConnection, info, daemonPort, monitor);
                    if (!launchStatus.isConnected()) {
                        launchFailed = true;
                        SystemBasePlugin.logError((String)("Error launching server: " + launchStatus.getMessage()), null);
                    } else if (this.setSSLProperties(!usedSSL)) {
                        connectStatus = this.clientConnection.connect(launchStatus.getTicket(), timeout);
                    }
                }
                if (!connectStatus.isConnected() && connectStatus.isSLLProblem()) {
                    this.importCertsAndReconnect(connectStatus, monitor);
                    return;
                }
            } else {
                connectStatus = new ConnectionStatus(false);
                connectStatus.setMessage(RSEUIPlugin.getPluginMessage((String)"RSEC1001").getLevelOneText());
            }
        } else if (serverLauncherType == ServerLaunchType.RUNNING_LITERAL) {
            boolean useSSL;
            if (monitor != null) {
                SystemMessage cmsg4 = RSEUIPlugin.getPluginMessage((String)"RSEC2312");
                cmsg4.makeSubstitution((Object)this.clientConnection.getPort());
                monitor.subTask(cmsg4.getLevelOneText());
            }
            if (this.setSSLProperties(useSSL = this.isUsingSSL())) {
                connectStatus = this.clientConnection.connect(null, timeout);
            }
        } else {
            SystemSignonInformation info = this.getPasswordInformation();
            connectStatus = this.launchServer(this.clientConnection, info, (IServerLauncherProperties)serverLauncher, monitor);
            if (!connectStatus.isConnected() && !this.clientConnection.isKnownStatus(connectStatus.getMessage()) && this.setSSLProperties(true) && !(connectStatus = this.launchServer(this.clientConnection, info, (IServerLauncherProperties)serverLauncher, monitor)).isConnected() && connectStatus.isSLLProblem()) {
                this.importCertsAndReconnect(connectStatus, monitor);
                return;
            }
        }
        if (connectStatus != null && connectStatus.isConnected()) {
            IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
            if (this.clientConnection.getDataStore().usingSSL() && store.getBoolean("org.eclipse.rse.preferences.alert.ssl")) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEC2314");
                msg.makeSubstitution((Object)this.getHostName());
                msgAction = new DisplayHidableSystemMessageAction(msg, store, "org.eclipse.rse.preferences.alert.ssl");
                Display.getDefault().syncExec((Runnable)msgAction);
                if (msgAction.getReturnCode() != 2) {
                    this.internalDisconnect(monitor);
                    throw new InterruptedException();
                }
            } else if (!this.clientConnection.getDataStore().usingSSL() && store.getBoolean("org.eclipse.rse.preferences.alert.nonssl")) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEC2315");
                msg.makeSubstitution((Object)this.getHostName());
                msgAction = new DisplayHidableSystemMessageAction(msg, store, "org.eclipse.rse.preferences.alert.nonssl");
                Display.getDefault().syncExec((Runnable)msgAction);
                if (msgAction.getReturnCode() != 2) {
                    this.internalDisconnect(monitor);
                    throw new InterruptedException();
                }
            }
            DataStore dataStore = this.clientConnection.getDataStore();
            this._connectionStatusListener = new ConnectionStatusListener(dataStore.getStatus(), (IConnectorService)this);
            dataStore.getDomainNotifier().addDomainListener((IDomainListener)this._connectionStatusListener);
            StatusMonitor statusMonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor((IConnectorService)this, dataStore);
            if (launchStatus != null && launchStatus.isConnected()) {
                DataElement ticket = dataStore.createTicket(launchStatus.getTicket());
                dataStore.queryShowTicket(ticket);
            } else {
                dataStore.showTicket(null);
            }
            this.fireCommunicationsEvent(2);
            String message = connectStatus.getMessage();
            if (message != null) {
                if (message.startsWith(ClientConnection.CLIENT_OLDER)) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEC2309");
                    msg.makeSubstitution((Object)this.getHostName());
                } else if (message.startsWith(ClientConnection.SERVER_OLDER)) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEC2308");
                    msg.makeSubstitution((Object)this.getHostName());
                }
                ShowConnectMessage msgAction2 = new ShowConnectMessage(msg);
                Display.getDefault().asyncExec((Runnable)msgAction2);
            }
            dataStore.registerLocalClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            int serverVersion = this.getServerVersion();
            if (serverVersion >= 8 || serverVersion == 7 && this.getServerMinor() >= 1) {
                store.setDefault("com.ibm.etools.systems.universal.ui.preferences.cacheremoteclasses", true);
                boolean cacheRemoteClasses = store.getBoolean("com.ibm.etools.systems.universal.ui.preferences.cacheremoteclasses");
                dataStore.setPreference(RemoteClassLoader.CACHING_PREFERENCE, cacheRemoteClasses ? "true" : "false");
            } else {
                dataStore.addMinersLocation(".");
                DataElement schemaStatus = dataStore.getSchema();
                if (monitor != null) {
                    SystemMessage imsg = RSEUIPlugin.getPluginMessage((String)"RSEC2313");
                    monitor.subTask(imsg.getLevelOneText());
                }
                DataElement initStatus = dataStore.initMiners();
                statusMonitor.waitForUpdate(schemaStatus);
                statusMonitor.waitForUpdate(initStatus);
            }
        } else {
            if (launchFailed && launchStatus != null && launchStatus.isSLLProblem() && launchStatus.isSLLProblem()) {
                launchStatus.getException();
                List certs = launchStatus.getUntrustedCertificates();
                if (certs.size() > 0) {
                    ISystemKeystoreProvider provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider();
                    if (provider != null && provider.importCertificates(certs, this.getHostName())) {
                        this.internalConnect(monitor);
                        return;
                    }
                } else {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEC2307");
                    msg.makeSubstitution((Object)launchStatus.getMessage());
                }
            }
            if (launchFailed && launchStatus != null) {
                String launchMsg = launchStatus.getMessage();
                if (launchStatus.getException() != null) {
                    Throwable exception = launchStatus.getException();
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEG1243");
                    msg.makeSubstitution((Object)this.getHostName(), (Object)("" + serverLauncher.getDaemonPort()), (Object)exception);
                } else {
                    if (launchMsg != null && launchMsg.indexOf("Authentification Failed") != -1) {
                        if (launchFailed) {
                            this.clearPasswordCache(true);
                        }
                        msg = RSEUIPlugin.getPluginMessage((String)"RSEC1002");
                        msg.makeSubstitution((Object)this.getHostName());
                        msgAction = new DisplaySystemMessageAction(msg);
                        Display.getDefault().syncExec((Runnable)msgAction);
                        this.connectException = null;
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                try {
                                    DStoreConnectorService.this.promptForPassword(Display.getDefault().getActiveShell(), true);
                                }
                                catch (InterruptedException e) {
                                    DStoreConnectorService.this.connectException = e;
                                }
                            }
                        });
                        if (this.connectException instanceof InterruptedException) {
                            throw this.connectException;
                        }
                        this.internalConnect(monitor);
                        return;
                    }
                    if (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                        AbstractConnectorService.NewPasswordInfo newPasswordInfo = null;
                        while (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                            newPasswordInfo = this.promptForNewPassword(this.isPasswordExpired(launchMsg) ? RSEUIPlugin.getPluginMessage((String)"RSEG1036") : RSEUIPlugin.getPluginMessage((String)"RSEG1297"));
                            launchStatus = this.changePassword(this.clientConnection, this.getPasswordInformation(), (IServerLauncherProperties)serverLauncher, monitor, newPasswordInfo.newPassword);
                            launchMsg = launchStatus.getMessage();
                        }
                        if (newPasswordInfo != null) {
                            this.setPassword(this.getPasswordInformation().getUserid(), newPasswordInfo.newPassword, newPasswordInfo.savePassword);
                        }
                        if (launchMsg != null && launchMsg.equals("attempt reconnect")) {
                            this.internalConnect(monitor);
                            return;
                        }
                    } else if (launchMsg != null) {
                        msg = RSEUIPlugin.getPluginMessage((String)"RSEG1242");
                        msg.makeSubstitution((Object)this.getHostName(), (Object)this.clientConnection.getPort(), (Object)launchMsg);
                    }
                }
            } else if (connectStatus != null && !connectStatus.isConnected()) {
                if (connectStatus.getMessage().startsWith(ClientConnection.INCOMPATIBLE_SERVER_UPDATE)) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEC2304");
                    msg.makeSubstitution((Object)this.getHostName());
                } else if (connectStatus.getMessage().startsWith(ClientConnection.INCOMPATIBLE_PROTOCOL)) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEC2303");
                    msg.makeSubstitution((Object)this.getHostName());
                } else {
                    Throwable exception = connectStatus.getException();
                    if (exception != null) {
                        msg = RSEUIPlugin.getPluginMessage((String)"RSEG1056");
                        msg.makeSubstitution((Object)this.getHostName(), (Object)exception);
                    }
                }
            } else if (connectStatus == null) {
                SystemBasePlugin.logError((String)"Failed to connect to remote system", null);
                msg = RSEUIPlugin.getPluginMessage((String)"RSEC1001");
                msg.makeSubstitution((Object)this.getHostName());
            }
            if (msg == null) {
                SystemBasePlugin.logError((String)("Failed to connect to remote system" + connectStatus.getMessage()), null);
                msg = RSEUIPlugin.getPluginMessage((String)"RSEC1001");
                msg.makeSubstitution((Object)this.getHostName());
            }
            this.clientConnection.disconnect();
            this.clientConnection = null;
            if (msg.getFullMessageID().startsWith("RSEC2302")) {
                if (launchFailed) {
                    this.clearPasswordCache(true);
                }
                DisplaySystemMessageAction msgAction3 = new DisplaySystemMessageAction(msg);
                Display.getDefault().syncExec((Runnable)msgAction3);
                this.connectException = null;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            DStoreConnectorService.this.promptForPassword(Display.getDefault().getActiveShell(), true);
                        }
                        catch (InterruptedException e) {
                            DStoreConnectorService.this.connectException = e;
                        }
                    }
                });
                if (this.connectException instanceof InterruptedException) {
                    throw this.connectException;
                }
                this.internalConnect(monitor);
                return;
            }
            throw new SystemMessageException(msg);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("connect time = " + (t2 - t1));
    }

    protected boolean isPasswordExpired(String message) {
        return message.indexOf("password expired") != -1;
    }

    protected boolean isNewPasswordInvalid(String message) {
        return message.indexOf("new password not valid") != -1;
    }

    protected void importCertsAndReconnect(ConnectionStatus connectStatus, IProgressMonitor monitor) throws Exception {
        ISystemKeystoreProvider provider;
        List certs = connectStatus.getUntrustedCertificates();
        if (certs != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null) {
            if (provider.importCertificates(certs, this.getHostName())) {
                this.internalConnect(monitor);
                return;
            }
            throw new InterruptedException();
        }
    }

    protected int launchUsingRexec(IProgressMonitor monitor, SystemSignonInformation info, IServerLauncherProperties serverLauncherProperties) throws Exception {
        IServerLauncher starter = this.getRemoteServerLauncher();
        starter.setSignonInformation(info);
        starter.setServerLauncherProperties(serverLauncherProperties);
        String serverPort = (String)starter.launch(monitor);
        if (monitor.isCanceled()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1067");
            throw new SystemMessageException(msg);
        }
        int iServerPort = 0;
        if (serverPort != null) {
            iServerPort = Integer.parseInt(serverPort);
        }
        return iServerPort;
    }

    protected boolean setSSLProperties(boolean enable) {
        ISystemKeystoreProvider provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider();
        if (provider != null) {
            String keyStore = provider.getKeyStorePath();
            String password = provider.getKeyStorePassword();
            ClientSSLProperties properties = new ClientSSLProperties(enable, keyStore, password);
            this.clientConnection.setSSLProperties((ISSLProperties)properties);
            return true;
        }
        return false;
    }

    protected boolean promptForTrusting(Shell shell, X509Certificate cert) {
        return true;
    }

    protected ConnectionStatus launchServer(ClientConnection clientConnection, SystemSignonInformation info, int daemonPort, IProgressMonitor monitor) {
        return this.launchServer(clientConnection, info, daemonPort, monitor, 0);
    }

    protected ConnectionStatus launchServer(ClientConnection clientConnection, SystemSignonInformation info, int daemonPort, IProgressMonitor monitor, int timeout) {
        return clientConnection.launchServer(info.getUserid(), info.getPassword(), daemonPort, timeout);
    }

    protected ConnectionStatus launchServer(ClientConnection clientConnection, SystemSignonInformation info, IServerLauncherProperties launcher, IProgressMonitor monitor) {
        return null;
    }

    protected ConnectionStatus changePassword(ClientConnection clientConnection, SystemSignonInformation info, IServerLauncherProperties serverLauncherProperties, IProgressMonitor monitor, String newPassword) {
        return new ConnectionStatus(false, "Authentification Failed");
    }

    public boolean isConnected() {
        if (this.clientConnection != null) {
            return this.clientConnection.isConnected();
        }
        return false;
    }

    public boolean isNetworkError() {
        if (this._connectionStatusListener != null) {
            return this._connectionStatusListener.isConnectionDown();
        }
        return false;
    }

    public void showWarningMsgs(Shell shell, Vector warnings) {
        int idx = 0;
        while (idx < warnings.size()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEO1011");
            msg.makeSubstitution((Object)warnings.elementAt(idx).toString());
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
            msgDlg.open();
            ++idx;
        }
    }

    public DataStore getDataStore() {
        if (this.clientConnection != null) {
            return this.clientConnection.getDataStore();
        }
        return null;
    }

    public SystemSignonInformation getPasswordInformation() {
        if (this.getPrimarySubSystem().getHost().getSystemType().equals("Windows")) {
            String userid = this.getPrimarySubSystem().getUserId();
            if (userid == null) {
                userid = "remoteuser";
            }
            SystemSignonInformation info = new SystemSignonInformation(this.getPrimarySubSystem().getHost().getHostName(), userid, "", "Windows");
            return info;
        }
        return super.getPasswordInformation();
    }

    public boolean isPasswordCached() {
        if (this.getPrimarySubSystem().getHost().getSystemType().equals("Windows")) {
            return false;
        }
        return super.isPasswordCached();
    }

    public boolean hasRemoteServerLauncherProperties() {
        return this.getRemoteServerLauncherProperties() != null;
    }

    public boolean supportsRemoteServerLaunching() {
        return true;
    }

    public boolean supportsServerLaunchProperties() {
        return true;
    }

    private class ShowConnectMessage
    implements Runnable {
        private SystemMessage _msg;

        public ShowConnectMessage(SystemMessage msg) {
            this._msg = msg;
        }

        public void run() {
            SystemMessageDialog dlg = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), this._msg);
            dlg.open();
        }
    }
}

