/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.dstore.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.extra.internal.extra.DomainEvent;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectionStatusListener
implements IDomainListener,
IRunnableWithProgress {
    protected DataElement _dataStoreStatus;
    protected IConnectorService _connection;
    protected boolean _connectionDown = false;

    public ConnectionStatusListener(DataElement status, IConnectorService connection) {
        this._dataStoreStatus = status;
        this._connection = connection;
    }

    protected Shell internalGetShell() {
        Shell activeShell = SystemBasePlugin.getActiveWorkbenchShell();
        if (activeShell != null) {
            return activeShell;
        }
        IWorkbenchWindow window = null;
        try {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (Exception exception) {
            return null;
        }
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows != null && windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    protected void handleConnectionDown() {
        Display.getDefault().asyncExec((Runnable)new ConnectionDown(this));
    }

    public boolean listeningTo(DomainEvent event) {
        return this._dataStoreStatus == event.getParent();
    }

    public void domainChanged(DomainEvent event) {
        if (!this._dataStoreStatus.getName().equals("okay")) {
            this.handleConnectionDown();
        }
    }

    public Shell getShell() {
        return this.internalGetShell();
    }

    public boolean isConnectionDown() {
        return this._connectionDown;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String message = null;
        message = SubSystemConfiguration.getDisconnectingMessage((String)this._connection.getHostName(), (int)this._connection.getPort());
        monitor.beginTask(message, -1);
        try {
            try {
                this._connection.disconnect(monitor);
            }
            catch (Exception exc) {
                if (exc instanceof InvocationTargetException) {
                    throw (InvocationTargetException)exc;
                }
                if (!(exc instanceof InterruptedException)) throw new InvocationTargetException(exc);
                throw (InterruptedException)exc;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    protected IRunnableContext getRunnableContext(Shell rshell) {
        Shell shell = this.getShell();
        IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
        if (win != null) {
            Shell winShell = RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            if (winShell != null && !winShell.isDisposed() && winShell.isVisible()) {
                SystemBasePlugin.logInfo((String)"Using active workbench window as runnable context");
                shell = winShell;
                return win;
            }
            win = null;
        }
        if (shell == null || shell.isDisposed() || !shell.isVisible()) {
            SystemBasePlugin.logInfo((String)"Using progress monitor dialog with given shell as parent");
            shell = rshell;
        }
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(rshell);
        return dlg;
    }

    protected void showDisconnectErrorMessage(Shell shell, String hostName, int port, Exception exc) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage((String)"RSEG1061").makeSubstitution((Object)hostName, (Object)exc));
        msgDlg.setException((Throwable)exc);
        msgDlg.open();
    }

    protected void showDisconnectCancelledMessage(Shell shell, String hostName, int port) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage((String)"RSEG1062").makeSubstitution((Object)hostName));
        msgDlg.open();
    }

    class ConnectionDown
    implements Runnable {
        private ConnectionStatusListener _listener;

        public ConnectionDown(ConnectionStatusListener listener) {
            this._listener = listener;
        }

        public void run() {
            Shell shell = ConnectionStatusListener.this.getShell();
            ConnectionStatusListener.this._connectionDown = true;
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1057");
            msg.makeSubstitution((Object)ConnectionStatusListener.this._connection.getPrimarySubSystem().getHost().getAliasName());
            SystemMessageDialog dialog = new SystemMessageDialog(ConnectionStatusListener.this.internalGetShell(), msg);
            dialog.open();
            try {
                IRunnableContext runnableContext = ConnectionStatusListener.this.getRunnableContext(ConnectionStatusListener.this.getShell());
                runnableContext.run(false, true, (IRunnableWithProgress)this._listener);
                ConnectionStatusListener.this._connection.reset();
                ISystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
                sr.connectedStatusChange(ConnectionStatusListener.this._connection.getPrimarySubSystem(), false, true, true);
            }
            catch (InterruptedException interruptedException) {
                if (shell != null) {
                    ConnectionStatusListener.this.showDisconnectCancelledMessage(shell, ConnectionStatusListener.this._connection.getHostName(), ConnectionStatusListener.this._connection.getPort());
                }
            }
            catch (InvocationTargetException invokeExc) {
                Exception exc = (Exception)invokeExc.getTargetException();
                if (shell != null) {
                    ConnectionStatusListener.this.showDisconnectErrorMessage(shell, ConnectionStatusListener.this._connection.getHostName(), ConnectionStatusListener.this._connection.getPort(), exc);
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"ConnectionStatusListener:  Error disconnecting", (Throwable)e);
            }
        }
    }
}

