/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.ftp.FTPClientService;
import org.eclipse.rse.services.files.ftp.FTPHostFile;
import org.eclipse.rse.services.files.ftp.FTPLinuxDirectoryListingParser;
import org.eclipse.rse.services.files.ftp.FTPServiceResources;
import org.eclipse.rse.services.files.ftp.IFTPDirectoryListingParser;
import org.eclipse.rse.services.files.ftp.IFTPService;
import sun.net.TelnetInputStream;

public class FTPService
extends AbstractFileService
implements IFileService,
IFTPService {
    private FTPClientService _ftpClient;
    private String _userHome;
    private IFTPDirectoryListingParser _ftpPropertiesUtil;
    private transient String _hostname;
    private transient String _userId;
    private transient String _password;

    public String getName() {
        return FTPServiceResources.FTP_File_Service_Name;
    }

    public String getDescription() {
        return FTPServiceResources.FTP_File_Service_Description;
    }

    public void setHostName(String hostname) {
        this._hostname = hostname;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void connect() throws Exception {
        FTPClientService ftp = this.getFTPClient();
        ftp.openServer(this._hostname);
        ftp.login(this._userId, this._password);
        this._userHome = ftp.pwd();
    }

    protected void reconnect() {
        try {
            this.connect();
        }
        catch (Exception exception) {}
    }

    public void disconnect() {
        try {
            this.getFTPClient().closeServer();
            this._ftpClient = null;
        }
        catch (Exception exception) {
            this._ftpClient = null;
        }
    }

    public IFTPDirectoryListingParser getDirListingParser() {
        if (this._ftpPropertiesUtil == null) {
            this._ftpPropertiesUtil = new FTPLinuxDirectoryListingParser();
        }
        return this._ftpPropertiesUtil;
    }

    public FTPClientService getFTPClient() {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClientService();
        }
        return this._ftpClient;
    }

    public IHostFile getFile(IProgressMonitor monitor, String remoteParent, String fileName) {
        IHostFile[] matches = this.internalFetch(monitor, remoteParent, fileName, 0);
        if (matches != null && matches.length > 0) {
            return matches[0];
        }
        return null;
    }

    public boolean isConnected() {
        return this.getFTPClient().serverIsOpen();
    }

    protected IHostFile[] internalFetch(IProgressMonitor monitor, String parentPath, String fileFilter, int fileType) {
        if (fileFilter == null) {
            fileFilter = "*";
        }
        NamePatternMatcher filematcher = new NamePatternMatcher(fileFilter, true, true);
        ArrayList<FTPHostFile> results = new ArrayList<FTPHostFile>();
        try {
            FTPClientService ftp = this.getFTPClient();
            try {
                ftp.noop();
            }
            catch (Exception exception) {
                this.disconnect();
                this.reconnect();
                ftp = this.getFTPClient();
            }
            ftp.cd(parentPath);
            TelnetInputStream stream = ftp.list();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            while (line != null) {
                FTPHostFile node = this.getDirListingParser().getFTPHostFile(line, parentPath);
                if (node != null && filematcher.matches(node.getName()) && this.isRightType(fileType, node)) {
                    results.add(node);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public String getSeparator() {
        return "/";
    }

    public boolean upload(IProgressMonitor monitor, File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding) {
        FTPClientService ftp = this.getFTPClient();
        try {
            ftp.cd(remoteParent);
            if (isBinary) {
                ftp.binary();
            } else {
                ftp.ascii();
            }
            ftp.put(localFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean upload(IProgressMonitor monitor, InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding) {
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("ftp", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
            }
            bos.close();
            FTPClientService ftp = this.getFTPClient();
            try {
                ftp.cd(remoteParent);
                if (isBinary) {
                    ftp.binary();
                } else {
                    ftp.ascii();
                }
                ftp.put(tempFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean download(IProgressMonitor monitor, String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding) {
        FTPClientService ftp = this.getFTPClient();
        try {
            int readCount;
            ftp.cd(remoteParent);
            ftp.binary();
            TelnetInputStream is = ftp.get(remoteFile);
            BufferedInputStream bis = new BufferedInputStream(is);
            if (!localFile.exists()) {
                File localParentFile = localFile.getParentFile();
                if (!localParentFile.exists()) {
                    localParentFile.mkdirs();
                }
                localFile.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(localFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            int totalWrote = 0;
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
                totalWrote += readCount;
            }
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public IHostFile getUserHome() {
        int lastSlash = this._userHome.lastIndexOf(47);
        String name = this._userHome.substring(lastSlash + 1);
        String parent = this._userHome.substring(0, lastSlash);
        return this.getFile(null, parent, name);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        FTPHostFile root = new FTPHostFile("/", "/", true, true, 0L, 0L);
        return new IHostFile[]{root};
    }

    public IHostFile createFile(IProgressMonitor monitor, String remoteParent, String fileName) {
        return null;
    }

    public IHostFile createFolder(IProgressMonitor monitor, String remoteParent, String folderName) {
        return null;
    }

    public boolean delete(IProgressMonitor monitor, String remoteParent, String fileName) {
        return false;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName) {
        return false;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName, IHostFile oldFile) {
        return false;
    }

    public boolean move(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) {
        return false;
    }

    public boolean copy(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) {
        return false;
    }

    public boolean copyBatch(IProgressMonitor monitor, String[] srcParents, String[] srcNames, String tgtParent) throws SystemMessageException {
        boolean ok = true;
        int i = 0;
        while (i < srcParents.length) {
            ok = ok && this.copy(monitor, srcParents[i], srcNames[i], tgtParent, srcNames[i]);
            ++i;
        }
        return ok;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

