/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.dstore.core.client.ClientAttributes;
import org.eclipse.dstore.core.client.ClientCommandHandler;
import org.eclipse.dstore.core.client.ClientReceiver;
import org.eclipse.dstore.core.client.ClientUpdateHandler;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.model.CommandHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreConstants;
import org.eclipse.dstore.core.model.ISSLProperties;
import org.eclipse.dstore.core.server.ServerCommandHandler;
import org.eclipse.dstore.core.server.ServerLauncher;
import org.eclipse.dstore.core.util.ExternalLoader;
import org.eclipse.dstore.core.util.Sender;
import org.eclipse.dstore.core.util.ssl.DStoreSSLContext;
import org.eclipse.dstore.core.util.ssl.DataStoreTrustManager;
import org.eclipse.dstore.extra.internal.extra.DomainNotifier;

public class ClientConnection
implements IDataStoreConstants {
    private ClientAttributes _clientAttributes;
    private Socket _theSocket;
    private boolean _isConnected = false;
    private boolean _isRemote = false;
    private DataStore _dataStore;
    private DomainNotifier _domainNotifier;
    private Sender _sender;
    private ClientReceiver _receiver;
    private ClientUpdateHandler _updateHandler;
    private CommandHandler _commandHandler;
    private int _clientVersion;
    private int _clientMinor;
    private String _name;
    private String _host;
    private String _port;
    private String _hostDirectory;
    private Socket _launchSocket;
    private DataStoreTrustManager _trustManager;
    private ArrayList _loaders;
    private static final int HANDSHAKE_INCORRECT = 0;
    private static final int HANDSHAKE_SERVER_OLDER = 1;
    private static final int HANDSHAKE_CORRECT = 2;
    private static final int HANDSHAKE_UNEXPECTED = 3;
    private static final int HANDSHAKE_SERVER_NEWER = 4;
    private static final int HANDSHAKE_SERVER_RECENT_OLDER = 5;
    private static final int HANDSHAKE_SERVER_RECENT_NEWER = 6;
    private static final int HANDSHAKE_TIMEOUT = 7;
    private static final int VERSION_INDEX_PROTOCOL = 0;
    private static final int VERSION_INDEX_VERSION = 1;
    private static final int VERSION_INDEX_MINOR = 2;
    public static String INCOMPATIBLE_SERVER_UPDATE = "Incompatible DataStore.";
    public static String INCOMPATIBLE_CLIENT_UPDATE = "Incompatible DataStore.";
    public static String SERVER_OLDER = "Older DataStore Server.";
    public static String CLIENT_OLDER = "Older DataStore Client.";
    public static String INCOMPATIBLE_PROTOCOL = "Incompatible Protocol.";
    public static String CANNOT_CONNECT = "Cannot connect to server.";

    public ClientConnection(String name) {
        this._domainNotifier = new DomainNotifier();
        this._name = name;
        this.init();
    }

    public ClientConnection(String name, int initialSize) {
        this._domainNotifier = new DomainNotifier();
        this._name = name;
        this.init(initialSize);
    }

    public ClientConnection(String name, DomainNotifier notifier) {
        this._domainNotifier = notifier;
        this._name = name;
        this.init();
    }

    public ClientConnection(String name, DomainNotifier notifier, int initialSize) {
        this._domainNotifier = notifier;
        this._name = name;
        this.init(initialSize);
    }

    public int getClientVersion() {
        return this._clientVersion;
    }

    public int getClientMinor() {
        return this._clientMinor;
    }

    public int getServerVersion() {
        return this._dataStore.getServerVersion();
    }

    public int getServerMinor() {
        return this._dataStore.getServerMinor();
    }

    public void setSSLProperties(ISSLProperties properties) {
        this._dataStore.setSSLProperties(properties);
    }

    public void setLoaders(ArrayList loaders) {
        this._loaders = loaders;
    }

    public void addLoader(ExternalLoader loader) {
        if (this._loaders == null) {
            this._loaders = new ArrayList();
        }
        this._loaders.add(loader);
    }

    public void setHost(String host) {
        this._host = host;
        this._clientAttributes.setAttribute(3, this._host);
    }

    public void setPort(String port) {
        if (port == null || port.length() == 0) {
            port = "0";
        }
        this._port = port;
        this._clientAttributes.setAttribute(5, this._port);
    }

    public void setHostDirectory(String directory) {
        this._hostDirectory = directory;
        this._clientAttributes.setAttribute(4, this._hostDirectory);
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public String getHostDirectory() {
        return this._hostDirectory;
    }

    public boolean isConnected() {
        if (this._isConnected) {
            return this._dataStore.isConnected();
        }
        return this._isConnected;
    }

    public void disconnect() {
        if (this._isConnected) {
            this._dataStore.setConnected(false);
            if (this._isRemote) {
                this._commandHandler.command(this._dataStore.find(this._dataStore.getRoot(), 2, "Exit"), this._dataStore.getHostRoot(), false);
                this._receiver.finish();
            }
            this._commandHandler.finish();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
            this._updateHandler.finish();
            this._dataStore.finish();
            this._isConnected = false;
        }
    }

    public ConnectionStatus localConnect() {
        this._updateHandler = new ClientUpdateHandler();
        this._updateHandler.start();
        if (this._loaders == null) {
            this._loaders = new ArrayList();
            this._loaders.add(new ExternalLoader(this.getClass().getClassLoader(), "*"));
        }
        this._commandHandler = new ServerCommandHandler(this._loaders);
        this._commandHandler.start();
        this._dataStore.setCommandHandler(this._commandHandler);
        this._dataStore.setUpdateHandler(this._updateHandler);
        this._dataStore.setConnected(true);
        this._dataStore.setLoaders(this._loaders);
        this._dataStore.getDomainNotifier().enable(true);
        this._commandHandler.setDataStore(this._dataStore);
        this._updateHandler.setDataStore(this._dataStore);
        ((ServerCommandHandler)this._commandHandler).loadMiners();
        this._clientAttributes.setAttribute(6, this._clientAttributes.getAttribute(3));
        this._clientAttributes.setAttribute(7, this._clientAttributes.getAttribute(4));
        this._isConnected = true;
        DataElement ticket = this._dataStore.getTicket();
        ticket.setAttribute(2, "null");
        ConnectionStatus result = new ConnectionStatus(this._isConnected);
        result.setTicket(ticket.getName());
        return result;
    }

    public ConnectionStatus connect(boolean launchServer, String user, String password) {
        ConnectionStatus launchStatus = null;
        if (launchServer) {
            launchStatus = this.launchServer(user, password);
            if (!launchStatus.isConnected()) {
                return launchStatus;
            }
        } else {
            launchStatus = new ConnectionStatus(true);
            launchStatus.setTicket("null");
        }
        return this.connect(launchStatus.getTicket());
    }

    public DataStoreTrustManager getTrustManager() {
        if (this._trustManager == null) {
            this._trustManager = new DataStoreTrustManager();
        }
        return this._trustManager;
    }

    public ConnectionStatus connect(String ticket) {
        return this.connect(ticket, 0);
    }

    public ConnectionStatus connect(String ticket, int timeout) {
        boolean doTimeOut = timeout > 0;
        ConnectionStatus result = null;
        try {
            int port = 0;
            if (this._port != null && this._port.length() > 0) {
                port = Integer.parseInt(this._port);
            }
            if (!this._dataStore.usingSSL()) {
                this._theSocket = new Socket(this._host, port);
                if (doTimeOut && this._theSocket != null) {
                    this._theSocket.setSoTimeout(timeout);
                }
            } else {
                String location = this._dataStore.getKeyStoreLocation();
                String pw = this._dataStore.getKeyStorePassword();
                DataStoreTrustManager mgr = this.getTrustManager();
                SSLContext context = DStoreSSLContext.getClientSSLContext(location, pw, mgr);
                SSLSocketFactory factory = context.getSocketFactory();
                this._theSocket = factory.createSocket(this._host, port);
                if (doTimeOut && this._theSocket != null) {
                    this._theSocket.setSoTimeout(timeout);
                }
                try {
                    ((SSLSocket)this._theSocket).startHandshake();
                    ((SSLSocket)this._theSocket).getSession();
                }
                catch (SSLHandshakeException e) {
                    result = new ConnectionStatus(false, e, true, mgr.getUntrustedCerts());
                    return result;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._theSocket.close();
                    result = new ConnectionStatus(false, e);
                    return result;
                }
            }
            String msg = null;
            int handshakeResult = this.doHandShake();
            switch (handshakeResult) {
                case 2: {
                    result = this.doConnect(ticket);
                    break;
                }
                case 6: {
                    result = this.doConnect(ticket);
                    result.setMessage(CLIENT_OLDER);
                    break;
                }
                case 5: {
                    result = this.doConnect(ticket);
                    result.setMessage(SERVER_OLDER);
                    break;
                }
                case 4: {
                    msg = INCOMPATIBLE_CLIENT_UPDATE;
                    msg = String.valueOf(msg) + "\nThe server running on " + this._host + " under port " + this._port + " is a newer DataStore server.";
                    break;
                }
                case 1: {
                    msg = INCOMPATIBLE_SERVER_UPDATE;
                    msg = String.valueOf(msg) + "\nThe server running on " + this._host + " under port " + this._port + " is an older DataStore server.";
                    break;
                }
                case 0: {
                    msg = CANNOT_CONNECT;
                    msg = String.valueOf(msg) + INCOMPATIBLE_PROTOCOL;
                    msg = String.valueOf(msg) + "\nThe server running on " + this._host + " under port " + this._port + " is not a valid DataStore server.";
                    break;
                }
                case 3: {
                    msg = CANNOT_CONNECT;
                    msg = String.valueOf(msg) + "Unexpected exception.";
                    break;
                }
                case 7: {
                    msg = CANNOT_CONNECT;
                    msg = String.valueOf(msg) + "Timeout waiting for socket activity.";
                    break;
                }
            }
            if (result == null && msg != null) {
                result = new ConnectionStatus(false, msg);
                this._isConnected = false;
                this._theSocket.close();
            }
        }
        catch (ConnectException connectException) {
            String msg = "Connection Refused.";
            msg = String.valueOf(msg) + "\nMake sure that the DataStore server is running on " + this._host + " under port " + this._port + ".";
            result = new ConnectionStatus(false, msg);
        }
        catch (UnknownHostException uhe) {
            this._isConnected = false;
            result = new ConnectionStatus(this._isConnected, uhe);
        }
        catch (IOException ioe) {
            this._isConnected = false;
            result = new ConnectionStatus(this._isConnected, ioe);
        }
        return result;
    }

    protected ConnectionStatus doConnect(String ticket) {
        this._sender = new Sender(this._theSocket, this._dataStore);
        this._updateHandler = new ClientUpdateHandler();
        this._updateHandler.start();
        this._commandHandler = new ClientCommandHandler(this._sender);
        this._commandHandler.start();
        this._dataStore.setCommandHandler(this._commandHandler);
        this._dataStore.setUpdateHandler(this._updateHandler);
        this._dataStore.setConnected(true);
        this._dataStore.getDomainNotifier().enable(true);
        this._commandHandler.setDataStore(this._dataStore);
        this._updateHandler.setDataStore(this._dataStore);
        this._receiver = new ClientReceiver(this._theSocket, this._dataStore);
        this._receiver.start();
        this._isConnected = true;
        this._isRemote = true;
        ConnectionStatus result = new ConnectionStatus(this._isConnected);
        result.setTicket(ticket);
        return result;
    }

    public ConnectionStatus launchServer(String user, String password) {
        return this.launchServer(user, password, ServerLauncher.DEFAULT_DAEMON_PORT);
    }

    public ConnectionStatus launchServer(String user, String password, int daemonPort) {
        return this.launchServer(user, password, daemonPort, 0);
    }

    public ConnectionStatus launchServer(String user, String password, int daemonPort, int timeout) {
        boolean doTimeOut;
        ConnectionStatus result = this.connectDaemon(daemonPort);
        boolean bl = doTimeOut = timeout > 0;
        if (!result.isConnected()) {
            return result;
        }
        try {
            PrintWriter writer = null;
            BufferedReader reader = null;
            try {
                if (doTimeOut) {
                    this._launchSocket.setSoTimeout(timeout);
                }
                writer = new PrintWriter(new OutputStreamWriter(this._launchSocket.getOutputStream(), "UTF-8"));
                writer.println(user);
                writer.println(password);
                writer.println(this._port);
                writer.flush();
                reader = new BufferedReader(new InputStreamReader(this._launchSocket.getInputStream(), "UTF-8"));
                String status = null;
                try {
                    status = reader.readLine();
                }
                catch (InterruptedIOException e) {
                    result = new ConnectionStatus(false, e);
                }
                if (status != null && !status.equals("connected")) {
                    result = new ConnectionStatus(false, status);
                } else {
                    result = new ConnectionStatus(true);
                    this._port = reader.readLine();
                    String ticket = reader.readLine();
                    result.setTicket(ticket);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = new ConnectionStatus(false, e);
            }
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            this._launchSocket.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            result = new ConnectionStatus(false, ioe);
        }
        return result;
    }

    public ConnectionStatus connectDaemon(int daemonPort) {
        ConnectionStatus result;
        block12: {
            result = new ConnectionStatus(true);
            try {
                this._launchSocket = null;
                if (this._dataStore.usingSSL()) {
                    try {
                        String location = this._dataStore.getKeyStoreLocation();
                        String pw = this._dataStore.getKeyStorePassword();
                        DataStoreTrustManager mgr = this.getTrustManager();
                        SSLContext context = DStoreSSLContext.getClientSSLContext(location, pw, mgr);
                        try {
                            SSLSocketFactory factory = context.getSocketFactory();
                            SSLSocket lSocket = (SSLSocket)factory.createSocket(this._host, daemonPort);
                            this._launchSocket = lSocket;
                            lSocket.startHandshake();
                            SSLSession session = lSocket.getSession();
                            if (session == null) {
                                lSocket.close();
                            }
                            break block12;
                        }
                        catch (SSLHandshakeException e) {
                            result = new ConnectionStatus(false, e, true, mgr.getUntrustedCerts());
                            return result;
                        }
                        catch (Exception e) {
                            if (this._launchSocket != null) {
                                this._launchSocket.close();
                            }
                            result = new ConnectionStatus(false, e);
                            return result;
                        }
                    }
                    catch (Exception e) {
                        result = new ConnectionStatus(false, e);
                        return result;
                    }
                }
                this._launchSocket = new Socket(this._host, daemonPort);
            }
            catch (ConnectException connectException) {
                String msg = "Connection Refused.";
                msg = String.valueOf(msg) + "\nMake sure that the DataStore daemon is running on " + this._host + ".";
                result = new ConnectionStatus(false, msg);
            }
            catch (UnknownHostException uhe) {
                result = new ConnectionStatus(false, uhe);
            }
            catch (IOException ioe) {
                result = new ConnectionStatus(false, ioe);
            }
        }
        return result;
    }

    public Socket getLaunchSocket() {
        return this._launchSocket;
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    private void init() {
        this.init(10000);
    }

    private void init(int initialSize) {
        this._clientAttributes = new ClientAttributes();
        this._clientAttributes.setAttribute(1, this._name);
        this._dataStore = new DataStore(this._clientAttributes, initialSize);
        this._dataStore.setDomainNotifier(this._domainNotifier);
        this._dataStore.createRoot();
        this._host = this._clientAttributes.getAttribute(3);
        this._hostDirectory = this._clientAttributes.getAttribute(4);
        this._port = this._clientAttributes.getAttribute(5);
    }

    private void flush(DataElement object) {
        this._dataStore.flush(object);
    }

    private void flush() {
        this._dataStore.flush(this._dataStore.getHostRoot());
        this._dataStore.flush(this._dataStore.getLogRoot());
        this._dataStore.flush(this._dataStore.getDescriptorRoot());
        this._dataStore.createRoot();
    }

    private int doHandShake() {
        String handshake;
        block14: {
            block16: {
                block15: {
                    String[] serverVersionStr;
                    String[] clientVersionStr;
                    block13: {
                        block12: {
                            try {
                                BufferedReader reader = new BufferedReader(new InputStreamReader(this._theSocket.getInputStream(), "UTF-8"));
                                PrintWriter writer = new PrintWriter(new OutputStreamWriter(this._theSocket.getOutputStream(), "UTF-8"));
                                writer.println("");
                                writer.println("");
                                writer.println("");
                                writer.flush();
                                handshake = null;
                                try {
                                    handshake = reader.readLine();
                                }
                                catch (InterruptedIOException interruptedIOException) {
                                    return 7;
                                }
                            }
                            catch (Exception exception) {
                                return 3;
                            }
                            this._theSocket.setSoTimeout(0);
                            clientVersionStr = "DataStore.8.0.0".split("\\.");
                            serverVersionStr = handshake.split("\\.");
                            this._dataStore.setServerVersion(Integer.parseInt(serverVersionStr[1]));
                            this._dataStore.setServerMinor(Integer.parseInt(serverVersionStr[2]));
                            if (!handshake.equals("DataStore.8.0.0")) break block12;
                            return 2;
                        }
                        if (!handshake.startsWith("<DataElement")) break block13;
                        return 1;
                    }
                    if (!serverVersionStr[0].equals(clientVersionStr[0])) break block14;
                    if (this._dataStore.getServerVersion() != this._clientVersion) break block15;
                    return 2;
                }
                if (this._dataStore.getServerVersion() <= this._clientVersion) break block16;
                if (this._dataStore.getServerVersion() - 1 == this._clientVersion) {
                    return 6;
                }
                return 4;
            }
            if (this._dataStore.getServerVersion() + 1 == this._clientVersion) {
                return 5;
            }
            return 1;
        }
        System.out.println("handshake=" + handshake);
        return 0;
    }

    public boolean isKnownStatus(String status) {
        return status.equals("connected") || status.equals("Authentification Failed") || status.equals("unknown problem connecting to server") || status.startsWith("server failure: ") || status.equals("password expired") || status.equals("new password not valid");
    }
}

