/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.filesystem;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;

public class ClassFileParser {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private DataInputStream in;
    private ArrayList classes = new ArrayList();
    private ArrayList utf8s = new ArrayList();

    public ClassFileParser(InputStream stream) {
        this.in = new DataInputStream(stream);
    }

    public String getPackageName() {
        String packageName = null;
        try {
            this.in.skipBytes(8);
            int constPoolCount = this.in.readUnsignedShort();
            int loop = 1;
            while (loop < constPoolCount) {
                int tag = this.in.readUnsignedByte();
                switch (tag) {
                    case 7: {
                        int index = this.in.readUnsignedShort();
                        this.classes.add(new _Class(loop, index));
                        break;
                    }
                    case 1: {
                        int len = this.in.readUnsignedShort();
                        byte[] data = new byte[len];
                        this.in.read(data, 0, len);
                        this.utf8s.add(new _Utf8(loop, data));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.in.skipBytes(4);
                        break;
                    }
                    case 8: {
                        this.in.skipBytes(2);
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.in.skipBytes(8);
                        ++loop;
                        break;
                    }
                }
                ++loop;
            }
            this.in.skipBytes(2);
            int classNameIndex = this.in.readUnsignedShort();
            boolean found = false;
            int utf8Index = -1;
            int loop2 = 0;
            while (loop2 < this.classes.size() && !found) {
                if (((_Class)this.classes.get((int)loop2)).pool_index == classNameIndex) {
                    found = true;
                    utf8Index = ((_Class)this.classes.get((int)loop2)).name_index;
                }
                ++loop2;
            }
            found = false;
            loop2 = 0;
            while (loop2 < this.utf8s.size() && !found) {
                if (((_Utf8)this.utf8s.get((int)loop2)).pool_index == utf8Index) {
                    packageName = new String(((_Utf8)this.utf8s.get((int)loop2)).bytes);
                    packageName = packageName.replace('/', '.');
                    found = true;
                }
                ++loop2;
            }
            this.in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packageName;
    }

    private class _Class {
        public int pool_index;
        public int name_index;

        public _Class(int pIndx, int nIndx) {
            this.pool_index = pIndx;
            this.name_index = nIndx;
        }
    }

    private class _Utf8 {
        public int pool_index;
        public byte[] bytes;

        public _Utf8(int pIndx, byte[] bytes) {
            this.pool_index = pIndx;
            this.bytes = bytes;
        }
    }
}

