/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.util.ArrayList;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.dstore.core.util.CommandGenerator;

public abstract class CommandHandler
extends Handler {
    protected ArrayList _commands = new ArrayList();
    protected ArrayList _classesToSend = new ArrayList();
    private CommandGenerator _commandGenerator = new CommandGenerator();

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
        this._commandGenerator.setDataStore(dataStore);
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(DataElement command, boolean immediate) {
        ArrayList arrayList = this._commands;
        synchronized (arrayList) {
            if (!this._commands.contains(command)) {
                if (immediate) {
                    this._commands.add(0, command);
                } else {
                    this._commands.add(command);
                }
            }
            this.notifyInput();
        }
    }

    public void handle() {
        if (!this._commands.isEmpty() || !this._classesToSend.isEmpty()) {
            this.sendCommands();
        }
    }

    public DataElement command(DataElement commandDescriptor, ArrayList arguments, DataElement object, boolean refArg, boolean immediate) {
        DataElement command = this._commandGenerator.generateCommand(commandDescriptor, arguments, object, refArg);
        return this.command(command, immediate);
    }

    public DataElement command(DataElement commandDescriptor, DataElement arg, DataElement object, boolean refArg, boolean immediate) {
        DataElement command = this._commandGenerator.generateCommand(commandDescriptor, arg, object, refArg);
        return this.command(command, immediate);
    }

    public DataElement command(DataElement commandDescriptor, DataElement object, boolean refArg) {
        DataElement command = this._commandGenerator.generateCommand(commandDescriptor, object, refArg);
        return this.command(command);
    }

    public DataElement command(DataElement cmd) {
        return this.command(cmd, false);
    }

    public DataElement command(DataElement cmd, boolean immediate) {
        DataElement status = null;
        if (cmd != null && this._dataStore != null && (status = cmd.get(cmd.getNestedSize() - 1)) != null && !status.getName().equals(DataStoreResources.model_done)) {
            this.addCommand(cmd, immediate);
        }
        return status;
    }

    public synchronized void cancelAllCommands() {
        DataElement log = this._dataStore.getLogRoot();
        int i = 0;
        while (i < this._commands.size()) {
            log.removeNestedData((DataElement)this._commands.get(i));
            ++i;
        }
        this._commands.clear();
    }

    public CommandGenerator getCommandGenerator() {
        return this._commandGenerator;
    }

    public abstract void sendCommands();

    public abstract void sendFile(String var1, byte[] var2, int var3, boolean var4);

    public abstract void sendFile(String var1, byte[] var2, int var3, boolean var4, String var5);

    public abstract void sendAppendFile(String var1, byte[] var2, int var3, boolean var4);

    public abstract void sendAppendFile(String var1, byte[] var2, int var3, boolean var4, String var5);

    public abstract void sendClass(String var1);

    public abstract void sendClass(String var1, String var2);

    public abstract void sendClassInstance(IRemoteClassInstance var1, String var2);

    public synchronized void waitForInput() {
        if (this._commands.size() == 0 && this._classesToSend.size() == 0) {
            super.waitForInput();
        }
    }

    public abstract void requestClass(String var1);

    public abstract void sendKeepAliveConfirmation();

    public abstract void sendKeepAliveRequest();
}

