/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalUtilities {
    private static String NULL = null;
    private static String LOCAL_TERMINAL = "org.eclipse.tm.terminal.local.launch";
    public static final String LINE_SEPARATOR_PROPERTY = "line.separator";
    public static final String CRLF = "\r\n";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final ILaunchManager LAUNCH_MANAGER = DebugPlugin.getDefault().getLaunchManager();
    public static final ILaunchConfigurationType PROGRAM_LAUNCH_TYPE = LAUNCH_MANAGER.getLaunchConfigurationType(LOCAL_TERMINAL);

    private LocalTerminalUtilities() {
    }

    public static ILaunchConfiguration findLaunchConfiguration(String name) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] configuration = manager.getLaunchConfigurations(PROGRAM_LAUNCH_TYPE);
        int numberOfConfigurations = configuration.length;
        int index = 0;
        while (index < numberOfConfigurations) {
            if (configuration[index].getName().equals(name)) {
                return configuration[index];
            }
            ++index;
        }
        String error = NLS.bind((String)LocalTerminalMessages.noSuchLaunchConfiguration, (Object)name);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.tm.terminal.local", error));
    }

    public static boolean getLocalEcho(ILocalTerminalSettings settings) {
        return LocalTerminalUtilities.getBooleanSetting(settings, "org.eclipse.tm.terminal.local.echo");
    }

    public static boolean getCtrlC(ILocalTerminalSettings settings) {
        return LocalTerminalUtilities.getBooleanSetting(settings, "org.eclipse.tm.terminal.local.sigint");
    }

    public static String getLineSeparator(ILocalTerminalSettings settings) {
        String configurationName = settings.getLaunchConfigurationName();
        try {
            ILaunchConfiguration configuration = LocalTerminalUtilities.findLaunchConfiguration(configurationName);
            String ls = configuration.getAttribute("org.eclipse.tm.terminal.local.lineseparator", NULL);
            return ls;
        }
        catch (CoreException exception) {
            Logger.logException((Exception)((Object)exception));
            return null;
        }
    }

    private static boolean getBooleanSetting(ILocalTerminalSettings settings, String attribute) {
        String configurationName = settings.getLaunchConfigurationName();
        try {
            ILaunchConfiguration configuration = LocalTerminalUtilities.findLaunchConfiguration(configurationName);
            return configuration.getAttribute(attribute, false);
        }
        catch (CoreException exception) {
            Logger.logException((Exception)((Object)exception));
            return false;
        }
    }
}

