/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.tm.internal.terminal.local.launch.ui.LocalTerminalSettingsTab;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalLaunchTabGroup
extends AbstractLaunchConfigurationTabGroup
implements IDebugUIConstants {
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String LC_TAB_GROUPS = "launchConfigurationTabGroups";
    private static final String PROGRAM_TAB_GROUP = "org.eclipse.ui.externaltools.launchConfigurationTabGroup.program";

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab main = this.getMainTab(dialog, mode);
        LocalTerminalSettingsTab terminal = new LocalTerminalSettingsTab();
        EnvironmentTab environment = new EnvironmentTab();
        CommonTab common = new CommonTab();
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{main, terminal, environment, common};
        this.setTabs(tabs);
    }

    private ILaunchConfigurationTab getMainTab(ILaunchConfigurationDialog dialog, String mode) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] element = registry.getConfigurationElementsFor("org.eclipse.debug.ui", LC_TAB_GROUPS);
        int numberOfElements = element.length;
        int index = 0;
        while (index < numberOfElements) {
            if (element[index].getAttribute(ID).equals(PROGRAM_TAB_GROUP)) {
                try {
                    Object executable = element[index].createExecutableExtension(CLASS);
                    ILaunchConfigurationTabGroup tabGroup = (ILaunchConfigurationTabGroup)executable;
                    tabGroup.createTabs(dialog, mode);
                    return tabGroup.getTabs()[0];
                }
                catch (CoreException exception) {
                    Logger.logException((Exception)((Object)exception));
                }
            }
            ++index;
        }
        return null;
    }
}

