/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util.ssl;

import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.eclipse.dstore.core.util.ssl.BaseSSLContext;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;
import org.eclipse.dstore.internal.core.util.ssl.DStoreKeyManager;

public class DStoreSSLContext {
    public static SSLContext getServerSSLContext(String filePath, String password) {
        SSLContext serverContext = null;
        try {
            KeyManager[] keyManagers = BaseSSLContext.getKeyManagers();
            if (keyManagers == null) {
                KeyStore ks = DStoreKeyStore.getKeyStore(filePath, password);
                String keymgrAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keymgrAlgorithm);
                kmf.init(ks, password.toCharArray());
                serverContext = SSLContext.getInstance("SSL");
                keyManagers = kmf.getKeyManagers();
                String defaultAlias = System.getProperty("DSTORE_DEFAULT_CERTIFICATE_ALIAS");
                if (defaultAlias != null) {
                    KeyManager[] x509KeyManagers = new X509KeyManager[10];
                    int i = 0;
                    while (i < keyManagers.length) {
                        if (keyManagers[i] instanceof X509KeyManager) {
                            x509KeyManagers[i] = new DStoreKeyManager((X509KeyManager)keyManagers[i], defaultAlias);
                        }
                        ++i;
                    }
                    serverContext.init(x509KeyManagers, null, null);
                } else {
                    serverContext.init(keyManagers, null, null);
                }
            } else {
                serverContext = SSLContext.getInstance("SSL");
                serverContext.init(keyManagers, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverContext;
    }

    public static SSLContext getClientSSLContext(String filePath, String password, IDataStoreTrustManager trustManager) {
        SSLContext clientContext = null;
        try {
            trustManager.setKeystore(filePath, password);
            clientContext = SSLContext.getInstance("SSL");
            TrustManager[] mgrs = new TrustManager[]{trustManager};
            KeyManager[] keyManagers = BaseSSLContext.getKeyManagers();
            clientContext.init(keyManagers, mgrs, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clientContext;
    }
}

