/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.internal.files.ui.view.DownloadAndOpenJob;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;

public class SystemEditFileAction
extends SystemBaseAction {
    protected IEditorDescriptor _editorDescriptor;

    public SystemEditFileAction(String text, String tooltip, ImageDescriptor image, Shell parent, IEditorDescriptor editorDescriptor) {
        super(text, tooltip, null, image, parent);
        this.init();
        this._editorDescriptor = editorDescriptor;
    }

    public SystemEditFileAction(String text, String tooltip, ImageDescriptor image, int style, Shell parent, IEditorDescriptor editorDescriptor) {
        super(text, tooltip, null, image, style, parent);
        this.init();
        this._editorDescriptor = editorDescriptor;
    }

    private void init() {
        this.allowOnMultipleSelection(false);
    }

    public void run() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object element = this.getFirstSelection();
        if (element == null) {
            return;
        }
        if (!(element instanceof IRemoteFile)) {
            return;
        }
        this.process((IRemoteFile)element);
    }

    private boolean isFileCached(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (!newFile && file.exists()) {
            boolean isReadOnly;
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            try {
                remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean remoteNewer = storedModifiedStamp != remoteModifiedStamp;
            String remoteEncoding = remoteFile.getEncoding();
            String storedEncoding = properties.getEncoding();
            boolean encodingChanged = storedEncoding == null || !remoteEncoding.equals(storedEncoding);
            boolean usedBinary = properties.getUsedBinaryTransfer();
            boolean isBinary = remoteFile.isBinary();
            boolean usedReadOnly = properties.getReadOnly();
            boolean bl2 = isReadOnly = !remoteFile.canWrite();
            return !dirty && !remoteNewer && usedBinary == isBinary && usedReadOnly == isReadOnly && !encodingChanged;
        }
        return false;
    }

    protected void process(IRemoteFile remoteFile) {
        SystemEditableRemoteFile editable = SystemRemoteEditManager.getEditableRemoteObject(remoteFile, null);
        if (editable == null) {
            return;
        }
        try {
            if (editable.checkOpenInEditor() != 0) {
                if (this.isFileCached(editable, remoteFile)) {
                    editable.openEditor();
                } else {
                    DownloadAndOpenJob oJob = new DownloadAndOpenJob(editable, false);
                    oJob.schedule();
                }
            } else {
                editable.setLocalResourceProperties();
                editable.openEditor();
            }
        }
        catch (Exception exception) {}
    }
}

