/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalLaunchLabelProvider;
import org.eclipse.tm.internal.terminal.local.LocalTerminalLaunchListProvider;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.ui.DependentHeightComposite;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalSettingsPage
implements ISettingsPage,
ISelectionChangedListener,
SelectionListener {
    private ILocalTerminalSettings settings;
    private TableViewer viewer;
    private Button buttonEdit;
    private Button buttonNew;

    public LocalTerminalSettingsPage(ILocalTerminalSettings settings) {
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Composite enclosing = parent.getParent();
        Layout enclosingLayout = enclosing.getLayout();
        int extra = 0;
        if (enclosingLayout instanceof GridLayout) {
            extra = -2 * ((GridLayout)enclosingLayout).marginHeight - 2;
        }
        DependentHeightComposite composite = new DependentHeightComposite(parent, 0, enclosing, extra);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)composite, 0);
        label.setText(LocalTerminalMessages.launchConfiguration);
        label.setLayoutData((Object)new GridData());
        Composite tableAndButtons = new Composite((Composite)composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        tableAndButtons.setLayout((Layout)layout);
        Table table = new Table(tableAndButtons, 2048);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LocalTerminalLaunchLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new LocalTerminalLaunchListProvider());
        this.viewer.setInput(new Object());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 0, 2));
        this.buttonNew = this.pushButton(tableAndButtons, LocalTerminalMessages.labelNew, false);
        this.buttonEdit = this.pushButton(tableAndButtons, LocalTerminalMessages.labelEdit, true);
        this.buttonEdit.setEnabled(this.settings.getLaunchConfigurationName() != null);
        this.loadSettings();
    }

    public void loadSettings() {
        ILaunchConfiguration configuration;
        String configurationName = this.settings.getLaunchConfigurationName();
        try {
            configuration = LocalTerminalUtilities.findLaunchConfiguration(configurationName);
        }
        catch (CoreException coreException) {
            configuration = null;
        }
        if (this.settings.getLaunchConfigurationName() != null && configuration != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
        }
    }

    public void saveSettings() {
        IStructuredSelection selection;
        Object element;
        if (this.viewer != null && !this.viewer.getSelection().isEmpty() && (element = (selection = (IStructuredSelection)this.viewer.getSelection()).getFirstElement()) instanceof ILaunchConfiguration) {
            String launchConfiguration = ((ILaunchConfiguration)element).getName();
            this.settings.setLaunchConfigurationName(launchConfiguration);
        }
    }

    public boolean validateSettings() {
        return this.viewer != null && !this.viewer.getSelection().isEmpty();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.buttonEdit.setEnabled(!event.getSelection().isEmpty());
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        ILaunchConfiguration configuration = null;
        Widget widget = event.widget;
        if (widget == null) {
            return;
        }
        if (widget.equals(this.buttonNew)) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            String baseName = LocalTerminalMessages.newTerminalLaunchName;
            String uniqueName = launchManager.generateUniqueLaunchConfigurationNameFrom(baseName);
            ILaunchConfigurationType type = LocalTerminalUtilities.PROGRAM_LAUNCH_TYPE;
            try {
                ILaunchConfigurationWorkingCopy newlyCreatedConfiguration = type.newInstance(null, uniqueName);
                configuration = newlyCreatedConfiguration.doSave();
            }
            catch (CoreException couldNotCreateNewLaunchConfiguration) {
                Logger.logException((Exception)((Object)couldNotCreateNewLaunchConfiguration));
            }
        }
        if (widget.equals(this.buttonEdit) || configuration != null) {
            Shell shell = DebugUIPlugin.getShell();
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (configuration == null) {
                configuration = (ILaunchConfiguration)selection.getFirstElement();
            }
            ILaunchGroup group = DebugUITools.getLaunchGroup(configuration, (String)"run");
            String groupID = group.getIdentifier();
            DebugUITools.openLaunchConfigurationDialog((Shell)shell, (ILaunchConfiguration)configuration, (String)groupID, null);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
        }
    }

    private Button pushButton(Composite parent, String label, boolean grabVertical) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData layoutData = new GridData(258);
        layoutData.grabExcessVerticalSpace = grabVertical;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }
}

