/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.launch;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.launch.LocalTerminalLaunchUtilities;
import org.eclipse.tm.internal.terminal.local.launch.LocalTerminalStillRunningListener;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class LocalTerminalLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String EMPTY = "";
    private static final String PLUGIN_ID = "org.eclipse.tm.terminal.local";
    public static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.tm.terminal.local.launch";
    private static LocalTerminalStillRunningListener workbenchCloseListener;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor progressMonitor) throws CoreException {
        Process spawner;
        if (progressMonitor.isCanceled()) {
            return;
        }
        IPath location = LocalTerminalLaunchUtilities.getLocation(configuration);
        if (progressMonitor.isCanceled()) {
            return;
        }
        IPath workingDirectory = LocalTerminalLaunchUtilities.getWorkingDirectory(configuration);
        if (progressMonitor.isCanceled()) {
            return;
        }
        String[] arguments = LocalTerminalLaunchUtilities.getArguments(configuration);
        if (progressMonitor.isCanceled()) {
            return;
        }
        String[] commandLine = new String[arguments != null ? arguments.length + 1 : 1];
        commandLine[0] = location.toOSString();
        if (arguments != null) {
            System.arraycopy(arguments, 0, commandLine, 1, arguments.length);
        }
        File workingDirectoryAsFile = null;
        if (workingDirectory != null) {
            workingDirectoryAsFile = workingDirectory.toFile();
        }
        if (progressMonitor.isCanceled()) {
            return;
        }
        String[] environment = LocalTerminalUtilities.LAUNCH_MANAGER.getEnvironment(configuration);
        if (progressMonitor.isCanceled()) {
            return;
        }
        if (workbenchCloseListener == null) {
            workbenchCloseListener = new LocalTerminalStillRunningListener();
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)workbenchCloseListener);
        }
        try {
            ProcessFactory factory = ProcessFactory.getFactory();
            spawner = PTY.isSupported() ? factory.exec(commandLine, environment, workingDirectoryAsFile, new PTY(false)) : factory.exec(commandLine, environment, workingDirectoryAsFile);
        }
        catch (IOException exception) {
            String message = exception.getMessage();
            Status error = new Status(4, PLUGIN_ID, message, (Throwable)exception);
            throw new CoreException((IStatus)error);
        }
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = location.lastSegment();
        String extension = location.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - extension.length() - 1);
        }
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName.toLowerCase());
        IProcess process = null;
        if (spawner != null) {
            Object[] configurationName = new String[]{configuration.getName()};
            String task = NLS.bind((String)LocalTerminalMessages.launchingConfiguration, (Object[])configurationName);
            progressMonitor.beginTask(task, -1);
            process = DebugPlugin.newProcess((ILaunch)launch, (Process)spawner, (String)commandLine[0], processAttributes);
        }
        if (spawner == null || process == null) {
            if (spawner != null) {
                spawner.destroy();
            }
            String pluginID = PLUGIN_ID;
            String errorMessage = LocalTerminalMessages.couldNotCreateIProcess;
            Status error = new Status(4, pluginID, 4, errorMessage, null);
            throw new CoreException((IStatus)error);
        }
        process.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(commandLine));
        if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            while (!process.isTerminated()) {
                try {
                    if (progressMonitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interrupt) {
                    Logger.logException((Exception)interrupt);
                }
            }
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return EMPTY;
        }
        StringBuffer buffer = new StringBuffer();
        int element = 0;
        while (element < commandLine.length) {
            if (element > 0) {
                buffer.append(' ');
            }
            StringBuffer argument = new StringBuffer();
            char[] characters = commandLine[element].toCharArray();
            boolean argumentContainsSpace = false;
            int index = 0;
            while (index < characters.length) {
                char character = characters[index];
                if (character == '\"') {
                    argument.append('\\');
                } else if (character == ' ') {
                    argumentContainsSpace = true;
                }
                argument.append(character);
                ++index;
            }
            if (argumentContainsSpace) {
                buffer.append('\"').append(argument).append('\"');
            } else {
                buffer.append(argument);
            }
            ++element;
        }
        return buffer.toString();
    }
}

