/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.launch;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalLaunchUtilities {
    public static final String ATTR_LOCAL_ECHO = "org.eclipse.tm.terminal.local.echo";
    public static final String ATTR_CTRL_C = "org.eclipse.tm.terminal.local.sigint";
    public static final String ATTR_LINE_SEPARATOR = "org.eclipse.tm.terminal.local.lineseparator";
    private static final String[] EMPTY = new String[0];
    private static final String STRING = null;
    private static final String XT = "org.eclipse.ui.externaltools";
    private static final String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
    private static final String ATTR_TOOL_ARGUMENTS = "org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS";
    private static final String ATTR_WORKING_DIRECTORY = "org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY";

    private LocalTerminalLaunchUtilities() {
    }

    public static Image getImage(ILaunchConfiguration configuration) {
        String identifier;
        try {
            identifier = configuration.getType().getIdentifier();
        }
        catch (CoreException couldNotDetermineConfigurationType) {
            identifier = null;
            Logger.logException((Exception)((Object)couldNotDetermineConfigurationType));
        }
        if (identifier != null) {
            return DebugUITools.getImage((String)identifier);
        }
        return null;
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        File file;
        String expandedLocation;
        Object[] configurationName = new Object[]{configuration.getName()};
        String location = configuration.getAttribute(ATTR_LOCATION, STRING);
        if (location == null) {
            LocalTerminalLaunchUtilities.abort(NLS.bind((String)LocalTerminalMessages.locationNotSpecified, (Object[])configurationName), null, 0);
        }
        if ((expandedLocation = LocalTerminalLaunchUtilities.getStringVariableManager().performStringSubstitution(location)) == null || expandedLocation.length() == 0) {
            LocalTerminalLaunchUtilities.abort(NLS.bind((String)LocalTerminalMessages.invalidLocation, (Object[])configurationName), null, 0);
        }
        if (!(file = new File(expandedLocation)).isFile()) {
            LocalTerminalLaunchUtilities.abort(NLS.bind((String)LocalTerminalMessages.invalidLocation, (Object[])configurationName), null, 0);
        }
        return new Path(expandedLocation);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute(ATTR_WORKING_DIRECTORY, STRING);
        if (location != null) {
            File path;
            String expandedLocation = LocalTerminalLaunchUtilities.getStringVariableManager().performStringSubstitution(location);
            if (expandedLocation.length() > 0 && !(path = new File(expandedLocation)).isDirectory()) {
                Object[] detail = new Object[]{expandedLocation, configuration.getName()};
                LocalTerminalLaunchUtilities.abort(NLS.bind((String)LocalTerminalMessages.invalidWorkingDirectory, (Object[])detail), null, 0);
            }
            return new Path(expandedLocation);
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute(ATTR_TOOL_ARGUMENTS, STRING);
        if (arguments != null) {
            String expanded = LocalTerminalLaunchUtilities.getStringVariableManager().performStringSubstitution(arguments);
            return LocalTerminalLaunchUtilities.parseStringIntoList(expanded);
        }
        return null;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    private static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return EMPTY;
        }
        return DebugPlugin.parseArguments((String)arguments);
    }

    private static void abort(String text, Throwable exception, int code) throws CoreException {
        Status status = new Status(4, "org.eclipse.tm.terminal.local", code, text, exception);
        throw new CoreException((IStatus)status);
    }
}

