/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalSettingsTab
extends AbstractLaunchConfigurationTab
implements SelectionListener {
    private static final String NULL = null;
    private Button buttonEcho;
    private Button buttonCtrlC;
    private Button separatorDefault;
    private Button separatorLF;
    private Button separatorCRLF;
    private Button separatorCR;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group composite = new Group(container, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setText(LocalTerminalMessages.terminalSettings);
        composite.setLayout((Layout)new GridLayout());
        this.buttonEcho = this.button((Composite)composite, LocalTerminalMessages.enableLocalEcho, 32);
        this.buttonEcho.setLayoutData((Object)new GridData());
        this.buttonCtrlC = this.button((Composite)composite, LocalTerminalMessages.sendInterruptOnCtrlC, 32);
        this.buttonCtrlC.setLayoutData((Object)new GridData());
        Composite separator = new Composite((Composite)composite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        separator.setLayout((Layout)rowLayout);
        this.separatorDefault = this.button(separator, LocalTerminalMessages.lineSeparatorDefault, 16);
        this.separatorLF = this.button(separator, LocalTerminalMessages.lineSeparatorLF, 16);
        this.separatorCRLF = this.button(separator, LocalTerminalMessages.lineSeparatorCRLF, 16);
        this.separatorCR = this.button(separator, LocalTerminalMessages.lineSeparatorCR, 16);
        separator.setLayoutData((Object)new GridData());
    }

    public String getName() {
        return LocalTerminalMessages.terminalTabName;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"org.eclipse.tm.terminal.local.launch");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String ls;
        boolean ctrlC;
        boolean echo;
        try {
            echo = configuration.getAttribute("org.eclipse.tm.terminal.local.echo", false);
        }
        catch (CoreException exception) {
            Logger.logException((Exception)((Object)exception));
            echo = false;
        }
        try {
            ctrlC = configuration.getAttribute("org.eclipse.tm.terminal.local.sigint", false);
        }
        catch (CoreException exception) {
            Logger.logException((Exception)((Object)exception));
            ctrlC = false;
        }
        try {
            ls = configuration.getAttribute("org.eclipse.tm.terminal.local.lineseparator", NULL);
        }
        catch (CoreException exception) {
            Logger.logException((Exception)((Object)exception));
            ls = null;
        }
        this.buttonEcho.setSelection(echo);
        this.buttonCtrlC.setSelection(ctrlC);
        if ("\\n".equals(ls)) {
            this.separatorLF.setSelection(true);
        } else if ("\\n".equals(ls)) {
            this.separatorLF.setSelection(true);
        } else if ("\\r\\n".equals(ls)) {
            this.separatorCRLF.setSelection(true);
        } else if ("\\r".equals(ls)) {
            this.separatorCR.setSelection(true);
        } else {
            this.separatorDefault.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean echo = this.buttonEcho.getSelection();
        configuration.setAttribute("org.eclipse.tm.terminal.local.echo", echo);
        boolean ctrlC = this.buttonCtrlC.getSelection();
        configuration.setAttribute("org.eclipse.tm.terminal.local.sigint", ctrlC);
        String lineSeparator = null;
        if (this.separatorCRLF.getSelection()) {
            lineSeparator = "\\r\\n";
        } else if (this.separatorCR.getSelection()) {
            lineSeparator = "\\r";
        } else if (this.separatorLF.getSelection()) {
            lineSeparator = "\\n";
        }
        configuration.setAttribute("org.eclipse.tm.terminal.local.lineseparator", lineSeparator);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.tm.terminal.local.echo", false);
        configuration.setAttribute("org.eclipse.tm.terminal.local.sigint", false);
        configuration.setAttribute("org.eclipse.tm.terminal.local.lineseparator", NULL);
    }

    public void widgetSelected(SelectionEvent event) {
        this.setDirty(true);
        this.getLaunchConfigurationDialog().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    private Button button(Composite parent, String label, int buttonType) {
        Button button = new Button(parent, buttonType);
        button.addSelectionListener((SelectionListener)this);
        button.setText(label);
        return button;
    }
}

