/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.process;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.tm.internal.terminal.local.process.LocalTerminalProcessRegistry;

public final class LocalTerminalProcess
extends RuntimeProcess {
    public static final String PROCESS_TYPE = "org.eclipse.tm.terminal.localProcess";
    private boolean resetStreamsProxy;

    protected LocalTerminalProcess(ILaunch launch, Process process, String name, Map attributes) {
        super(launch, process, name, LocalTerminalProcess.setProcessType(attributes));
        LocalTerminalProcessRegistry.registerWithLaunch(launch, this);
        launch.removeProcess((IProcess)this);
    }

    public boolean interrupt() {
        Process process = this.getSystemProcess();
        if (process instanceof Spawner) {
            return ((Spawner)process).interrupt() == 0;
        }
        return false;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this.resetStreamsProxy) {
            return null;
        }
        return super.getStreamsProxy();
    }

    protected void resetStreamsProxy() {
        this.resetStreamsProxy = true;
    }

    protected void terminated() {
        LocalTerminalProcessRegistry.addProcessBackToFinishedLaunch(this.getLaunch());
        super.terminated();
    }

    private static Map setProcessType(Map attributes) {
        if (attributes == null) {
            attributes = new HashMap<String, String>(1);
        }
        attributes.put(IProcess.ATTR_PROCESS_TYPE, PROCESS_TYPE);
        return attributes;
    }
}

