/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence.dom;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterStartHere;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.core.filters.HostOwnedFilterPoolPattern;
import org.eclipse.rse.internal.core.model.SystemProfile;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class RSEDOMImporter {
    private static RSEDOMImporter _instance = new RSEDOMImporter();
    private ISystemRegistry _registry;

    public static RSEDOMImporter getInstance() {
        return _instance;
    }

    public void setSystemRegistry(ISystemRegistry registry) {
        this._registry = registry;
    }

    public ISystemProfile restoreProfile(RSEDOM dom) {
        SystemProfile profile = null;
        String profileName = dom.getName();
        if (profileName != null) {
            boolean defaultPrivate = this.getBooleanValue(dom, "defaultPrivate");
            boolean isActive = this.getBooleanValue(dom, "isActive");
            profile = new SystemProfile(profileName, isActive);
            profile.setDefaultPrivate(defaultPrivate);
            SystemProfileManager.getDefault().addSystemProfile(profile);
            RSEDOMNode[] children = dom.getChildren();
            int i = 0;
            while (i < children.length) {
                try {
                    RSEDOMNode child = children[i];
                    String type = child.getType();
                    if ("Host".equals(type)) {
                        this.restoreHost(profile, child);
                    } else if ("FilterPool".equals(type)) {
                        this.restoreFilterPool(profile, child);
                    } else if ("PropertySet".equals(type)) {
                        this.restorePropertySet(profile, child);
                    } else {
                        this.logNullAttribute(child, "type");
                    }
                }
                catch (Exception e) {
                    this.logException(e);
                }
                ++i;
            }
        } else {
            this.logNullAttribute(dom, "name");
        }
        return profile;
    }

    public IHost restoreHost(ISystemProfile profile, RSEDOMNode hostNode) {
        IHost host = null;
        String hostName = hostNode.getName();
        String systemTypeName = this.getAttributeValueMaybeNull(hostNode, "type");
        String systemTypeId = this.getAttributeValueMaybeNull(hostNode, "systemType");
        String hostAddress = this.getAttributeValue(hostNode, "hostname");
        String description = this.getAttributeValue(hostNode, "description");
        boolean isOffline = this.getBooleanValue(hostNode, "offline");
        boolean isPromptable = this.getBooleanValue(hostNode, "promptable");
        try {
            IRSECoreRegistry coreRegistry = RSECorePlugin.getTheCoreRegistry();
            IRSESystemType systemType = null;
            if (systemTypeId != null) {
                systemType = coreRegistry.getSystemTypeById(systemTypeId);
            } else if (systemTypeName != null) {
                systemType = coreRegistry.getSystemType(systemTypeName);
            }
            if (systemType != null) {
                ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                String profileName = profile.getName();
                host = registry.createHost(profileName, systemType, hostName, hostAddress, description, false);
                host.setOffline(isOffline);
                host.setPromptable(isPromptable);
            } else {
                StringBuffer msg = new StringBuffer(80);
                msg.append("unknown systemType \"");
                msg.append(systemTypeName);
                msg.append("\" (");
                msg.append(systemTypeId);
                msg.append(") in ");
                msg.append(profile.getName());
                msg.append(':');
                msg.append(hostName);
                this.logWarning(msg.toString());
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        if (host != null) {
            RSEDOMNode[] children = hostNode.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                String type = child.getType();
                if ("ConnectorService".equals(type)) {
                    this.restoreConnectorService(host, child);
                } else if ("PropertySet".equals(type)) {
                    this.restorePropertySet(host, child);
                } else {
                    this.logNullAttribute(child, "type");
                }
                ++i;
            }
        }
        return host;
    }

    public IConnectorService restoreConnectorService(IHost host, RSEDOMNode connectorServiceNode) {
        IConnectorService service = null;
        boolean useSSL = this.getBooleanValue(connectorServiceNode, "useSSL");
        int port = this.getIntegerValue(connectorServiceNode, "port");
        RSEDOMNode[] ssChildren = connectorServiceNode.getChildren("SubSystem");
        int s = 0;
        while (s < ssChildren.length) {
            ISubSystemConfiguration subsystemConfiguration;
            RSEDOMNode ssChild = ssChildren[s];
            ISubSystem subSystem = this.restoreSubSystem(host, ssChild);
            if (subSystem != null && service == null && (service = (subsystemConfiguration = subSystem.getSubSystemConfiguration()).getConnectorService(host)) != null) {
                IServerLauncherProperties sl;
                if (subsystemConfiguration.supportsServerLaunchProperties(host) && (sl = subsystemConfiguration.createServerLauncher(service)) != null) {
                    RSEDOMNode serverLauncherPropertiesNode = null;
                    RSEDOMNode[] slChildren = connectorServiceNode.getChildren("ServerLauncher");
                    if (slChildren != null && slChildren.length > 0) {
                        serverLauncherPropertiesNode = slChildren[0];
                        this.restoreServerLauncher(service, serverLauncherPropertiesNode, sl);
                    }
                }
                service.setPort(port);
                service.setIsUsingSSL(useSSL);
            }
            if (service != null && subSystem != null) {
                subSystem.setConnectorService(service);
            }
            ++s;
        }
        RSEDOMNode[] psChildren = connectorServiceNode.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(service, psChild);
            ++p;
        }
        return service;
    }

    public IServerLauncherProperties restoreServerLauncher(IConnectorService service, RSEDOMNode serverLauncherNode, IServerLauncherProperties sl) {
        RSEDOMNode[] psChildren = serverLauncherNode.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(sl, psChild);
            ++p;
        }
        sl.restoreFromProperties();
        service.setRemoteServerLauncherProperties(sl);
        return sl;
    }

    public ISubSystem restoreSubSystem(IHost host, RSEDOMNode subSystemNode) {
        String name = subSystemNode.getName();
        String type = this.getAttributeValue(subSystemNode, "type");
        boolean isHidden = this.getBooleanValue(subSystemNode, "hidden");
        ISubSystem subSystem = null;
        ISubSystemConfiguration factory = this.getSubSystemConfiguration(type);
        if (factory != null) {
            Class serviceType = factory.getServiceType();
            if (serviceType != null) {
                ISubSystem[] existingSubSystems = this._registry.getServiceSubSystems(host, serviceType);
                if (existingSubSystems != null && existingSubSystems.length > 0) {
                    subSystem = existingSubSystems[0];
                    subSystem.switchServiceFactory(factory);
                }
            } else {
                ISubSystem[] existingSubSystems;
                ISubSystemConfiguration config = this._registry.getSubSystemConfiguration(type);
                if (config != null && (existingSubSystems = config.getSubSystems(host, true)) != null && existingSubSystems.length > 0) {
                    subSystem = existingSubSystems[0];
                }
            }
            if (subSystem == null) {
                ISubSystem[] createdSystems = this._registry.createSubSystems(host, new ISubSystemConfiguration[]{factory});
                subSystem = createdSystems[0];
            }
            subSystem.setHidden(isHidden);
            subSystem.setHost(host);
            subSystem.setSubSystemConfiguration(factory);
            subSystem.setName(factory.getName());
            subSystem.setConfigurationId(factory.getId());
            if (factory.supportsFilters()) {
                ISystemFilterStartHere startHere = this._registry.getSystemFilterStartHere();
                ISystemFilterPoolReferenceManager fprMgr = startHere.createSystemFilterPoolReferenceManager(subSystem, factory, name);
                subSystem.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = factory.getFilterPoolManager(host.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            RSEDOMNode[] filterPoolReferenceChildren = subSystemNode.getChildren("FilterPoolReference");
            int i = 0;
            while (i < filterPoolReferenceChildren.length) {
                RSEDOMNode fprChild = filterPoolReferenceChildren[i];
                this.restoreFilterPoolReference(subSystem, fprChild);
                ++i;
            }
            RSEDOMNode[] psChildren = subSystemNode.getChildren("PropertySet");
            int p = 0;
            while (p < psChildren.length) {
                RSEDOMNode psChild = psChildren[p];
                this.restorePropertySet(subSystem, psChild);
                ++p;
            }
            subSystem.wasRestored();
        }
        return subSystem;
    }

    public ISystemFilter restoreFilter(ISystemFilterPool filterPool, RSEDOMNode node) {
        String name = node.getName();
        boolean supportsNestedFilters = this.getBooleanValue(node, "supportsNestedFilters");
        int relativeOrder = this.getIntegerValue(node, "relativeOrder");
        boolean isDefault = this.getBooleanValue(node, "default");
        boolean isSetStringsCaseSensitive = this.getBooleanValue(node, "stringsCaseSensitive");
        boolean isPromptable = this.getBooleanValue(node, "promptable");
        boolean isSetSupportsDuplicateFilterStrings = this.getBooleanValue(node, "supportsDuplicateFilterStrings");
        boolean isNonDeletable = this.getBooleanValue(node, "nonDeletable");
        boolean isNonRenamable = this.getBooleanValue(node, "nonRenamable");
        boolean isNonChangable = this.getBooleanValue(node, "nonChangable");
        boolean isStringsNonChangable = this.getBooleanValue(node, "stringsNonChangable");
        int release = this.getIntegerValue(node, "release");
        boolean isSetSingleFilterStringOnly = this.getBooleanValue(node, "singleFilterStringOnly");
        String filterType = this.getAttributeValueMaybeNull(node, "filterType");
        RSEDOMNode[] filterStringNodes = node.getChildren("FilterString");
        String[] filterStrings = new String[filterStringNodes.length];
        int i = 0;
        while (i < filterStringNodes.length) {
            RSEDOMNode filterStringNode = filterStringNodes[i];
            filterStrings[i] = filterStringNode.getName();
            ++i;
        }
        ISystemFilter filter = filterPool.createSystemFilter(name, filterStrings);
        filter.setSupportsNestedFilters(supportsNestedFilters);
        filter.setRelativeOrder(relativeOrder);
        filter.setDefault(isDefault);
        filter.setStringsCaseSensitive(isSetStringsCaseSensitive);
        filter.setPromptable(isPromptable);
        filter.setSupportsDuplicateFilterStrings(isSetSupportsDuplicateFilterStrings);
        filter.setNonDeletable(isNonDeletable);
        filter.setNonChangable(isNonChangable);
        filter.setNonRenamable(isNonRenamable);
        filter.setStringsNonChangable(isStringsNonChangable);
        filter.setRelease(release);
        filter.setSingleFilterStringOnly(isSetSingleFilterStringOnly);
        filter.setType(filterType);
        RSEDOMNode[] psChildren = node.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(filter, psChild);
            ++p;
        }
        return filter;
    }

    public ISystemFilterPool restoreFilterPool(ISystemProfile profile, RSEDOMNode node) {
        ISystemFilterPool filterPool = null;
        String name = node.getName();
        String type = this.getAttributeValue(node, "type");
        String id = this.getAttributeValue(node, "id");
        boolean supportsNestedFilters = this.getBooleanValue(node, "supportsNestedFilters");
        boolean isDeletable = this.getBooleanValue(node, "deletable");
        boolean isDefault = this.getBooleanValue(node, "default");
        boolean isSetStringsCaseSensitive = this.getBooleanValue(node, "stringsCaseSensitive");
        boolean isSetSupportsDuplicateFilterStrings = this.getBooleanValue(node, "supportsDuplicateFilterStrings");
        int release = this.getIntegerValue(node, "release");
        boolean isSingleFilterStringOnlyESet = false;
        boolean isSetSingleFilterStringOnly = false;
        RSEDOMNodeAttribute attribute = node.getAttribute("singleFilterStringOnlyESet");
        if (attribute != null) {
            isSingleFilterStringOnlyESet = this.getBooleanValue(attribute.getValue());
            isSetSingleFilterStringOnly = this.getBooleanValue(node, "singleFilterStringOnly");
        }
        String owningParentName = this.getAttributeValue(node, "owningParentName");
        boolean isNonRenamable = this.getBooleanValue(node, "nonRenamable");
        try {
            ISubSystemConfiguration factory = this.getSubSystemConfiguration(id);
            if (factory != null) {
                ISystemFilterPoolManager mgr = factory.getFilterPoolManager(profile);
                filterPool = isDefault ? mgr.getFirstDefaultSystemFilterPool() : mgr.getSystemFilterPool(name);
                if (filterPool == null) {
                    filterPool = mgr.createSystemFilterPool(name, isDeletable);
                }
                filterPool.setType(type);
                filterPool.setDefault(isDefault);
                filterPool.setSupportsNestedFilters(supportsNestedFilters);
                filterPool.setStringsCaseSensitive(isSetStringsCaseSensitive);
                filterPool.setSupportsDuplicateFilterStrings(isSetSupportsDuplicateFilterStrings);
                filterPool.setRelease(release);
                if (isSingleFilterStringOnlyESet) {
                    filterPool.setSingleFilterStringOnly(isSetSingleFilterStringOnly);
                }
                filterPool.setOwningParentName(owningParentName);
                filterPool.setNonRenamable(isNonRenamable);
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        if (filterPool != null) {
            RSEDOMNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                String ctype = child.getType();
                if ("Filter".equals(ctype)) {
                    this.restoreFilter(filterPool, child);
                } else if ("PropertySet".equals(ctype)) {
                    this.restorePropertySet(filterPool, child);
                } else {
                    this.logNullAttribute(child, "type");
                }
                ++i;
            }
        }
        return filterPool;
    }

    public ISystemFilterPoolReference restoreFilterPoolReference(ISubSystem subsystem, RSEDOMNode node) {
        String configurationId;
        HostOwnedFilterPoolPattern pattern;
        ISystemFilterPoolReference filterPoolReference = null;
        String filterPoolName = node.getName();
        ISystemProfile profile = subsystem.getSystemProfile();
        String profileName = profile.getName();
        String baseFilterPoolName = filterPoolName;
        String[] part = filterPoolName.split("___", 2);
        if (part.length == 2) {
            profileName = part[0];
            baseFilterPoolName = part[1];
        }
        if ((pattern = new HostOwnedFilterPoolPattern(configurationId = subsystem.getConfigurationId())).matches(baseFilterPoolName)) {
            String hostName = subsystem.getHostAliasName();
            baseFilterPoolName = pattern.make(hostName);
        }
        filterPoolName = String.valueOf(profileName) + "___" + baseFilterPoolName;
        ISystemFilterPoolReferenceManager referenceManager = subsystem.getFilterPoolReferenceManager();
        filterPoolReference = referenceManager.addReferenceToSystemFilterPool(filterPoolName);
        return filterPoolReference;
    }

    public ISystemFilterString restoreFilterString(ISystemFilter filter, RSEDOMNode node) {
        return null;
    }

    public IPropertySet restorePropertySet(IRSEModelObject modelObject, RSEDOMNode propertySetNode) {
        Object type;
        String name = propertySetNode.getName();
        IPropertySet set = modelObject.createPropertySet(name);
        RSEDOMNodeAttribute[] attributes = propertySetNode.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            RSEDOMNodeAttribute attribute = attributes[i];
            if ("description".equals(attribute.getKey())) {
                set.setDescription(attribute.getValue());
            } else {
                String typeStr = attribute.getType();
                type = PropertyType.fromString(typeStr);
                set.addProperty(attribute.getKey(), attribute.getValue(), (IPropertyType)type);
            }
            ++i;
        }
        RSEDOMNode[] children = propertySetNode.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            RSEDOMNode child = children[i2];
            type = child.getType();
            if (set instanceof IRSEModelObject && ((String)type).equals("PropertySet")) {
                this.restorePropertySet((IRSEModelObject)((Object)set), child);
            } else {
                String propertyName = child.getName();
                String propertyValue = this.getAttributeValue(child, "value");
                String propertyTypeName = this.getAttributeValue(child, "type");
                IPropertyType propertyType = PropertyType.fromString(propertyTypeName);
                if ("description".equals(propertyName)) {
                    set.setDescription(propertyValue);
                } else {
                    set.addProperty(propertyName, propertyValue, propertyType);
                }
            }
            ++i2;
        }
        return set;
    }

    private boolean getBooleanValue(String booleanStr) {
        return booleanStr != null && booleanStr.equalsIgnoreCase("true");
    }

    private int getIntegerValue(String integerString) {
        int result = 0;
        if (integerString != null) {
            try {
                result = Integer.parseInt(integerString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private ISubSystemConfiguration getSubSystemConfiguration(String subsystemName) {
        return this._registry.getSubSystemConfiguration(subsystemName);
    }

    private String getAttributeValue(RSEDOMNode node, String attributeName) {
        String result = null;
        RSEDOMNodeAttribute attribute = node.getAttribute(attributeName);
        if (attribute == null) {
            this.logNullAttribute(node, attributeName);
        } else {
            result = attribute.getValue();
        }
        return result;
    }

    private String getAttributeValueMaybeNull(RSEDOMNode node, String attributeName) {
        String result = null;
        RSEDOMNodeAttribute attribute = node.getAttribute(attributeName);
        if (attribute != null) {
            result = attribute.getValue();
        }
        return result;
    }

    private boolean getBooleanValue(RSEDOMNode node, String attributeName) {
        String booleanStr = this.getAttributeValue(node, attributeName);
        if (booleanStr == null) {
            this.logNullAttribute(node, attributeName);
        }
        return this.getBooleanValue(booleanStr);
    }

    private int getIntegerValue(RSEDOMNode node, String attributeName) {
        String intStr = this.getAttributeValue(node, attributeName);
        if (intStr == null) {
            this.logNullAttribute(node, attributeName);
        }
        return this.getIntegerValue(intStr);
    }

    private void logException(Exception e) {
        RSECorePlugin.getDefault().getLog().log((IStatus)new Status(4, RSECorePlugin.getDefault().getBundle().getSymbolicName(), 1, e.getMessage(), (Throwable)e));
    }

    private void logWarning(String msg) {
        RSECorePlugin.getDefault().getLog().log((IStatus)new Status(2, RSECorePlugin.getDefault().getBundle().getSymbolicName(), 0, "RSEDOMImporter: " + msg, null));
    }

    private void logNullAttribute(RSEDOMNode node, String attributeName) {
        StringBuffer msg = new StringBuffer(80);
        msg.append("RSEDOMImporter: null attr \"");
        msg.append(attributeName == null ? "null" : attributeName);
        msg.append("\" in ");
        int len = msg.length();
        RSEDOMNode parent = node.getParent();
        while (parent != null) {
            String parentName = parent.getName();
            msg.insert(len, parentName == null ? "null/" : String.valueOf(parentName) + '/');
            parent = parent.getParent();
        }
        msg.append(node.getName() == null ? "null" : node.getName());
        RSECorePlugin.getDefault().getLog().log((IStatus)new Status(2, RSECorePlugin.getDefault().getBundle().getSymbolicName(), 0, msg.toString(), null));
    }
}

