/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapperInformation;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.core.filters.SystemFilterPoolWrapperInformation;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemClearPasswordAction;
import org.eclipse.rse.internal.ui.actions.SystemConnectAction;
import org.eclipse.rse.internal.ui.actions.SystemDisconnectAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterCascadingNewFilterPoolReferenceAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterCopyFilterAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterCopyFilterPoolAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveDownFilterAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveDownFilterPoolReferenceAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveFilterAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveFilterPoolAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveUpFilterAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterMoveUpFilterPoolReferenceAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterNewFilterPoolAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterRemoveFilterPoolReferenceAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterSelectFilterPoolsAction;
import org.eclipse.rse.internal.ui.actions.SystemFilterWorkWithFilterPoolsAction;
import org.eclipse.rse.internal.ui.subsystems.SubSystemConfigurationProxyAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.filters.actions.ISystemNewFilterActionConfigurator;
import org.eclipse.rse.ui.filters.actions.SystemChangeFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.rse.ui.filters.actions.SystemNewFilterAction;
import org.eclipse.rse.ui.filters.dialogs.SystemChangeFilterDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.ISystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.propertypages.SystemChangeFilterPropertyPage;
import org.eclipse.rse.ui.propertypages.SystemFilterStringPropertyPage;
import org.eclipse.rse.ui.propertypages.SystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorPortInput;
import org.eclipse.rse.ui.validators.ValidatorSpecialChar;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.widgets.IServerLauncherForm;
import org.eclipse.rse.ui.widgets.RemoteServerLauncherForm;
import org.eclipse.rse.ui.wizards.SubSystemServiceWizardPage;
import org.eclipse.rse.ui.wizards.newconnection.ISystemNewConnectionWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class SubSystemConfigurationAdapter
implements ISubSystemConfigurationAdapter,
ISystemNewFilterActionConfigurator {
    protected Hashtable imageTable = null;
    private IAction[] subSystemActions = null;
    private IAction[] filterPoolActions = null;
    private IAction[] filterPoolReferenceActions = null;
    private IAction[] filterActions = null;
    static /* synthetic */ Class class$0;

    public void addCommonRemoteActions(ISubSystemConfiguration config, SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystem subsystem) {
    }

    public ISystemNewConnectionWizardPage[] getNewConnectionWizardPages(ISubSystemConfiguration config, IWizard wizard) {
        if (config.getServiceType() != null) {
            SubSystemServiceWizardPage page = new SubSystemServiceWizardPage(wizard, config);
            return new ISystemNewConnectionWizardPage[]{page};
        }
        return new ISystemNewConnectionWizardPage[0];
    }

    public ISystemSubSystemPropertyPageCoreForm getSubSystemPropertyPageCoreFrom(ISubSystemConfiguration config, ISystemMessageLine msgLine, Object caller) {
        return new SystemSubSystemPropertyPageCoreForm(msgLine, caller);
    }

    public ImageDescriptor getImage(ISubSystemConfiguration config) {
        ISubSystemConfigurationProxy proxy = config.getSubSystemConfigurationProxy();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.ui.subsystems.SubSystemConfigurationProxyAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapterCandidate = iAdapterManager.getAdapter((Object)proxy, (Class)clazz);
        SubSystemConfigurationProxyAdapter adapter = (SubSystemConfigurationProxyAdapter)adapterCandidate;
        ImageDescriptor result = adapter.getImageDescriptor();
        return result;
    }

    public Image getGraphicsImage(ISubSystemConfiguration config) {
        ImageDescriptor id = this.getImage(config);
        if (id != null) {
            Image image = null;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable();
            } else {
                image = (Image)this.imageTable.get(id);
            }
            if (image == null) {
                image = id.createImage();
                this.imageTable.put(id, image);
            }
            return image;
        }
        return null;
    }

    public ImageDescriptor getLiveImage(ISubSystemConfiguration config) {
        ISubSystemConfigurationProxy proxy = config.getSubSystemConfigurationProxy();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.ui.subsystems.SubSystemConfigurationProxyAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapterCandidate = iAdapterManager.getAdapter((Object)proxy, (Class)clazz);
        SubSystemConfigurationProxyAdapter adapter = (SubSystemConfigurationProxyAdapter)adapterCandidate;
        ImageDescriptor result = adapter.getLiveImageDescriptor();
        return result;
    }

    public Image getGraphicsLiveImage(ISubSystemConfiguration config) {
        ImageDescriptor id = this.getLiveImage(config);
        if (id != null) {
            Image image = null;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable();
            } else {
                image = (Image)this.imageTable.get(id);
            }
            if (image == null) {
                image = id.createImage();
                this.imageTable.put(id, image);
            }
            return image;
        }
        return null;
    }

    public IAction[] getSubSystemActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISubSystem selectedSubSystem) {
        int idx;
        Vector<IAction> childActions = new Vector<IAction>();
        if (config.supportsFilters()) {
            IAction[] newFilterActions;
            IAction[] newFPActions;
            boolean showFilterPools = config.showFilterPools();
            if (showFilterPools && (newFPActions = this.getSubSystemNewFilterPoolActions(menu, selection, shell, menuGroup, config, selectedSubSystem)) != null) {
                idx = 0;
                while (idx < newFPActions.length) {
                    if (newFPActions[idx] instanceof SystemFilterAbstractFilterPoolAction) {
                        SystemFilterAbstractFilterPoolAction fpAction = (SystemFilterAbstractFilterPoolAction)newFPActions[idx];
                        fpAction.setFilterPoolManagerNamePreSelection(selectedSubSystem.getSystemProfile().getName());
                        fpAction.setFilterPoolManagerProvider((ISystemFilterPoolManagerProvider)config);
                    }
                    childActions.addElement(newFPActions[idx]);
                    ++idx;
                }
            }
            if (showFilterPools) {
                childActions.addElement(new SystemFilterSelectFilterPoolsAction(shell));
                childActions.addElement(new SystemFilterWorkWithFilterPoolsAction(shell));
            }
            if (!showFilterPools && (newFilterActions = this.getNewFilterPoolFilterActions(menu, selection, shell, menuGroup, config, null)) != null && newFilterActions.length > 0) {
                idx = 0;
                while (idx < newFilterActions.length) {
                    if (newFilterActions[idx] instanceof SystemNewFilterAction) {
                        ((SystemNewFilterAction)newFilterActions[idx]).setCallBackConfigurator(this, selectedSubSystem);
                    }
                    ++idx;
                }
                idx = 0;
                while (idx < newFilterActions.length) {
                    childActions.addElement(newFilterActions[idx]);
                    ++idx;
                }
            }
        }
        if (config.supportsSubSystemConnect()) {
            this.addConnectOrDisconnectAction(childActions, shell, selectedSubSystem);
        }
        if (this.subSystemActions == null) {
            int nbrBaseActions = 0;
            if (config.supportsSubSystemConnect() && selectedSubSystem.getConnectorService().supportsUserId()) {
                ++nbrBaseActions;
            }
            this.subSystemActions = new IAction[nbrBaseActions];
            int ssIdx = 0;
            if (config.supportsSubSystemConnect() && selectedSubSystem.getConnectorService().supportsUserId()) {
                this.subSystemActions[ssIdx++] = new SystemClearPasswordAction(shell);
            }
        }
        IAction[] allActions = new IAction[childActions.size() + this.subSystemActions.length];
        int allIndex = 0;
        idx = 0;
        while (idx < childActions.size()) {
            allActions[allIndex++] = (IAction)childActions.elementAt(idx);
            ++idx;
        }
        idx = 0;
        while (idx < this.subSystemActions.length) {
            allActions[allIndex++] = this.subSystemActions[idx];
            ++idx;
        }
        return allActions;
    }

    protected void addConnectOrDisconnectAction(Vector actions, Shell shell, ISubSystem selectedSS) {
        boolean connected = selectedSS.isConnected();
        if (connected) {
            actions.addElement(new SystemDisconnectAction(shell));
        } else {
            actions.addElement(new SystemConnectAction(shell));
        }
    }

    public void configureNewFilterAction(ISubSystemConfiguration config, SystemNewFilterAction newFilterAction, Object callerData) {
        newFilterAction.setFromRSE(true);
        boolean showFilterPools = config.showFilterPools();
        if (!showFilterPools) {
            ISubSystem selectedSubSystem = (ISubSystem)callerData;
            boolean advancedUser = false;
            ISystemFilterPoolReferenceManager refMgr = selectedSubSystem.getSystemFilterPoolReferenceManager();
            ISystemFilterPool[] refdPools = refMgr.getReferencedSystemFilterPools();
            if (refdPools.length == 0) {
                SystemBasePlugin.logInfo("SubSystemConfigurationImpl::getSubSystemActions - getReferencedSystemFilterPools returned array of length zero.");
            } else if (refdPools.length > 1) {
                int idx = 0;
                while (!advancedUser && idx < refdPools.length) {
                    if (!refdPools[idx].isDefault() && refdPools[idx].getOwningParentName() == null) {
                        advancedUser = true;
                    }
                    ++idx;
                }
            }
            if (advancedUser) {
                newFilterAction.setAllowFilterPoolSelection(refdPools);
            } else {
                boolean anyAdded = false;
                ISystemFilterPoolWrapperInformation poolWrapperInfo = this.getNewFilterWizardPoolWrapperInformation();
                ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
                ISystemProfile activeProfile = selectedSubSystem.getHost().getSystemProfile();
                int idx = 0;
                while (idx < activeProfiles.length) {
                    ISystemFilterPool defaultPool = this.getDefaultSystemFilterPool(config, activeProfiles[idx]);
                    if (defaultPool != null) {
                        poolWrapperInfo.addWrapper(activeProfiles[idx].getName(), defaultPool, activeProfiles[idx] == activeProfile);
                        anyAdded = true;
                    }
                    ++idx;
                }
                if (anyAdded) {
                    newFilterAction.setAllowFilterPoolSelection(poolWrapperInfo);
                }
            }
        }
    }

    public ISystemFilterPool getDefaultSystemFilterPool(ISubSystemConfiguration config, ISystemProfile profile) {
        ISystemFilterPool pool = null;
        ISystemFilterPoolManager mgr = config.getFilterPoolManager(profile);
        pool = mgr.getFirstDefaultSystemFilterPool();
        return pool;
    }

    protected ISystemFilterPoolWrapperInformation getNewFilterWizardPoolWrapperInformation() {
        return new SystemFilterPoolWrapperInformation(SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_LABEL, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_TOOLTIP, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_VERBIAGE);
    }

    protected IAction[] getSubSystemNewFilterPoolActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISubSystem selectedSubSystem) {
        IAction[] actions = new IAction[2];
        actions[0] = new SystemFilterNewFilterPoolAction(shell);
        ((ISystemAction)actions[0]).setHelp("org.eclipse.rse.ui.actn0040");
        ((SystemFilterNewFilterPoolAction)actions[0]).setDialogHelp("org.eclipse.rse.ui.wnfp0000");
        actions[1] = new SystemFilterCascadingNewFilterPoolReferenceAction(shell, selectedSubSystem.getSystemFilterPoolReferenceManager());
        ((ISystemAction)actions[1]).setHelp("org.eclipse.rse.ui.actn0041");
        return actions;
    }

    public ImageDescriptor getSystemFilterPoolManagerImage() {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemprofileIcon");
    }

    public ImageDescriptor getSystemFilterPoolImage(ISystemFilterPool filterPool) {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
    }

    public ImageDescriptor getSystemFilterImage(ISystemFilter filter) {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon");
    }

    public ImageDescriptor getSystemFilterPoolImage(ISystemFilterPoolReference filterPoolRef) {
        return this.getSystemFilterPoolImage(filterPoolRef.getReferencedFilterPool());
    }

    public ImageDescriptor getSystemFilterImage(ISystemFilterReference filterRef) {
        return this.getSystemFilterImage(filterRef.getReferencedFilter());
    }

    public ImageDescriptor getSystemFilterStringImage(ISystemFilterString filterString) {
        return this.getSystemFilterStringImage(filterString.getString());
    }

    public ImageDescriptor getSystemFilterStringImage(String filterStringString) {
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterstringIcon");
    }

    public IAction[] getFilterPoolActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISystemFilterPool selectedPool) {
        int idx;
        Vector<IAction> childActions = new Vector<IAction>();
        IAction[] newActions = this.getNewFilterPoolFilterActions(menu, selection, shell, menuGroup, config, selectedPool);
        if (newActions != null) {
            idx = 0;
            while (idx < newActions.length) {
                childActions.addElement(newActions[idx]);
                ++idx;
            }
        }
        if (this.filterPoolActions == null) {
            int nbr = 2;
            this.filterPoolActions = new IAction[nbr];
            SystemFilterCopyFilterPoolAction copyAction = new SystemFilterCopyFilterPoolAction(shell);
            copyAction.setPromptString(SystemResources.RESID_COPY_TARGET_PROFILE_PROMPT);
            copyAction.setHelp("org.eclipse.rse.ui.actn0060");
            copyAction.setDialogHelp("org.eclipse.rse.ui.dcfp0000");
            SystemFilterMoveFilterPoolAction moveAction = new SystemFilterMoveFilterPoolAction(shell);
            moveAction.setPromptString(SystemResources.RESID_MOVE_TARGET_PROFILE_PROMPT);
            moveAction.setHelp("org.eclipse.rse.ui.actn0061");
            moveAction.setDialogHelp("org.eclipse.rse.ui.dmfp0000");
            this.filterPoolActions[0] = copyAction;
            this.filterPoolActions[1] = moveAction;
        }
        idx = 0;
        while (idx < this.filterPoolActions.length) {
            childActions.addElement(this.filterPoolActions[idx]);
            ++idx;
        }
        IAction[] allFilterPoolActions = new IAction[childActions.size()];
        int idx2 = 0;
        while (idx2 < childActions.size()) {
            allFilterPoolActions[idx2] = (IAction)childActions.elementAt(idx2);
            ++idx2;
        }
        return allFilterPoolActions;
    }

    protected IAction[] getNewFilterPoolFilterActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISystemFilterPool selectedPool) {
        IAction[] actions = new IAction[]{this.getNewFilterPoolFilterAction(config, selectedPool, shell)};
        return actions;
    }

    protected IAction getNewFilterPoolFilterAction(ISubSystemConfiguration config, ISystemFilterPool selectedPool, Shell shell) {
        SystemNewFilterAction action = new SystemNewFilterAction(shell, selectedPool);
        action.setHelp("org.eclipse.rse.ui.actn0042");
        action.setDialogHelp("org.eclipse.rse.ui.wnfr0000");
        return action;
    }

    protected IAction getNewNestedFilterAction(ISubSystemConfiguration config, ISystemFilter selectedFilter, Shell shell) {
        return this.getNewFilterPoolFilterAction(config, selectedFilter.getParentFilterPool(), shell);
    }

    protected IAction getChangeFilterAction(ISubSystemConfiguration config, ISystemFilter selectedFilter, Shell shell) {
        SystemChangeFilterAction action = new SystemChangeFilterAction(shell);
        action.setHelp("org.eclipse.rse.ui.actn0081");
        action.setDialogHelp("org.eclipse.rse.ui.dufr0000");
        return action;
    }

    public void customizeChangeFilterPropertyPage(ISubSystemConfiguration config, SystemChangeFilterPropertyPage page, ISystemFilter selectedFilter, Shell shell) {
        boolean singleFilterString;
        IAction changeAction = this.getChangeFilterAction(config, selectedFilter, shell);
        if (changeAction instanceof SystemChangeFilterAction) {
            SystemChangeFilterAction changeFilterAction = (SystemChangeFilterAction)changeAction;
            changeFilterAction.setSelection((ISelection)new StructuredSelection((Object)selectedFilter));
            Dialog dlg = changeFilterAction.createDialog(shell);
            if (dlg instanceof SystemChangeFilterDialog) {
                SystemChangeFilterDialog changeFilterDlg = (SystemChangeFilterDialog)dlg;
                page.setDuplicateFilterStringErrorMessage(changeFilterDlg.getDuplicateFilterStringErrorMessage());
                page.setFilterStringEditPane(changeFilterDlg.getFilterStringEditPane(shell));
                page.setFilterStringValidator(changeFilterDlg.getFilterStringValidator());
                page.setListLabel(changeFilterDlg.getListLabel(), changeFilterDlg.getListTip());
                page.setParentPoolPromptLabel(changeFilterDlg.getParentPoolPromptLabel(), changeFilterDlg.getParentPoolPromptTip());
                page.setNamePromptLabel(changeFilterDlg.getNamePromptLabel(), changeFilterDlg.getNamePromptTip());
                page.setNewListItemText(changeFilterDlg.getNewListItemText());
                page.setDescription(changeFilterDlg.getTitle());
            }
        }
        if (selectedFilter.isNonChangable()) {
            page.setEditable(false);
        }
        boolean bl = singleFilterString = selectedFilter.isSingleFilterStringOnly() || selectedFilter.isNonChangable() && selectedFilter.getFilterStringCount() == 1;
        if (singleFilterString) {
            page.setSupportsMultipleStrings(false);
        }
    }

    public void customizeFilterStringPropertyPage(ISubSystemConfiguration config, SystemFilterStringPropertyPage page, ISystemFilterString selectedFilterString, Shell shell) {
        ISystemFilter selectedFilter = selectedFilterString.getParentSystemFilter();
        IAction changeAction = this.getChangeFilterAction(config, selectedFilter, shell);
        if (changeAction instanceof SystemChangeFilterAction) {
            SystemChangeFilterAction changeFilterAction = (SystemChangeFilterAction)changeAction;
            changeFilterAction.setSelection((ISelection)new StructuredSelection((Object)selectedFilter));
            Dialog dlg = changeFilterAction.createDialog(shell);
            if (dlg instanceof SystemChangeFilterDialog) {
                SystemChangeFilterDialog changeFilterDlg = (SystemChangeFilterDialog)dlg;
                page.setDuplicateFilterStringErrorMessage(changeFilterDlg.getDuplicateFilterStringErrorMessage());
                page.setFilterStringEditPane(changeFilterDlg.getFilterStringEditPane(shell));
                page.setFilterStringValidator(changeFilterDlg.getFilterStringValidator());
                page.setDescription(changeFilterDlg.getTitle());
            }
        }
        if (selectedFilter.isNonChangable()) {
            page.setEditable(false);
        }
    }

    public IAction[] getFilterPoolReferenceActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISystemFilterPoolReference selectedPoolReference) {
        ISystemFilterPool selectedPool = selectedPoolReference.getReferencedFilterPool();
        if (this.filterPoolReferenceActions == null) {
            this.filterPoolReferenceActions = new IAction[3];
            this.filterPoolReferenceActions[0] = this.getRemoveFilterPoolReferenceAction(config, selectedPool, shell);
            this.filterPoolReferenceActions[1] = new SystemFilterMoveUpFilterPoolReferenceAction(shell);
            ((ISystemAction)this.filterPoolReferenceActions[1]).setHelp("org.eclipse.rse.ui.actn0063");
            this.filterPoolReferenceActions[2] = new SystemFilterMoveDownFilterPoolReferenceAction(shell);
            ((ISystemAction)this.filterPoolReferenceActions[2]).setHelp("org.eclipse.rse.ui.actn0064");
        }
        return this.filterPoolReferenceActions;
    }

    protected IAction getRemoveFilterPoolReferenceAction(ISubSystemConfiguration config, ISystemFilterPool selectedPool, Shell shell) {
        SystemFilterRemoveFilterPoolReferenceAction action = new SystemFilterRemoveFilterPoolReferenceAction(shell);
        action.setHelp("org.eclipse.rse.ui.actn0062");
        return action;
    }

    public ISystemFilter createFilterByPrompting(ISubSystemConfiguration config, ISystemFilterReference referenceToPromptableFilter, Shell shell) throws Exception {
        ISystemFilter filterPrompt = referenceToPromptableFilter.getReferencedFilter();
        ISystemFilterPool selectedPool = filterPrompt.getParentFilterPool();
        SystemNewFilterAction action = new SystemNewFilterAction(shell, selectedPool);
        ISystemFilterPoolReferenceManagerProvider simulatedSelectedParent = null;
        if (!config.showFilterPools()) {
            simulatedSelectedParent = referenceToPromptableFilter.getProvider();
            action.setCallBackConfigurator(this, simulatedSelectedParent);
        } else {
            simulatedSelectedParent = referenceToPromptableFilter.getParentSystemFilterReferencePool();
            action.setCallBackConfigurator(this, referenceToPromptableFilter.getProvider());
        }
        action.setSelection((ISelection)new StructuredSelection((Object)simulatedSelectedParent));
        action.run();
        ISystemFilter newFilter = action.getNewFilter();
        return newFilter;
    }

    public IAction[] getFilterActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISystemFilter selectedFilter) {
        IAction newNestedFilterAction;
        Vector childActions = new Vector();
        Vector ourChildActions = this.getAdditionalFilterActions(config, selectedFilter, shell);
        int pasteIndex = -1;
        if (ourChildActions != null) {
            int idx = 0;
            while (idx < ourChildActions.size()) {
                if (ourChildActions.elementAt(idx) instanceof SystemPasteFromClipboardAction) {
                    pasteIndex = idx;
                } else {
                    childActions.addElement(ourChildActions.elementAt(idx));
                }
                ++idx;
            }
        }
        if (this.filterActions == null) {
            int additionalActions = 4;
            if (pasteIndex > -1) {
                ++additionalActions;
            }
            int fsIdx = 0;
            this.filterActions = new IAction[additionalActions];
            SystemFilterCopyFilterAction copyAction = new SystemFilterCopyFilterAction(shell);
            copyAction.setPromptString(SystemResources.RESID_COPY_TARGET_FILTERPOOL_PROMPT);
            copyAction.setHelp("org.eclipse.rse.ui.actn0082");
            copyAction.setDialogHelp("org.eclipse.rse.ui.dcfr0000");
            this.filterActions[fsIdx++] = copyAction;
            if (pasteIndex > -1 && ourChildActions != null) {
                this.filterActions[fsIdx++] = (IAction)ourChildActions.elementAt(pasteIndex);
            }
            SystemFilterMoveFilterAction moveAction = new SystemFilterMoveFilterAction(shell);
            moveAction.setPromptString(SystemResources.RESID_MOVE_TARGET_FILTERPOOL_PROMPT);
            moveAction.setHelp("org.eclipse.rse.ui.actn0083");
            moveAction.setDialogHelp("org.eclipse.rse.ui.dmfr0000");
            this.filterActions[fsIdx++] = moveAction;
            this.filterActions[fsIdx] = new SystemFilterMoveUpFilterAction(shell);
            ((SystemFilterMoveUpFilterAction)this.filterActions[fsIdx++]).setHelp("org.eclipse.rse.ui.actn0084");
            this.filterActions[fsIdx] = new SystemFilterMoveDownFilterAction(shell);
            ((SystemFilterMoveDownFilterAction)this.filterActions[fsIdx++]).setHelp("org.eclipse.rse.ui.actn0085");
        }
        if (config.supportsNestedFilters() && (newNestedFilterAction = this.getNewNestedFilterAction(config, selectedFilter, shell)) != null) {
            childActions.addElement(newNestedFilterAction);
        }
        IAction[] allFilterActions = new IAction[childActions.size() + this.filterActions.length];
        int allIdx = 0;
        int idx = 0;
        while (idx < childActions.size()) {
            allFilterActions[allIdx++] = (IAction)childActions.elementAt(idx);
            ++idx;
        }
        idx = 0;
        while (idx < this.filterActions.length) {
            allFilterActions[allIdx++] = this.filterActions[idx];
            ++idx;
        }
        return allFilterActions;
    }

    protected Vector getAdditionalFilterActions(ISubSystemConfiguration config, ISystemFilter selectedFilter, Shell shell) {
        return null;
    }

    public IAction[] getFilterReferenceActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration config, ISystemFilterReference selectedFilterRef) {
        return null;
    }

    public IServerLauncherForm getServerLauncherForm(ISubSystemConfiguration config, Shell shell, ISystemMessageLine msgLine) {
        return new RemoteServerLauncherForm(shell, msgLine);
    }

    public ISystemValidator getPasswordValidator(ISubSystemConfiguration configuration) {
        return null;
    }

    public ISystemValidator getPortValidator(ISubSystemConfiguration configuration) {
        ValidatorPortInput portValidator = new ValidatorPortInput();
        return portValidator;
    }

    public PropertyPage getPropertyPage(ISubSystem subsystem, Composite parent) {
        return ((SubSystem)subsystem).getPropertyPage(parent);
    }

    public ISystemValidator getUserIdValidator(ISubSystemConfiguration config) {
        ValidatorSpecialChar userIdValidator = new ValidatorSpecialChar("=;", false, RSEUIPlugin.getPluginMessage("RSEG1026"), RSEUIPlugin.getPluginMessage("RSEG1025"));
        return userIdValidator;
    }

    public Object[] applyViewFilters(IContextObject parent, Object[] children) {
        return children;
    }
}

