/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.api.ui.compile;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.api.files.compile.ISystemCompileManagerAdapter;
import org.eclipse.rse.internal.useractions.files.compile.UniversalCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemWorkWithCompileCommandsDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;

public class SystemWorkWithCompileCommandsAction
extends SystemBaseDialogAction {
    private ISubSystem subsystem = null;
    private ISubSystemConfiguration subsystemFactory = null;
    private ISystemProfile profile = null;
    private SystemCompileManager compileManager = null;
    static /* synthetic */ Class class$0;

    public SystemWorkWithCompileCommandsAction(Shell shell, boolean fromCascadingCompileAction) {
        super(fromCascadingCompileAction ? SystemUDAResources.ACTION_WORKWITH_WWCOMPILE_CMDS_LABEL : SystemUDAResources.ACTION_WORKWITH_COMPILE_CMDS_LABEL, fromCascadingCompileAction ? SystemUDAResources.ACTION_WORKWITH_WWCOMPILE_CMDS_TOOLTIP : SystemUDAResources.ACTION_WORKWITH_COMPILE_CMDS_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("WORK_WITH_COMPILE_COMMANDS_1"), shell);
        this.allowOnMultipleSelection(false);
        if (!fromCascadingCompileAction) {
            this.setContextMenuGroup("group.workwith");
        } else {
            this.setContextMenuGroup("group.reorganize");
        }
        this.setHelp("org.eclipse.rse.ui.actnwwcc");
        this.setAvailableOffline(true);
    }

    public SystemWorkWithCompileCommandsAction(Shell shell, boolean fromCascadingCompileAction, ISubSystem subSystem, SystemCompileManager compileManager) {
        this(shell, fromCascadingCompileAction);
        this.subsystem = subSystem;
        this.compileManager = compileManager;
        if (subSystem != null) {
            this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
            this.profile = subSystem.getSystemProfile();
        }
    }

    public void reset() {
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return true;
    }

    protected Dialog createDialog(Shell shell) {
        Object inputObject = this.getFirstSelection();
        boolean caseSensitive = false;
        if (this.subsystem == null) {
            if (inputObject instanceof ISubSystem) {
                this.subsystem = (ISubSystem)inputObject;
            } else {
                ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)inputObject);
                if (rmtAdapter != null) {
                    this.subsystem = rmtAdapter.getSubSystem(inputObject);
                }
            }
        }
        SystemCompileProfile currProfile = null;
        SystemCompileProfile[] currProfiles = null;
        if (this.subsystem != null) {
            if (this.subsystemFactory == null) {
                this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
            }
            if (this.profile == null) {
                this.profile = this.subsystem.getSystemProfile();
            }
        }
        if (this.compileManager == null && inputObject instanceof IAdaptable) {
            ISystemCompileManagerAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)inputObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.internal.useractions.api.files.compile.ISystemCompileManagerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemCompileManagerAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.compileManager = adapter.getSystemCompileManager(this.subsystemFactory);
            }
        }
        if (this.compileManager == null) {
            this.compileManager = new UniversalCompileManager();
            this.compileManager.setSubSystemFactory(this.subsystemFactory);
        }
        if (this.compileManager != null) {
            if (this.profile != null) {
                currProfile = this.compileManager.getCompileProfile(this.profile);
                currProfiles = this.compileManager.getAllCompileProfiles();
            }
            caseSensitive = this.subsystemFactory.isCaseSensitive();
            SystemWorkWithCompileCommandsDialog dlg = new SystemWorkWithCompileCommandsDialog(shell, this.compileManager, currProfile);
            dlg.setProfiles(currProfiles);
            dlg.setCaseSensitive(caseSensitive);
            return dlg;
        }
        return null;
    }

    protected Object getDialogValue(Dialog dlg) {
        return null;
    }
}

