/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDAEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTypeEditPaneTypesSelector;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDSimpleTypesListEditor;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeViewNewItem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.internal.useractions.ui.validators.ValidatorUserTypeName;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.widgets.SystemEditPaneStateMachine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SystemUDTypeEditPane
implements ISelectionChangedListener {
    private Composite comp;
    private Text textName;
    private ISystemUDTypeEditPaneTypesSelector typesEditor;
    protected SystemUDActionSubsystem udaActionSubsys;
    protected ISubSystem subsystem;
    protected ISubSystemConfiguration subsystemFactory;
    protected ISystemProfile profile;
    protected ISystemUDTreeView treeView;
    protected ISystemUDAEditPaneHoster parentDialog;
    private ValidatorUserTypeName nameValidator;
    private NameModifyListener nameML = new NameModifyListener();
    private TypesModifyListener typesML = new TypesModifyListener();
    private SystemMessage errorMessage;
    private boolean newMode = false;
    private boolean recursiveCall = false;
    private int newModeDomain = -1;
    private SystemUDTreeViewNewItem newModeNewItem;
    private SystemEditPaneStateMachine stateMachine;
    private int currentDomain = -1;
    private SystemUDTypeElement currentType;
    private boolean nameChanged = false;
    private boolean isEnabled = false;
    private boolean ignoreChanges = false;
    private static final Vector EMPTY_VECTOR = new Vector();

    public SystemUDTypeEditPane(SystemUDActionSubsystem udaActionSubsys, ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        this.udaActionSubsys = udaActionSubsys;
        this.subsystem = udaActionSubsys.getSubsystem();
        this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
        this.profile = this.subsystem.getSystemProfile();
        this.treeView = tv;
        this.parentDialog = parent;
    }

    public void setDomain(int domain) {
        this.currentDomain = domain;
        if (this.typesEditor != null) {
            this.typesEditor.setDomain(domain);
        }
    }

    public int getDomain() {
        if (this.currentDomain == -1) {
            if (this.newMode) {
                return this.newModeDomain;
            }
            if (this.currentType != null) {
                return this.currentType.getDomain();
            }
            return -1;
        }
        return this.currentDomain;
    }

    public void setStateMachine(SystemEditPaneStateMachine sm) {
        this.stateMachine = sm;
    }

    public Control createContents(Composite parent) {
        this.nameValidator = new ValidatorUserTypeName();
        int nbrColumns = 2;
        this.comp = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.textName = SystemWidgetHelpers.createLabeledTextField((Composite)this.comp, null, (String)SystemUDAResources.RESID_UDT_NAME_LABEL, (String)SystemUDAResources.RESID_UDT_NAME_TOOLTIP);
        this.typesEditor = this.createTypesListEditor(this.comp, nbrColumns);
        this.typesEditor.setMessageLine(this.parentDialog);
        this.textName.setTextLimit(50);
        return this.comp;
    }

    protected ISystemUDTypeEditPaneTypesSelector createTypesListEditor(Composite parent, int nbrColumns) {
        SystemUDSimpleTypesListEditor simpleEditor = new SystemUDSimpleTypesListEditor(parent, nbrColumns);
        simpleEditor.setAutoUpperCase(this.getAutoUpperCaseTypes());
        return simpleEditor;
    }

    protected boolean getAutoUpperCaseTypes() {
        return true;
    }

    public void setEnabled(boolean enable) {
        this.textName.setEnabled(enable);
        this.typesEditor.setEnabled(enable);
    }

    protected boolean validateInput(boolean setFocus, Control skipControl) {
        Text errCtl = null;
        this.errorMessage = null;
        if (skipControl != this.textName) {
            this.errorMessage = this.nameValidator.validate(this.textName.getText().trim());
        }
        errCtl = this.textName;
        if (this.errorMessage == null && skipControl != this.typesEditor.getControl()) {
            this.errorMessage = this.typesEditor.validate();
            if (this.errorMessage == null) {
                this.errorMessage = this.doTypesStringValidation(setFocus);
            }
            errCtl = this.typesEditor.getControl();
        }
        if (this.errorMessage == null) {
            this.errorMessage = this.doAdditionalValidation(setFocus);
        }
        if (this.errorMessage != null) {
            this.parentDialog.setErrorMessage(this.errorMessage);
            if (setFocus) {
                errCtl.setFocus();
            }
        } else {
            this.parentDialog.clearErrorMessage();
        }
        this.setPageComplete();
        return this.errorMessage == null;
    }

    protected SystemMessage doTypesStringValidation(boolean doSetFocus) {
        return null;
    }

    protected SystemMessage doAdditionalValidation(boolean doSetFocus) {
        return null;
    }

    private void resetPageValidation() {
        this.errorMessage = null;
        this.parentDialog.clearErrorMessage();
        this.parentDialog.setPageComplete(true);
    }

    protected boolean isPageComplete() {
        return this.errorMessage == null && this.textName.getText().trim().length() > 0 && this.typesEditor.getTypes().length() > 0;
    }

    protected void setPageComplete() {
        boolean complete = this.isPageComplete();
        this.parentDialog.setPageComplete(complete);
    }

    protected void setChangesMade() {
        if (this.stateMachine != null) {
            this.stateMachine.setChangesMade();
        }
    }

    public boolean areErrorsPending() {
        return this.errorMessage != null && (this.currentType != null || this.newMode);
    }

    public void selectionChanged(SelectionChangedEvent se) {
        if (this.recursiveCall) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)se.getSelection();
        Object so = ss.getFirstElement();
        if (this.areErrorsPending() && (this.newMode || SystemUDBaseManager.inCurrentTree(this.currentType.getElement()))) {
            if (!this.newMode && so != this.currentType) {
                this.treeView.setSelection((ISelection)new StructuredSelection((Object)this.currentType));
            } else if (this.newMode && so != this.newModeNewItem) {
                this.treeView.setSelection((ISelection)new StructuredSelection((Object)this.newModeNewItem));
            }
            return;
        }
        if (this.stateMachine != null && this.stateMachine.isSaveRequired()) {
            this.saveData();
            if (this.newMode) {
                this.recursiveCall = true;
                this.treeView.refreshElementParent(this.currentType);
                this.recursiveCall = false;
                if (so instanceof SystemUDTypeElement) {
                    this.treeView.selectElement((SystemUDTypeElement)so);
                } else if (so != null) {
                    this.treeView.setSelection((ISelection)new StructuredSelection(so));
                }
                return;
            }
        }
        this.recursiveCall = false;
        this.errorMessage = null;
        this.resetPageValidation();
        boolean bl = this.newMode = so instanceof SystemUDTreeViewNewItem && ((SystemUDTreeViewNewItem)so).isExecutable();
        if (this.nameChanged) {
            this.nameChanged = false;
            if (this.currentType != null) {
                this.treeView.refresh(this.currentType);
            }
        }
        SystemUDTypeElement sn = null;
        if (so != null && so instanceof SystemUDTypeElement) {
            sn = (SystemUDTypeElement)so;
        }
        this.currentType = sn;
        if (this.isEnabled) {
            this.textName.removeModifyListener((ModifyListener)this.nameML);
            this.typesEditor.removeModifyListener(this.typesML);
        }
        if (!this.newMode && (sn == null || sn.isDomain())) {
            this.isEnabled = false;
            this.textName.setText("");
            this.typesEditor.clearTypes();
        } else {
            this.isEnabled = true;
            if (!this.newMode && sn != null) {
                this.textName.setText(sn.toString());
                this.typesEditor.setTypes(sn.getTypes());
                this.setEnabled(!this.treeView.isElementAllSelected());
                this.typesEditor.setEditable(!this.treeView.isElementAllSelected(), this.treeView.isElementAllSelected() ? this.treeView.getVendorOfSelection() : null);
            } else {
                this.textName.setText("");
                this.typesEditor.clearTypes();
                this.typesEditor.setEditable(true, null);
                this.setEnabled(true);
            }
            this.textName.addModifyListener((ModifyListener)this.nameML);
            this.typesEditor.addModifyListener(this.typesML);
        }
        if (this.newMode) {
            this.stateMachine.setNewMode();
            this.newModeNewItem = (SystemUDTreeViewNewItem)so;
            this.newModeDomain = this.newModeNewItem.getDomain();
            if (this.newModeDomain != this.currentDomain) {
                this.setDomain(this.newModeDomain);
            }
        } else if (sn == null || sn.isDomain()) {
            this.stateMachine.setUnsetMode();
        } else {
            this.stateMachine.setEditMode();
            if (sn.getDomain() != this.currentDomain) {
                this.setDomain(sn.getDomain());
            }
        }
        this.nameValidator.setExistingNamesList(this.getExistingNames());
        this.setPageComplete();
    }

    protected Vector getExistingNames() {
        if (this.newMode) {
            SystemUDActionSubsystem udas = this.getUDActionSubsystem();
            SystemUDTypeManager udtm = udas.getUDTypeManager();
            return udtm.getExistingNames(null, this.newModeDomain);
        }
        if (this.currentType != null) {
            return this.currentType.getExistingNames();
        }
        return EMPTY_VECTOR;
    }

    protected SystemUDActionSubsystem getUDActionSubsystem() {
        return this.udaActionSubsys;
    }

    protected void processChanges() {
        this.currentType.setName(this.textName.getText().trim());
        this.currentType.setTypes(this.typesEditor.getTypes());
    }

    protected void saveData() {
        if (this.newMode) {
            this.currentType = this.createNewType(this.textName.getText().trim(), this.newModeDomain);
        }
        this.processChanges();
        SystemUDActionSubsystem udas = this.getUDActionSubsystem();
        SystemUDTypeManager udtm = udas.getUDTypeManager();
        udtm.saveUserData();
        if (this.newMode) {
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 256, (Object)this.currentType, null);
        } else {
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 256, (Object)this.currentType, null);
        }
    }

    protected SystemUDTypeElement createNewType(String typeName, int domain) {
        SystemUDActionSubsystem udas = this.getUDActionSubsystem();
        SystemUDTypeManager udtm = udas.getUDTypeManager();
        SystemUDTypeElement nt = udtm.addType(domain, typeName);
        return nt;
    }

    public void revertPressed() {
        this.ignoreChanges = true;
        this.resetPageValidation();
        if (this.currentType != null && !this.currentType.isDomain()) {
            this.textName.setText(this.currentType.toString());
            this.typesEditor.setTypes(this.currentType.getTypes());
            if (this.stateMachine != null) {
                this.stateMachine.resetPressed();
            }
        } else if (this.newMode) {
            this.textName.setText("");
            this.typesEditor.clearTypes();
            if (this.stateMachine != null) {
                this.stateMachine.resetPressed();
            }
        }
        this.ignoreChanges = false;
        this.setPageComplete();
    }

    public void applyPressed() {
        if ((this.newMode || this.currentType != null && !this.currentType.isDomain()) && this.validateInput(true, null)) {
            this.saveData();
            if (this.stateMachine != null) {
                this.stateMachine.applyPressed();
            }
            if (this.newMode) {
                this.recursiveCall = true;
                this.treeView.refreshElementParent(this.currentType);
                this.recursiveCall = false;
                this.treeView.selectElement(this.currentType);
            } else {
                this.treeView.refresh(this.currentType);
            }
        }
        this.setPageComplete();
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (SystemUDTypeEditPane.this.ignoreChanges) {
                return;
            }
            SystemUDTypeEditPane.this.setChangesMade();
            String s = SystemUDTypeEditPane.this.textName.getText().trim().toUpperCase();
            SystemUDTypeEditPane.this.errorMessage = SystemUDTypeEditPane.this.nameValidator.validate(s);
            if (SystemUDTypeEditPane.this.errorMessage != null) {
                SystemUDTypeEditPane.this.parentDialog.setErrorMessage(SystemUDTypeEditPane.this.errorMessage);
                SystemUDTypeEditPane.this.setPageComplete();
            } else {
                SystemUDTypeEditPane.this.validateInput(false, (Control)SystemUDTypeEditPane.this.textName);
                if (SystemUDTypeEditPane.this.currentType != null) {
                    SystemUDTypeEditPane.this.nameChanged = true;
                }
            }
        }
    }

    private class TypesModifyListener
    implements ModifyListener {
        private TypesModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (SystemUDTypeEditPane.this.ignoreChanges) {
                return;
            }
            SystemUDTypeEditPane.this.setChangesMade();
            SystemUDTypeEditPane.this.errorMessage = SystemUDTypeEditPane.this.typesEditor.validate();
            if (SystemUDTypeEditPane.this.errorMessage != null) {
                SystemUDTypeEditPane.this.parentDialog.setErrorMessage(SystemUDTypeEditPane.this.errorMessage);
                SystemUDTypeEditPane.this.setPageComplete();
            } else {
                SystemUDTypeEditPane.this.validateInput(false, SystemUDTypeEditPane.this.typesEditor.getControl());
            }
        }
    }
}

