/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.ssh;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.ssh.SshMessages;
import org.eclipse.tm.internal.terminal.ssh.SshSettings;

public class SshSettingsPage
implements ISettingsPage {
    private Text fHostText;
    private Text fUser;
    private Text fTimeout;
    private Text fKeepalive;
    private final SshSettings fTerminalSettings;
    private Text fPort;
    private Text fPassword;

    public SshSettingsPage(SshSettings settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setHost(this.fHostText.getText());
        this.fTerminalSettings.setUser(this.fUser.getText());
        this.fTerminalSettings.setPassword(this.fPassword.getText());
        this.fTerminalSettings.setPort(this.fPort.getText());
        this.fTerminalSettings.setTimeout(this.fTimeout.getText());
        this.fTerminalSettings.setKeepalive(this.fKeepalive.getText());
    }

    public void loadSettings() {
        if (this.fTerminalSettings != null) {
            this.fHostText.setText(this.get(this.fTerminalSettings.getHost(), ""));
            this.fTimeout.setText(this.get(this.fTerminalSettings.getTimeoutString(), "0"));
            this.fKeepalive.setText(this.get(this.fTerminalSettings.getKeepaliveString(), "300"));
            this.fUser.setText(this.get(this.fTerminalSettings.getUser(), ""));
            this.fPort.setText(this.get(this.fTerminalSettings.getPortString(), "22"));
            this.fPassword.setText(this.get(this.fTerminalSettings.getPassword(), ""));
        }
    }

    String get(String value, String def) {
        if (value == null || value.length() == 0) {
            return def;
        }
        return value;
    }

    public boolean validateSettings() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.fHostText = this.createTextField(composite, SshMessages.HOST);
        this.fUser = this.createTextField(composite, SshMessages.USER);
        this.fPassword = this.createTextField(composite, SshMessages.PASSWORD, 0x400000);
        this.fTimeout = this.createTextField(composite, SshMessages.TIMEOUT);
        this.fKeepalive = this.createTextField(composite, SshMessages.KEEPALIVE);
        this.fKeepalive.setToolTipText(SshMessages.KEEPALIVE_Tooltip);
        this.fPort = this.createTextField(composite, SshMessages.PORT);
        this.loadSettings();
    }

    private Text createTextField(Composite composite, String labelTxt, int textOptions) {
        Label ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(labelTxt) + ":");
        GridData gridData = new GridData(768);
        Text text = new Text(composite, 0x800 | textOptions);
        text.setLayoutData((Object)gridData);
        return text;
    }

    private Text createTextField(Composite composite, String labelTxt) {
        return this.createTextField(composite, labelTxt, 0);
    }
}

