/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util;

import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;

public class CommandGenerator {
    private DataStore _dataStore = null;
    private DataElement _log = null;
    private static int _id = 0;

    public void setDataStore(DataStore dataStore) {
        this._dataStore = dataStore;
        this._log = this._dataStore.getLogRoot();
    }

    public DataElement logCommand(DataElement commandObject) {
        try {
            StringBuffer id = new StringBuffer(commandObject.getId());
            id.append(DataStoreResources.model_status);
            this._dataStore.createObject(commandObject, DataStoreResources.model_status, DataStoreResources.model_start, "", id.toString());
            this._log.addNestedData(commandObject, false);
        }
        catch (Exception e) {
            this._dataStore.trace(e);
        }
        return commandObject;
    }

    public DataElement createCommand(DataElement commandDescriptor) {
        if (commandDescriptor != null) {
            if (commandDescriptor.getType().equals("commanddescriptor")) {
                DataElement commandInstance = this._dataStore.createObject(null, commandDescriptor.getName(), commandDescriptor.getValue(), commandDescriptor.getSource());
                commandInstance.setDescriptor(commandDescriptor);
                return commandInstance;
            }
            System.out.println("not cd -> " + commandDescriptor);
            return null;
        }
        return null;
    }

    private void clearDeleted(DataElement element) {
        int i = 0;
        while (i < element.getNestedSize()) {
            DataElement child = element.get(i).dereference();
            if (child.isDeleted()) {
                element.removeNestedData(child);
            }
            ++i;
        }
    }

    public DataElement generateCommand(DataElement commandDescriptor, ArrayList arguments, DataElement dataObject, boolean refArg) {
        DataElement commandObject = this.createCommand(commandDescriptor);
        if (commandObject != null) {
            this.clearDeleted(dataObject);
            commandObject.setAttribute(3, commandDescriptor.getName());
            if (dataObject.isUpdated() && !dataObject.isSpirit()) {
                this._dataStore.createReference(commandObject, dataObject, DataStoreResources.model_contents);
            } else {
                dataObject.setPendingTransfer(true);
                commandObject.addNestedData(dataObject, false);
            }
            if (arguments != null) {
                int i = 0;
                while (i < arguments.size()) {
                    DataElement arg = (DataElement)arguments.get(i);
                    if (arg != null) {
                        if (!arg.isUpdated() || arg.isSpirit()) {
                            commandObject.addNestedData(arg, false);
                        } else {
                            this._dataStore.createReference(commandObject, arg, "argument");
                        }
                    }
                    ++i;
                }
            }
            return this.logCommand(commandObject);
        }
        return null;
    }

    public DataElement generateCommand(DataElement commandDescriptor, DataElement arg, DataElement dataObject, boolean refArg) {
        ++_id;
        DataElement commandObject = this.createCommand(commandDescriptor);
        if (commandObject != null) {
            commandObject.setAttribute(3, commandDescriptor.getName());
            this.clearDeleted(dataObject);
            if ((refArg || dataObject.isUpdated()) && !dataObject.isSpirit()) {
                this._dataStore.createReference(commandObject, dataObject, DataStoreResources.model_contents);
            } else {
                dataObject.setPendingTransfer(true);
                commandObject.addNestedData(dataObject, false);
            }
            if (!arg.isUpdated() || arg.isSpirit()) {
                commandObject.addNestedData(arg, false);
            } else {
                this._dataStore.createReference(commandObject, arg, "argument");
            }
            return this.logCommand(commandObject);
        }
        return null;
    }

    public DataElement generateCommand(DataElement commandDescriptor, DataElement dataObject, boolean refArg) {
        ++_id;
        DataElement commandObject = this.createCommand(commandDescriptor);
        if (commandObject != null) {
            commandObject.setAttribute(3, commandDescriptor.getName());
            this.clearDeleted(dataObject);
            if ((refArg || dataObject.isUpdated()) && !dataObject.isSpirit()) {
                this._dataStore.createReference(commandObject, dataObject, DataStoreResources.model_arguments);
            } else {
                dataObject.setPendingTransfer(true);
                commandObject.addNestedData(dataObject, false);
            }
            return this.logCommand(commandObject);
        }
        return null;
    }

    public DataElement generateResponse(DataElement document, ArrayList objects) {
        document.addNestedData(objects, false);
        return document;
    }

    public DataElement generateResponse(String responseType, DataElement dataObject) {
        if (dataObject != null) {
            DataElement commandObject = this._dataStore.createObject(null, "RESPONSE", responseType);
            commandObject.addNestedData(dataObject, true);
            return commandObject;
        }
        return null;
    }

    public DataElement generateResponse(String responseType) {
        DataElement commandObject = this._dataStore.createObject(null, "RESPONSE", responseType);
        return commandObject;
    }
}

