/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.connectorservice.ssh.Activator;
import org.eclipse.rse.connectorservice.ssh.KeyboardInteractiveDialog;
import org.eclipse.rse.connectorservice.ssh.SshConnectorResources;
import org.eclipse.rse.connectorservice.ssh.UserValidationDialog;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.ssh.ISshSessionProvider;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SshConnectorService
extends AbstractConnectorService
implements ISshSessionProvider {
    private static final int SSH_DEFAULT_PORT = 22;
    private static final int CONNECT_DEFAULT_TIMEOUT = 60;
    private static JSch jsch = new JSch();
    private Session session;
    private SessionLostHandler fSessionLostHandler = null;
    private static String current_ssh_home = null;
    private static String current_pkeys = "";
    static String SSH_HOME_DEFAULT = null;
    private static IPreferenceStore fCvsSsh2PreferenceStore;
    private static IPreferenceStore fCvsUIPreferenceStore;
    private static final String INFO_PROXY_USER = "org.eclipse.team.cvs.core.proxy.user";
    private static final String INFO_PROXY_PASS = "org.eclipse.team.cvs.core.proxy.pass";

    static {
        String ssh_dir_name = ".ssh";
        if (Platform.getOS().equals("win32")) {
            ssh_dir_name = "ssh";
        }
        if ((SSH_HOME_DEFAULT = System.getProperty("user.home")) != null) {
            SSH_HOME_DEFAULT = String.valueOf(SSH_HOME_DEFAULT) + File.separator + ssh_dir_name;
        }
    }

    public SshConnectorService(IHost host) {
        super(SshConnectorResources.SshConnectorService_Name, SshConnectorResources.SshConnectorService_Description, host, 0);
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Socket createSocket(final String host, final int port, int timeout, IProgressMonitor monitor) throws UnknownHostException, IOException {
        final Socket[] socket = new Socket[1];
        final Exception[] exception = new Exception[1];
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Socket newSocket = new Socket(host, port);
                    Socket[] socketArray = socket;
                    synchronized (socket) {
                        if (Thread.interrupted()) {
                            newSocket.close();
                        } else {
                            socket[0] = newSocket;
                        }
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                    }
                }
                catch (UnknownHostException e) {
                    exception[0] = e;
                }
                catch (IOException e) {
                    exception[0] = e;
                }
                {
                    return;
                }
            }
        });
        thread.start();
        if (timeout <= 0) {
            timeout = 60;
        }
        int i = 0;
        while (i < timeout) {
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
            Socket[] socketArray = socket;
            // MONITORENTER : socket
            if (monitor.isCanceled()) {
                if (thread.isAlive()) {
                    thread.interrupt();
                }
                if (socket[0] != null) {
                    socket[0].close();
                }
                SshConnectorService.checkCanceled(monitor);
            }
            // MONITOREXIT : socketArray
            ++i;
        }
        Socket[] socketArray = socket;
        // MONITORENTER : socket
        if (thread.isAlive()) {
            thread.interrupt();
        }
        // MONITOREXIT : socketArray
        if (exception[0] != null) {
            if (!(exception[0] instanceof UnknownHostException)) throw (IOException)exception[0];
            throw (UnknownHostException)exception[0];
        }
        if (socket[0] != null) return socket[0];
        throw new InterruptedIOException(NLS.bind((String)SshConnectorResources.Socket_timeout, (Object[])new String[]{host}));
    }

    static IPreferenceStore getCvsSsh2PreferenceStore() {
        if (fCvsSsh2PreferenceStore == null) {
            fCvsSsh2PreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.team.cvs.ssh2");
        }
        return fCvsSsh2PreferenceStore;
    }

    static IPreferenceStore getCvsUIPreferenceStore() {
        if (fCvsUIPreferenceStore == null) {
            fCvsUIPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.team.cvs.ui");
        }
        return fCvsUIPreferenceStore;
    }

    static void loadSshPrefs(JSch jsch) {
        IPreferenceStore store = SshConnectorService.getCvsSsh2PreferenceStore();
        String ssh_home = store.getString("CVSSSH2PreferencePage.SSH2HOME");
        String pkeys = store.getString("CVSSSH2PreferencePage.PRIVATEKEY");
        try {
            if (ssh_home.length() == 0) {
                ssh_home = SSH_HOME_DEFAULT;
            }
            if (current_ssh_home == null || !current_ssh_home.equals(ssh_home)) {
                SshConnectorService.loadKnownHosts(jsch, ssh_home);
                current_ssh_home = ssh_home;
                current_pkeys = "";
            }
            if (!current_pkeys.equals(pkeys)) {
                String[] pkey = pkeys.split(",");
                String[] _pkey = current_pkeys.split(",");
                current_pkeys = "";
                int i = 0;
                while (i < pkey.length) {
                    File file = new File(pkey[i]);
                    if (!file.isAbsolute()) {
                        file = new File(ssh_home, pkey[i]);
                    }
                    if (file.exists()) {
                        boolean notyet = true;
                        int j = 0;
                        while (j < _pkey.length) {
                            if (pkey[i].equals(_pkey[j])) {
                                notyet = false;
                                break;
                            }
                            ++j;
                        }
                        if (notyet) {
                            jsch.addIdentity(file.getPath());
                        }
                        current_pkeys = current_pkeys.length() == 0 ? pkey[i] : String.valueOf(current_pkeys) + "," + pkey[i];
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    static void loadKnownHosts(JSch jsch, String ssh_home) {
        try {
            File file = new File(ssh_home, "known_hosts");
            jsch.setKnownHosts(file.getPath());
        }
        catch (Exception exception) {}
    }

    static Proxy loadSshProxyPrefs() {
        IPreferenceStore store = SshConnectorService.getCvsUIPreferenceStore();
        boolean useProxy = store.getBoolean("proxyEnabled");
        ProxyHTTP proxy = null;
        if (useProxy) {
            String _type = store.getString("proxyType");
            String _host = store.getString("proxyHost");
            String _port = store.getString("proxyPort");
            boolean useAuth = store.getBoolean("proxyAuth");
            String _user = "";
            String _pass = "";
            if (useAuth) {
                Map authInfo = null;
                try {
                    URL FAKE_URL = new URL("http://org.eclipse.team.cvs.proxy.auth");
                    authInfo = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)"");
                }
                catch (MalformedURLException malformedURLException) {}
                if (authInfo == null) {
                    authInfo = Collections.EMPTY_MAP;
                }
                _user = (String)authInfo.get(INFO_PROXY_USER);
                _pass = (String)authInfo.get(INFO_PROXY_PASS);
                if (_user == null) {
                    _user = "";
                }
                if (_pass == null) {
                    _pass = "";
                }
            }
            String proxyhost = String.valueOf(_host) + ":" + _port;
            if (_type.equals("HTTP")) {
                proxy = new ProxyHTTP(proxyhost);
                if (useAuth) {
                    proxy.setUserPasswd(_user, _pass);
                }
            } else if (_type.equals("SOCKS5")) {
                proxy = new ProxySOCKS5(proxyhost);
                if (useAuth) {
                    ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
                }
            }
        }
        return proxy;
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        SshConnectorService.loadSshPrefs(jsch);
        String host = this.getHostName();
        String user = this.getUserId();
        Proxy proxy = SshConnectorService.loadSshProxyPrefs();
        this.session = jsch.getSession(user, host, 22);
        if (proxy != null) {
            this.session.setProxy(proxy);
        }
        this.session.setTimeout(0);
        String password = "";
        SystemSignonInformation ssi = this.getPasswordInformation();
        if (ssi != null) {
            password = this.getPasswordInformation().getPassword();
        }
        this.session.setPassword(password);
        MyUserInfo userInfo = new MyUserInfo(user, password);
        this.session.setUserInfo((UserInfo)userInfo);
        this.session.setSocketFactory((SocketFactory)new ResponsiveSocketFactory(monitor));
        userInfo.aboutToConnect();
        try {
            Activator.trace("SshConnectorService.connecting...");
            this.session.connect(60000);
            Activator.trace("SshConnectorService.connected");
        }
        catch (JSchException e) {
            Activator.trace("SshConnectorService.connect failed: " + e.toString());
            if (this.session.isConnected()) {
                this.session.disconnect();
            }
            throw e;
        }
        userInfo.connectionMade();
        this.fSessionLostHandler = new SessionLostHandler((IConnectorService)this);
        this.notifyConnection();
    }

    public void internalDisconnect(IProgressMonitor monitor) throws Exception {
        Activator.trace("SshConnectorService.disconnect");
        try {
            if (this.session != null) {
                boolean sessionLost = this.fSessionLostHandler != null && this.fSessionLostHandler.isSessionLost();
                this.fSessionLostHandler = null;
                if (sessionLost) {
                    this.notifyError();
                } else {
                    this.fireCommunicationsEvent(3);
                }
                if (this.session.isConnected()) {
                    this.session.disconnect();
                }
                this.notifyDisconnection();
                this.clearPasswordCache(false);
            }
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void handleSessionLost() {
        Activator.trace("SshConnectorService: handleSessionLost");
        if (this.fSessionLostHandler != null) {
            this.fSessionLostHandler.sessionLost();
        }
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public boolean isConnected() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                return true;
            }
            if (this.fSessionLostHandler != null) {
                Activator.trace("SshConnectorService.isConnected: false -> sessionLost");
                this.fSessionLostHandler.sessionLost();
            }
        }
        return false;
    }

    public boolean hasRemoteServerLauncherProperties() {
        return false;
    }

    public boolean supportsRemoteServerLaunching() {
        return false;
    }

    public boolean supportsServerLaunchProperties() {
        return false;
    }

    public boolean requiresPassword() {
        return false;
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String fPassphrase;
        private String fPassword;
        private int fAttemptCount;
        private final String fUser;

        public MyUserInfo(String user, String password) {
            this.fUser = user;
            this.fPassword = password;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public boolean promptYesNo(String str) {
            boolean[] retval = new boolean[1];
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, retval, str){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ boolean[] val$retval;
                private final /* synthetic */ String val$str;
                {
                    this.this$1 = myUserInfo;
                    this.val$retval = blArray;
                    this.val$str = string;
                }

                public void run() {
                    this.val$retval[0] = MessageDialog.openQuestion(null, (String)SshConnectorResources.SshConnectorService_Warning, (String)this.val$str);
                }
            });
            return retval[0];
        }

        private String promptSecret(String message) {
            String[] retval = new String[1];
            String finUser = this.fUser;
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, finUser, message, retval){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$finUser;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String[] val$retval;
                {
                    this.this$1 = myUserInfo;
                    this.val$finUser = string;
                    this.val$message = string2;
                    this.val$retval = stringArray;
                }

                public void run() {
                    UserValidationDialog uvd = new UserValidationDialog(null, null, this.val$finUser, this.val$message);
                    uvd.setUsernameMutable(false);
                    this.val$retval[0] = uvd.open() == 0 ? uvd.getPassword() : null;
                }
            });
            return retval[0];
        }

        public String getPassphrase() {
            return this.fPassphrase;
        }

        public boolean promptPassphrase(String message) {
            this.fPassphrase = this.promptSecret(message);
            return this.fPassphrase != null;
        }

        public boolean promptPassword(String message) {
            String _password = this.promptSecret(message);
            if (_password != null) {
                this.fPassword = _password;
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, message){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$message;
                {
                    this.this$1 = myUserInfo;
                    this.val$message = string;
                }

                public void run() {
                    MessageDialog.openInformation(null, (String)SshConnectorResources.SshConnectorService_Info, (String)this.val$message);
                }
            });
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] result;
            block6: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                try {
                    if (this.fAttemptCount == 0 && this.fPassword != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                        ++this.fAttemptCount;
                        return new String[]{this.fPassword};
                    }
                    String[][] finResult = new String[1][];
                    SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, destination, name, instruction, prompt, echo, finResult){
                        final /* synthetic */ MyUserInfo this$1;
                        private final /* synthetic */ String val$destination;
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ String val$instruction;
                        private final /* synthetic */ String[] val$prompt;
                        private final /* synthetic */ boolean[] val$echo;
                        private final /* synthetic */ String[][] val$finResult;
                        {
                            this.this$1 = myUserInfo;
                            this.val$destination = string;
                            this.val$name = string2;
                            this.val$instruction = string3;
                            this.val$prompt = stringArray;
                            this.val$echo = blArray;
                            this.val$finResult = stringArray2;
                        }

                        public void run() {
                            KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, null, this.val$destination, this.val$name, this.val$instruction, this.val$prompt, this.val$echo);
                            dialog.open();
                            this.val$finResult[0] = dialog.getResult();
                        }
                    });
                    result = finResult[0];
                    if (result != null) break block6;
                    return null;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return null;
                }
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.fPassword = result[0];
            }
            ++this.fAttemptCount;
            return result;
        }

        public void aboutToConnect() {
            this.fAttemptCount = 0;
        }

        public void connectionMade() {
            this.fAttemptCount = 0;
        }
    }

    public static class ResponsiveSocketFactory
    extends SimpleSocketFactory {
        private IProgressMonitor monitor;

        public ResponsiveSocketFactory(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = SshConnectorService.createSocket(host, port, 60, this.monitor);
            this.monitor = new NullProgressMonitor();
            socket.setSoTimeout(0);
            return socket;
        }
    }

    public static class SessionLostHandler
    implements Runnable,
    IRunnableWithProgress {
        private IConnectorService _connection;
        private boolean fSessionLost;

        public SessionLostHandler(IConnectorService cs) {
            this._connection = cs;
            this.fSessionLost = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionLost() {
            boolean showSessionLostDlg = false;
            SessionLostHandler sessionLostHandler = this;
            synchronized (sessionLostHandler) {
                if (!this.fSessionLost) {
                    this.fSessionLost = true;
                    showSessionLostDlg = true;
                }
            }
            if (showSessionLostDlg) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }

        public synchronized boolean isSessionLost() {
            return this.fSessionLost;
        }

        public void run() {
            Shell shell = this.getShell();
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1058");
            msg.makeSubstitution((Object)this._connection.getPrimarySubSystem().getHost().getAliasName());
            SystemMessageDialog dialog = new SystemMessageDialog(this.getShell(), msg);
            dialog.open();
            try {
                IRunnableContext runnableContext = this.getRunnableContext(this.getShell());
                runnableContext.run(true, true, (IRunnableWithProgress)this);
                this._connection.reset();
                SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
                sr.connectedStatusChange(this._connection.getPrimarySubSystem(), false, true, true);
            }
            catch (InterruptedException interruptedException) {
                if (shell != null) {
                    this.showDisconnectCancelledMessage(shell, this._connection.getHostName(), this._connection.getPort());
                }
            }
            catch (InvocationTargetException invokeExc) {
                Exception exc = (Exception)invokeExc.getTargetException();
                if (shell != null) {
                    this.showDisconnectErrorMessage(shell, this._connection.getHostName(), this._connection.getPort(), exc);
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)SshConnectorResources.SshConnectorService_ErrorDisconnecting, (Throwable)e);
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            String message = null;
            message = SubSystemConfiguration.getDisconnectingMessage((String)this._connection.getHostName(), (int)this._connection.getPort());
            monitor.beginTask(message, -1);
            try {
                try {
                    this._connection.disconnect(monitor);
                }
                catch (Exception exc) {
                    if (exc instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exc;
                    }
                    if (exc instanceof InterruptedException) {
                        throw (InterruptedException)exc;
                    }
                    throw new InvocationTargetException(exc);
                }
            }
            finally {
                monitor.done();
            }
        }

        public Shell getShell() {
            Shell activeShell = SystemBasePlugin.getActiveWorkbenchShell();
            if (activeShell != null) {
                return activeShell;
            }
            IWorkbenchWindow window = null;
            try {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            catch (Exception exception) {
                return null;
            }
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows != null && windows.length > 0) {
                    return windows[0].getShell();
                }
            } else {
                return window.getShell();
            }
            return null;
        }

        protected IRunnableContext getRunnableContext(Shell rshell) {
            Shell shell = this.getShell();
            IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
            if (win != null) {
                Shell winShell = RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                if (winShell != null && !winShell.isDisposed() && winShell.isVisible()) {
                    SystemBasePlugin.logInfo((String)"Using active workbench window as runnable context");
                    shell = winShell;
                    return win;
                }
                win = null;
            }
            if (shell == null || shell.isDisposed() || !shell.isVisible()) {
                SystemBasePlugin.logInfo((String)"Using progress monitor dialog with given shell as parent");
                shell = rshell;
            }
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(rshell);
            return dlg;
        }

        protected void showDisconnectErrorMessage(Shell shell, String hostName, int port, Exception exc) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage((String)"RSEG1061").makeSubstitution((Object)hostName, (Object)exc));
            msgDlg.setException((Throwable)exc);
            msgDlg.open();
        }

        protected void showDisconnectCancelledMessage(Shell shell, String hostName, int port) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage((String)"RSEG1062").makeSubstitution((Object)hostName));
            msgDlg.open();
        }
    }

    public static class SimpleSocketFactory
    implements SocketFactory {
        InputStream in = null;
        OutputStream out = null;

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = new Socket(host, port);
            return socket;
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            if (this.in == null) {
                this.in = socket.getInputStream();
            }
            return this.in;
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            if (this.out == null) {
                this.out = socket.getOutputStream();
            }
            return this.out;
        }
    }
}

