/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.files.ui.resources.ISystemRemoteEditConstants;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.files.ui.view.DownloadJob;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Shell;

public class SystemEditFileAction
extends SystemBaseAction
implements ISystemRemoteEditConstants {
    protected String _editorId;

    public SystemEditFileAction(String text, String tooltip, ImageDescriptor image, Shell parent, String editorId) {
        super(text, tooltip, null, image, parent);
        this.init();
        this._editorId = editorId;
    }

    public SystemEditFileAction(String text, String tooltip, ImageDescriptor image, int style, Shell parent, String editorId) {
        super(text, tooltip, null, image, style, parent);
        this.init();
        this._editorId = editorId;
    }

    private void init() {
        this.allowOnMultipleSelection(false);
    }

    public void run() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object element = this.getFirstSelection();
        if (element == null) {
            return;
        }
        if (!(element instanceof IRemoteFile)) {
            return;
        }
        this.process((IRemoteFile)element);
    }

    private boolean isFileCached(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (!newFile && file.exists()) {
            boolean remoteNewer;
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            try {
                remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath());
            }
            catch (Exception exception) {}
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean bl2 = remoteNewer = storedModifiedStamp != remoteModifiedStamp;
            return !dirty && !remoteNewer;
        }
        return false;
    }

    protected void process(IRemoteFile remoteFile) {
        SystemEditableRemoteFile editable = new SystemEditableRemoteFile(remoteFile, this._editorId);
        if (editable != null) {
            try {
                if (editable.checkOpenInEditor() != 0) {
                    if (this.isFileCached(editable, remoteFile)) {
                        editable.openEditor();
                    } else {
                        DownloadJob oJob = new DownloadJob(editable, false);
                        oJob.schedule();
                    }
                } else {
                    editable.setLocalResourceProperties();
                    editable.openEditor();
                }
            }
            catch (Exception exception) {}
        }
    }
}

