/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.actions.SystemCopyRemoteFileAction;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemMoveRemoteFileAction
extends SystemCopyRemoteFileAction
implements IValidatorRemoteSelection {
    private SystemMessage targetEqualsSrcMsg = null;
    private SystemMessage targetDescendsFromSrcMsg = null;
    protected Vector movedFiles = new Vector();

    public SystemMoveRemoteFileAction(Shell shell) {
        super(shell, 1);
        this.setHelp("org.eclipse.rse.ui.actn0111");
        this.setDialogHelp("org.eclipse.rse.ui.dmrf0000");
    }

    protected void reset() {
        this.movedFiles.clear();
        super.reset();
    }

    protected boolean doCopy(IProgressMonitor monitor, Object targetContainer, Object oldObject, String newName) throws Exception {
        IRemoteFile targetFolder = (IRemoteFile)targetContainer;
        IRemoteFile srcFileOrFolder = (IRemoteFile)oldObject;
        IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
        boolean ok = false;
        ok = ss.move(srcFileOrFolder, targetFolder, newName, monitor);
        if (!ok) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF1307");
            msg.makeSubstitution((Object)srcFileOrFolder.getName());
            throw new SystemMessageException(msg);
        }
        String sep = targetFolder.getSeparator();
        String targetFolderName = targetFolder.getAbsolutePath();
        String resultPath = null;
        resultPath = !targetFolderName.endsWith(sep) ? String.valueOf(targetFolderName) + sep + newName : String.valueOf(targetFolderName) + newName;
        this.copiedFiles.addElement(resultPath);
        this.movedFiles.add(srcFileOrFolder);
        return ok;
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        Object selectedObject = selectedObjects[0];
        if (!(selectedObject instanceof IRemoteFile)) {
            return null;
        }
        IRemoteFile selectedFolder = (IRemoteFile)selectedObject;
        if (selectedFolder.getAbsolutePath().equals(this.firstSelectionParent.getAbsolutePath())) {
            if (this.targetEqualsSrcMsg == null) {
                this.targetEqualsSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1308");
            }
            return this.targetEqualsSrcMsg;
        }
        if (selectedFolder.getAbsolutePath().equals(this.firstSelection.getAbsolutePath())) {
            if (this.targetEqualsSrcMsg == null) {
                this.targetEqualsSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1308");
            }
            return this.targetEqualsSrcMsg;
        }
        if (selectedFolder.isDescendantOf(this.firstSelection)) {
            if (this.targetDescendsFromSrcMsg == null) {
                this.targetDescendsFromSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1312");
            }
            return this.targetDescendsFromSrcMsg;
        }
        return null;
    }

    public void copyComplete() {
        IRemoteFileSubSystem fileSS = this.targetFolder.getParentRemoteFileSubSystem();
        RSEUIPlugin.getTheSystemRegistry().fireRemoteResourceChangeEvent(2, (Object)this.movedFiles, (Object)this.firstSelectionParent.getAbsolutePath(), (ISubSystem)fileSS, null, null);
        super.copyComplete();
    }
}

