/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class SystemTempFileListener
implements IResourceChangeListener {
    private ArrayList _changedResources;
    private ArrayList _ignoredFiles = new ArrayList();
    private boolean _isSynching = false;
    private boolean _isEnabled = true;

    public SystemTempFileListener() {
        this._changedResources = new ArrayList();
    }

    public void setEnabled(boolean flag) {
        this._isEnabled = flag;
    }

    public void addIgnoreFile(IFile toIgnore) {
        this._ignoredFiles.add(toIgnore);
    }

    public void removeIgnoreFile(IFile toNotIgnore) {
        this._ignoredFiles.remove(toNotIgnore);
    }

    public boolean isIgnorable(IFile file) {
        if (this._ignoredFiles.contains(file)) {
            return true;
        }
        String path = file.getLocation().toString().toLowerCase();
        int i = 0;
        while (i < this._ignoredFiles.size()) {
            IFile cfile = (IFile)this._ignoredFiles.get(i);
            String cpath = cfile.getLocation().toString().toLowerCase();
            if (path.equals(cpath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this._isEnabled) {
            event.getSource();
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                if (this.preScanForTempFiles(delta)) {
                    this.processDelta(delta);
                    if (this._changedResources.size() > 0 && !this._isSynching) {
                        this.refreshRemoteResourcesOnUIThread();
                    }
                } else if (!RSEUIPlugin.getThePersistenceManager().isExporting()) {
                    ArrayList changes = new ArrayList();
                    this.checkLocalChanges(delta, changes);
                    this.refreshRemoteResourcesOnMainThread(changes);
                }
            }
        }
    }

    private void refreshRemoteResourcesOnMainThread(List resources) {
        RefreshResourcesJob job = new RefreshResourcesJob(resources);
        job.setPriority(10);
        job.schedule();
    }

    private void refreshRemoteResourcesOnUIThread() {
        RefreshResourcesUIJob job = new RefreshResourcesUIJob();
        job.setPriority(10);
        job.schedule();
    }

    protected void checkLocalChanges(IResourceDelta delta, List changes) {
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            boolean noChange;
            IResourceDelta child = children[i];
            int kind = child.getKind();
            boolean bl = noChange = kind == 0;
            if (noChange) {
                return;
            }
            boolean isChanged = kind == 4;
            boolean isDeleted = kind == 2;
            boolean isAdded = kind == 1;
            boolean isMovedTo = kind == 8192;
            boolean isMovedFrom = kind == 4096;
            IResource resource = child.getResource();
            String pathOfChild = null;
            String pathOfParent = null;
            IPath location = resource.getLocation();
            if (location == null) {
                String projectPath = child.getFullPath().toOSString();
                String workspacePath = SystemBasePlugin.getWorkspaceRoot().getLocation().toOSString();
                pathOfChild = String.valueOf(workspacePath) + projectPath;
                pathOfParent = new File(pathOfChild).getParent();
            } else {
                pathOfChild = resource.getLocation().toOSString();
                pathOfParent = resource.getParent().getLocation().toOSString();
            }
            if (isChanged) {
                this.checkLocalChanges(child, changes);
            } else {
                IRemoteFile cachedParent;
                RemoteFileSubSystem fs = (RemoteFileSubSystem)this.getLocalFileSubSystem();
                if (fs == null) {
                    return;
                }
                IRemoteFile remoteFile = fs.getCachedRemoteFile(pathOfChild);
                if (remoteFile != null) {
                    remoteFile.markStale(true);
                }
                if ((cachedParent = fs.getCachedRemoteFile(pathOfParent)) == null) {
                    return;
                }
                cachedParent.markStale(true);
                if (!changes.contains(cachedParent)) {
                    changes.add(cachedParent);
                }
                if (isDeleted || isAdded || !isMovedTo) {
                    // empty if block
                }
            }
            ++i;
        }
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
        if (win != null) {
            Shell winShell = SystemBasePlugin.getActiveWorkbenchShell();
            if (winShell != null && !winShell.isDisposed() && winShell.isVisible()) {
                shell = winShell;
                return win;
            }
            win = null;
        }
        return new ProgressMonitorDialog(shell);
    }

    protected void processDelta(IResourceDelta delta) {
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            IResourceDelta child = children[i];
            IResource resource = child.getResource();
            if (resource instanceof IFile) {
                ISubSystem ss;
                String ssStr;
                long t2;
                SystemIFileProperties properties;
                long t1;
                boolean contentChanged;
                resource.getLocation().toString();
                int ckind = child.getKind();
                boolean isChanged = ckind == 4;
                int flags = child.getFlags();
                boolean bl = contentChanged = isChanged && (flags & 0x100) != 0;
                if (contentChanged && !this._changedResources.contains(resource) && !this.isIgnorable((IFile)resource) && (t1 = (properties = new SystemIFileProperties(resource)).getDownloadFileTimeStamp()) != (t2 = resource.getLocation().toFile().lastModified()) && (ssStr = properties.getRemoteFileSubSystem()) != null && this.doesHandle(ss = RSEUIPlugin.getTheSystemRegistry().getSubSystem(ssStr))) {
                    this._changedResources.add(resource);
                }
            } else {
                this.processDelta(child);
            }
            ++i;
        }
    }

    protected void synchronizeTempWithRemote(IFile file, IProgressMonitor monitor) {
        IPath path = file.getFullPath();
        int numSegments = path.segmentCount();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        if (properties.getRemoteFileTimeStamp() == 0L) {
            return;
        }
        ISubSystem fs = null;
        String subsystemId = properties.getRemoteFileSubSystem();
        if (subsystemId != null) {
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            fs = registry.getSubSystem(subsystemId);
        }
        if (fs != null) {
            String uploadPath = properties.getRemoteFilePath();
            if (uploadPath == null) {
                IHost connection = fs.getHost();
                boolean isWindows = connection.getSystemType().equals("Local") || fs.getHost().getSystemType().equals("Windows");
                char fileSeparator = isWindows ? (char)'\\' : '/';
                StringBuffer remotePath = new StringBuffer("");
                int i = 3;
                while (i < numSegments) {
                    if (i == 3 && !isWindows) {
                        remotePath.append(fileSeparator);
                    }
                    if (i > 3) {
                        if (i == 4 && isWindows) {
                            remotePath.append(":");
                        }
                        remotePath.append(fileSeparator);
                    }
                    String seg = path.segment(i);
                    remotePath.append(seg);
                    ++i;
                }
                uploadPath = remotePath.toString();
            }
            if (this.doesHandle(fs)) {
                try {
                    if (!fs.isConnected()) {
                        fs.connect();
                    }
                }
                catch (Exception exception) {
                    properties.setDirty(true);
                    return;
                }
                this.doResourceSynchronization(fs, file, uploadPath, monitor);
            }
        }
    }

    protected void refreshRemoteResource(Object parent) {
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        if (parent != null) {
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(parent, 82, null));
            List filterReferences = registry.findFilterReferencesFor(parent, (ISubSystem)this.getLocalFileSubSystem());
            int i = 0;
            while (i < filterReferences.size()) {
                ISystemFilterReference filterRef = (ISystemFilterReference)filterReferences.get(i);
                filterRef.markStale(true);
                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)filterRef, 82, null));
                ++i;
            }
        }
    }

    protected abstract void doResourceSynchronization(ISubSystem var1, IFile var2, String var3, IProgressMonitor var4);

    protected abstract boolean doesHandle(ISubSystem var1);

    private IRemoteFileSubSystem getLocalFileSubSystem() {
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        IHost con = registry.getLocalHost();
        if (con != null) {
            return RemoteFileUtility.getFileSubSystem((IHost)con);
        }
        return null;
    }

    protected boolean preScanForTempFiles(IResourceDelta delta) {
        IResource resource;
        if (delta == null) {
            return true;
        }
        if (!SystemRemoteEditManager.getDefault().doesRemoteEditProjectExist()) {
            return false;
        }
        IResourceDelta[] subdeltas = delta.getAffectedChildren();
        return subdeltas.length > 0 && (resource = subdeltas[0].getResource()) != null && resource.getType() == 4 && resource.getName().equals("RemoteSystemsTempFiles");
    }

    public class RefreshResourcesJob
    extends UIJob {
        private List _resources;

        public RefreshResourcesJob(List resources) {
            super(FileResources.RSEOperation_message);
            this._resources = resources;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1282");
            monitor.beginTask(msg.getLevelOneText(), this._resources.size());
            int i = 0;
            while (i < this._resources.size()) {
                Object resource = this._resources.get(i);
                SystemTempFileListener.this.refreshRemoteResource(resource);
                monitor.worked(1);
                ++i;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    public class RefreshResourcesUIJob
    extends WorkbenchJob {
        public RefreshResourcesUIJob() {
            super(FileResources.RSEOperation_message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemTempFileListener.this._isSynching = true;
            ArrayList arrayList = SystemTempFileListener.this._changedResources;
            synchronized (arrayList) {
                SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1282");
                monitor.beginTask(msg.getLevelOneText(), -1);
                this.setName(msg.getLevelOneText());
                int i = 0;
                while (i < SystemTempFileListener.this._changedResources.size()) {
                    IFile file = (IFile)SystemTempFileListener.this._changedResources.get(i);
                    SystemTempFileListener.this.synchronizeTempWithRemote(file, monitor);
                    ++i;
                }
                monitor.done();
                SystemTempFileListener.this._changedResources.clear();
            }
            SystemTempFileListener.this._isSynching = false;
            return Status.OK_STATUS;
        }
    }
}

