/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging.performance;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PerformanceLogger {
    public static final int OPTION_GET_ALL = 1;
    public static final int OPTION_GET_FEATURE = 2;
    public static final int OPTION_GET_VERSION = 3;
    private static final Object[] EMPTY = new Object[0];
    private static final String ELEMENT_TASK = "Task";
    private static final String ATTRIBUTE_NAME_TASKID = "CallerID";
    private static final String DEFAULT_COMPONENT = "_PERFORMANCELOGGER_";
    private static boolean ENABLE_PERFORMANCE_LOGGING = false;
    private static long samplingTime = -1L;
    private static boolean _initialized = false;
    private static HashMap perfLogRegistry = new HashMap();

    static {
        PerformanceLogger.normalize();
    }

    private static void printMessage(String message, Object[] data) {
        System.out.println(MessageFormat.format(message, data));
    }

    private static void printMessage(String message, Object value) {
        PerformanceLogger.printMessage(message, new Object[]{value});
    }

    private static void printMessage(String message) {
        PerformanceLogger.printMessage(message, EMPTY);
    }

    public static void enablePerformanceLogging(boolean enable) {
        ENABLE_PERFORMANCE_LOGGING = enable;
    }

    public static boolean isPerformanceLoggingEnabled() {
        return ENABLE_PERFORMANCE_LOGGING;
    }

    public static String register(String comp_id) {
        return PerformanceLogger.register(comp_id, "", "");
    }

    public static String register(String feature, String version) {
        return PerformanceLogger.register(DEFAULT_COMPONENT, feature, version);
    }

    public static String register(String comp_id, String feature, String version) {
        if (comp_id == null || comp_id.length() == 0) {
            PerformanceLogger.printMessage("PerformanceLogger:register(): Cannot register null or empty component id.");
            return comp_id;
        }
        if (perfLogRegistry.containsKey(comp_id)) {
            PerformanceLogger.printMessage("PerformanceLogger:register(): component {0} already registered", comp_id);
            return comp_id;
        }
        PerformanceLogger performanceLogger = new PerformanceLogger();
        performanceLogger.getClass();
        ComponentData compData = performanceLogger.new ComponentData(comp_id);
        Calendar time = Calendar.getInstance();
        compData.timeStamp = time.getTime().toString();
        String userID = System.getProperty("user.name");
        String idTemplate = "{0}_{1}_{2}_{3}_perf.{4}.xml";
        String id = MessageFormat.format(idTemplate, comp_id, userID, feature, version, compData.timeStamp);
        compData.XMLFileID = id.replace(' ', '_').replace(':', '_');
        compData.XMLFile = new File(compData.XMLFileID);
        compData.feature = feature;
        compData.version = version;
        PerformanceLogger.generateXMLFile(compData);
        compData.taskStack = new Stack();
        perfLogRegistry.put(comp_id, compData);
        _initialized = true;
        PerformanceLogger.printMessage("PerformanceLogger: XML file created is {0}.", compData.XMLFile.getAbsolutePath());
        return comp_id;
    }

    public static void deRegister() {
        perfLogRegistry.remove(DEFAULT_COMPONENT);
        PerformanceLogger.printMessage("SystemPerformanceLogger: default component de-registered");
    }

    public static void deRegister(String key) {
        perfLogRegistry.remove(key);
        PerformanceLogger.printMessage("SystemPerformanceLogger: component {0} de-registered", key);
    }

    public static String normalize() {
        long startTime = System.currentTimeMillis();
        Double q = new Double(0.0);
        int i = 0;
        int n = 1000000;
        i = 0;
        while (i < n) {
            Double dd = new Double(n);
            Double dr = new Double(n + i);
            q = new Double(dd / dr);
            ++i;
        }
        double val = q / (double)i;
        long stopTime = System.currentTimeMillis();
        samplingTime = stopTime - startTime;
        String template = "SystemPerformanceLogger::Normalization Elapsed time = {0} {1}";
        String result = MessageFormat.format(template, new Long(samplingTime), new Double(val));
        return result;
    }

    public static long start() {
        if (!_initialized) {
            PerformanceLogger.register(DEFAULT_COMPONENT, "", "");
        }
        String methodPath = PerformanceLogger.getMethodName(true);
        return PerformanceLogger.start(DEFAULT_COMPONENT, methodPath);
    }

    public static long start(String comp_id) {
        String methodPath = PerformanceLogger.getMethodName(true);
        return PerformanceLogger.start(comp_id, methodPath);
    }

    public static long start(String comp_id, String call_id) {
        if (!perfLogRegistry.containsKey(comp_id)) {
            PerformanceLogger.printMessage("PerformanceLogger:start(): component {0} not registered", comp_id);
            return -1L;
        }
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        StartData td = new StartData();
        td.userID = call_id;
        td.startThread = Thread.currentThread().toString();
        td.startMethod = PerformanceLogger.getMethodName(false);
        try {
            Element root = cd.doc.getDocumentElement();
            Element task = cd.doc.createElement(ELEMENT_TASK);
            task.setAttribute(ATTRIBUTE_NAME_TASKID, td.userID);
            task.setAttribute("StartAt", td.startMethod);
            task.setAttribute("StartThread", td.startThread);
            td.node = task;
            if (cd.taskStack.isEmpty()) {
                root.appendChild(task);
            } else {
                StartData sd = (StartData)cd.taskStack.peek();
                sd.node.appendChild(task);
            }
        }
        catch (DOMException e) {
            PerformanceLogger.printMessage("PerformanceLogger::updateXMLFileatStart DOM Error: {0}", e);
        }
        td.startTime = System.currentTimeMillis();
        cd.taskStack.push(td);
        return td.startTime;
    }

    public static long stop() {
        return PerformanceLogger.stop(DEFAULT_COMPONENT);
    }

    public static long stop(String comp_id) {
        long st = System.currentTimeMillis();
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        if (cd == null) {
            PerformanceLogger.printMessage("SystemPerformanceLogger::stop(): invalid registration key");
            return 0L;
        }
        long result = 0L;
        try {
            StartData td = (StartData)cd.taskStack.pop();
            td.stopTime = st;
            td.stopThread = Thread.currentThread().toString();
            td.stopMethod = PerformanceLogger.getMethodName(false);
            PerformanceLogger.updateXMLFileAtStop(cd, td);
            result = td.stopTime;
        }
        catch (EmptyStackException e) {
            PerformanceLogger.printMessage("SystemPerformanceLogger:: Probably too many stop() function calls. - {0}", e);
        }
        return result;
    }

    private static void generateXMLFile(ComponentData cd) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cd.XMLFile), "UTF8"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            cd.doc = impl.createDocument(null, "Benchmark", null);
            Element root = cd.doc.getDocumentElement();
            root.setAttribute("BenchmarkID", cd.XMLFileID);
            root.setAttribute("TimeStamp", cd.timeStamp);
            Element system = cd.doc.createElement("System");
            Element product = cd.doc.createElement("Product");
            product.setAttribute("Feature", cd.feature);
            product.setAttribute("Version", cd.version);
            root.appendChild(product);
            system.setAttribute("OSName", System.getProperty("os.name"));
            system.setAttribute("OSVersion", System.getProperty("os.version"));
            system.setAttribute("JavaVersion", System.getProperty("java.version"));
            system.setAttribute("JavaVMVersion", System.getProperty("java.vm.version"));
            system.setAttribute("JavaClassPath", System.getProperty("java.class.path"));
            system.setAttribute("JavaLibraryPath", System.getProperty("java.library.path"));
            root.appendChild(system);
            Element norm = cd.doc.createElement("_NORMALIZATION_VALUES");
            Long ems = new Long(samplingTime);
            norm.setAttribute("ElapsedTime", ems.toString());
            root.appendChild(norm);
            Comment cmt1 = cd.doc.createComment("Each Task element represents one start/stop timer operation");
            Comment cmt2 = cd.doc.createComment("Time recorded is in milliseconds");
            Comment cmt3 = cd.doc.createComment("NormalizedFactor is the performance indicator. A larger value than the previous run might indicate performance degradation.");
            root.appendChild(cmt1);
            root.appendChild(cmt2);
            root.appendChild(cmt3);
            try {
                DOMSource source = new DOMSource(cd.doc);
                StreamResult result = new StreamResult(writer);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.transform(source, result);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            }
            catch (TransformerException transformerException) {}
        }
        catch (IOException e) {
            PerformanceLogger.printMessage("PerformanceLogger::updateXML IO Error: {0}", e);
        }
        catch (ParserConfigurationException e) {
            PerformanceLogger.printMessage("PerformanceLogger::updateXML Parser Configuration Error: {0}", e);
        }
        catch (DOMException e) {
            PerformanceLogger.printMessage("PerformanceLogger::updateXML DOM Error: {0}", e);
        }
    }

    private static void updateXMLFileAtStop(ComponentData cd, StartData td) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cd.XMLFile), "UTF8"));
            cd.doc.getDocumentElement();
            Element task = td.node;
            Long ems = new Long(td.stopTime - td.startTime);
            Long sms = new Long(td.startTime);
            Long tms = new Long(td.stopTime);
            String normalizedFactor = "invalid";
            if (samplingTime > 0L) {
                Long sam = new Long(samplingTime);
                Double val = new Double(ems.doubleValue() / sam.doubleValue());
                normalizedFactor = val.toString();
            }
            task.setAttribute("ElapsedTime", ems.toString());
            task.setAttribute("NormalizedFactor", normalizedFactor);
            task.setAttribute("StartTime", sms.toString());
            task.setAttribute("StopTime", tms.toString());
            task.setAttribute("StartAt", td.startMethod);
            task.setAttribute("StartThread", td.startThread);
            task.setAttribute("StopAt", td.stopMethod);
            task.setAttribute("StopThread", td.stopThread);
            try {
                DOMSource source = new DOMSource(cd.doc);
                StreamResult result = new StreamResult(writer);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.transform(source, result);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            }
            catch (TransformerException transformerException) {}
        }
        catch (IOException e) {
            PerformanceLogger.printMessage("PerformanceLogger::updateXMLFileAtStop IO Error: {0}", e);
        }
        catch (DOMException e) {
            PerformanceLogger.printMessage("PerformanceLogger::updateXMLFileAtStop DOM Error: {0}", e);
        }
    }

    public static String getCurrentProductInfo(int req, String comp_id) {
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        if (cd == null) {
            PerformanceLogger.printMessage("PerformanceLogger::getCurrentProductInfo invalid comp_id");
            return null;
        }
        if (req == 2) {
            return cd.feature;
        }
        if (req == 3) {
            return cd.version;
        }
        return null;
    }

    public static String getXMLFileName(String comp_id) {
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        return cd.XMLFile.getAbsolutePath();
    }

    private static String getMethodName(boolean parsed) {
        String methodPath = null;
        Throwable e = new Throwable();
        StringWriter strwriter = new StringWriter(100);
        e.printStackTrace(new PrintWriter(strwriter));
        String stack = strwriter.toString();
        StringTokenizer tokenizer = new StringTokenizer(stack, "\r\n");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            methodPath = tokenizer.nextToken();
            if (methodPath.indexOf("java.lang.Throwable") == -1 && methodPath.indexOf("logging.performance.PerformanceLogger") == -1) break;
            ++i;
        }
        if (methodPath != null) {
            methodPath = methodPath.substring(4);
            if (parsed) {
                try {
                    i = methodPath.indexOf(40);
                    if (i != -1) {
                        methodPath = methodPath.substring(0, i);
                    }
                    i = methodPath.lastIndexOf(46);
                    String methodName = methodPath.substring(i + 1);
                    String className = methodPath.substring(0, i);
                    if ((i = className.lastIndexOf(46)) != -1) {
                        className = className.substring(i + 1);
                    }
                    methodPath = String.valueOf(className) + "." + methodName;
                }
                catch (IndexOutOfBoundsException ex) {
                    PerformanceLogger.printMessage("PerformanceLogger:getMethodName exception {0}", ex);
                }
            }
        }
        return methodPath;
    }

    public static void listSystemProfile() {
        System.out.println("java version : " + System.getProperty("java.version"));
        System.out.println("OS name : " + System.getProperty("os.name"));
        System.out.println("OS version : " + System.getProperty("os.version"));
        System.out.println("working dir : " + System.getProperty("user.dir"));
        System.out.println("home dir : " + System.getProperty("home.dir"));
    }

    public static void main(String[] args) {
        int i = 0;
        if (PerformanceLogger.isPerformanceLoggingEnabled()) {
            PerformanceLogger.start();
        }
        i = 0;
        while (i < 1000000) {
            ++i;
        }
        if (PerformanceLogger.isPerformanceLoggingEnabled()) {
            PerformanceLogger.stop();
        }
        PerformanceLogger.enablePerformanceLogging(true);
        String key = PerformanceLogger.register("", "WDSC", "5120");
        key = PerformanceLogger.register("RSE", "WDSC", "5120");
        PerformanceLogger.deRegister("XXX");
        System.out.println("Product info : " + PerformanceLogger.getCurrentProductInfo(2, key) + " " + PerformanceLogger.getCurrentProductInfo(3, key));
        PerformanceLogger.start(key, "NOT_NESTED_1");
        i = 0;
        while (i < 1000000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.start(key, "NESTED_ONE");
        i = 0;
        while (i < 500) {
            ++i;
        }
        PerformanceLogger.start(key, "NESTED_ONE_CHILD");
        i = 0;
        while (i < 300) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.start(key, "NOT_NESTED_2");
        i = 0;
        while (i < 2000000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.start(key, "NESTED_THREE");
        i = 0;
        while (i < 300) {
            ++i;
        }
        PerformanceLogger.start(key, "NESTED_TWO_CHILD1");
        PerformanceLogger.start(key, "NESTED_TWO_CHILD2");
        i = 0;
        while (i < 4000) {
            ++i;
        }
        PerformanceLogger.start(key, "NESTED_TWO_CHILD3");
        i = 0;
        while (i < 6000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.start("ABC");
        PerformanceLogger.start(key);
        i = 0;
        while (i < 3000000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        key = PerformanceLogger.register(key);
        PerformanceLogger.deRegister(key);
        key = PerformanceLogger.register(key);
    }

    class ComponentData {
        String component = null;
        String timeStamp = null;
        String feature = null;
        String version = null;
        String XMLFileID = null;
        File XMLFile = null;
        Document doc = null;
        Stack taskStack = new Stack();

        ComponentData(String comp_id) {
            this.component = comp_id;
        }
    }

    static class StartData {
        long startTime = -1L;
        long stopTime = -1L;
        String userID = null;
        String startThread = null;
        String startMethod = null;
        String stopThread = null;
        String stopMethod = null;
        Element node = null;

        StartData() {
        }
    }
}

