/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemSorter;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeMapping;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.model.SystemFileTransferModeMapping;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.Workbench;

public class SystemFileTransferModeRegistry
implements ISystemFileTransferModeRegistry,
IPropertyListener {
    private static SystemFileTransferModeRegistry instance;
    private HashMap typeModeMappings;
    private RSEUIPlugin plugin = RSEUIPlugin.getDefault();
    private static final String FILENAME = "fileTransferMode.xml";
    private static final String ENCODING;
    private static final String ROOT_NODE = "mode";
    private static final String INFO_NODE = "info";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String EXTENSION_ATTRIBUTE = "extension";
    private static final String MODE_ATTRIBUTE = "mode";
    private static final String BINARY_VALUE = "binary";
    private static final String TEXT_VALUE = "text";

    static {
        ENCODING = SystemEncodingUtil.ENCODING_UTF_8;
    }

    private SystemFileTransferModeRegistry() {
        this.initialize();
    }

    public static SystemFileTransferModeRegistry getDefault() {
        if (instance == null) {
            instance = new SystemFileTransferModeRegistry();
        }
        return instance;
    }

    private void initialize() {
        this.loadAssociations();
        Workbench wb = Workbench.getInstance();
        if (wb != null) {
            IEditorRegistry registry = wb.getEditorRegistry();
            this.syncWithEditorRegistry(registry);
            registry.addPropertyListener((IPropertyListener)this);
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (source instanceof IEditorRegistry && propId == 1) {
            IEditorRegistry registry = (IEditorRegistry)source;
            this.syncWithEditorRegistry(registry);
        }
    }

    private void syncWithEditorRegistry(IEditorRegistry registry) {
        IFileEditorMapping[] editorMappings = registry.getFileEditorMappings();
        SystemFileTransferModeMapping[] modeMappings = new SystemFileTransferModeMapping[editorMappings.length];
        int i = 0;
        while (i < editorMappings.length) {
            modeMappings[i] = this.getMapping(editorMappings[i]);
            ++i;
        }
        this.setModeMappings(modeMappings);
        this.saveAssociations();
    }

    public ISystemFileTransferModeMapping[] getModeMappings() {
        List sortedMappings = this.sortedTypeModeMappings();
        ISystemFileTransferModeMapping[] array = new ISystemFileTransferModeMapping[sortedMappings.size()];
        sortedMappings.toArray(array);
        return array;
    }

    private List sortedTypeModeMappings() {
        Object[] array = new Object[this.typeModeMappings.size()];
        Iterator iter = this.typeModeMappings.values().iterator();
        int j = 0;
        while (iter.hasNext()) {
            array[j++] = iter.next();
        }
        SystemSorter s = new SystemSorter(){

            public boolean compare(Object o1, Object o2) {
                String s1 = ((ISystemFileTransferModeMapping)o1).getLabel().toUpperCase();
                String s2 = ((ISystemFileTransferModeMapping)o2).getLabel().toUpperCase();
                return s2.compareTo(s1) > 0;
            }
        };
        array = s.sort(array);
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < array.length) {
            result.add(array[i]);
            ++i;
        }
        return result;
    }

    public void setModeMappings(SystemFileTransferModeMapping[] newMappings) {
        this.typeModeMappings = new HashMap();
        int i = 0;
        while (i < newMappings.length) {
            SystemFileTransferModeMapping mapping = newMappings[i];
            this.typeModeMappings.put(this.getMappingKey(mapping), mapping);
            ++i;
        }
    }

    private String getMappingKey(ISystemFileTransferModeMapping mapping) {
        return mapping.getLabel().toLowerCase();
    }

    public boolean isBinary(String fileName) {
        return this.getMapping(fileName).isBinary();
    }

    public boolean isBinary(File file) {
        return this.isBinary(file.getName());
    }

    public boolean isBinary(IFile file) {
        return this.isBinary(file.getName());
    }

    public boolean isBinary(IRemoteFile remoteFile) {
        return this.isBinary(remoteFile.getName());
    }

    public boolean isText(String fileName) {
        return this.getMapping(fileName).isText();
    }

    public boolean isText(File file) {
        return this.isText(file.getName());
    }

    public boolean isText(IFile file) {
        return this.isText(file.getName());
    }

    public boolean isText(IRemoteFile remoteFile) {
        return this.isText(remoteFile.getName());
    }

    public SystemFileTransferModeMapping getMapping(IFileEditorMapping editorMapping) {
        return this.getMapping(editorMapping.getLabel());
    }

    private SystemFileTransferModeMapping getMapping(String fileName) {
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)this.typeModeMappings.get(fileName.toLowerCase());
        if (mapping == null) {
            mapping = this.createMappingFromModeMappings(fileName);
        }
        if (mapping == null) {
            return this.getDefaultMapping(fileName);
        }
        return mapping;
    }

    private SystemFileTransferModeMapping createMappingFromModeMappings(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1 || extIndex == fileName.length() - 1) {
            return null;
        }
        String name = fileName.substring(0, extIndex);
        String extension = fileName.substring(extIndex + 1);
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)this.typeModeMappings.get(this.getMappingKey(new SystemFileTransferModeMapping(extension)));
        if (mapping == null) {
            return null;
        }
        SystemFileTransferModeMapping fileMapping = new SystemFileTransferModeMapping(name, extension);
        if (mapping.isText()) {
            fileMapping.setAsText();
        } else {
            fileMapping.setAsBinary();
        }
        return fileMapping;
    }

    public static int getFileTransferModeDefaultPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getInt("org.eclipse.rse.preferences.filetransfermodedefault");
    }

    private SystemFileTransferModeMapping getDefaultMapping(String fileName) {
        int defaultFileTransferMode;
        String extension;
        String name;
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1 || extIndex == fileName.length() - 1 || extIndex == 0) {
            name = fileName;
            extension = null;
        } else {
            name = fileName.substring(0, extIndex);
            extension = fileName.substring(extIndex + 1);
        }
        SystemFileTransferModeMapping mapping = new SystemFileTransferModeMapping(name, extension);
        int i = 0;
        while (i < DEFAULT_TEXT_FILE_NAMES.length) {
            if (fileName.equalsIgnoreCase(DEFAULT_TEXT_FILE_NAMES[i])) {
                mapping.setAsText();
                return mapping;
            }
            ++i;
        }
        if (extension != null) {
            i = 0;
            while (i < DEFAULT_TEXT_FILE_EXTENSIONS.length) {
                if (extension.equalsIgnoreCase(DEFAULT_TEXT_FILE_EXTENSIONS[i])) {
                    mapping.setAsText();
                    return mapping;
                }
                ++i;
            }
            i = 0;
            while (i < DEFAULT_LPEX_TEXT_FILE_EXTENSIONS.length) {
                if (extension.equalsIgnoreCase(DEFAULT_LPEX_TEXT_FILE_EXTENSIONS[i])) {
                    mapping.setAsText();
                    return mapping;
                }
                ++i;
            }
            i = 0;
            while (i < DEFAULT_ISERIES_LPEX_TEXT_FILE_EXTENSIONS.length) {
                if (extension.equalsIgnoreCase(DEFAULT_ISERIES_LPEX_TEXT_FILE_EXTENSIONS[i])) {
                    mapping.setAsText();
                    return mapping;
                }
                ++i;
            }
            i = 0;
            while (i < DEFAULT_UNIX_LPEX_TEXT_FILE_EXTENSIONS.length) {
                if (extension.equalsIgnoreCase(DEFAULT_UNIX_LPEX_TEXT_FILE_EXTENSIONS[i])) {
                    mapping.setAsText();
                    return mapping;
                }
                ++i;
            }
            i = 0;
            while (i < DEFAULT_BINARY_FILE_EXTENSIONS.length) {
                if (extension.equalsIgnoreCase(DEFAULT_BINARY_FILE_EXTENSIONS[i])) {
                    mapping.setAsBinary();
                    return mapping;
                }
                ++i;
            }
        }
        if ((defaultFileTransferMode = SystemFileTransferModeRegistry.getFileTransferModeDefaultPreference()) == 0) {
            mapping.setAsBinary();
        } else if (defaultFileTransferMode == 1) {
            mapping.setAsText();
        }
        return mapping;
    }

    public boolean loadAssociations() {
        this.typeModeMappings = new HashMap();
        String location = this.getFileLocation();
        File file = new File(location);
        if (!file.exists()) {
            return false;
        }
        FileInputStream stream = null;
        InputStreamReader reader = null;
        boolean result = false;
        try {
            try {
                stream = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)stream, ENCODING);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] mementos = memento.getChildren(INFO_NODE);
                int i = 0;
                while (i < mementos.length) {
                    String name = mementos[i].getString(NAME_ATTRIBUTE);
                    String extension = mementos[i].getString(EXTENSION_ATTRIBUTE);
                    String mode = mementos[i].getString("mode");
                    SystemFileTransferModeMapping mapping = new SystemFileTransferModeMapping(name, extension);
                    if (mode.equals(TEXT_VALUE)) {
                        mapping.setAsText();
                    } else {
                        mapping.setAsBinary();
                    }
                    this.typeModeMappings.put(this.getMappingKey(mapping), mapping);
                    ++i;
                }
                result = true;
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not read transfer mode xml file", (Throwable)e);
                result = false;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not close reader for transfer mode xml file", (Throwable)e);
            }
        }
        return result;
    }

    public void saveAssociations() {
        String location = this.getFileLocation();
        XMLMemento memento = XMLMemento.createWriteRoot((String)"mode");
        Iterator iter = this.typeModeMappings.values().iterator();
        while (iter.hasNext()) {
            ISystemFileTransferModeMapping mapping = (ISystemFileTransferModeMapping)iter.next();
            IMemento infoMemento = memento.createChild(INFO_NODE);
            infoMemento.putString(NAME_ATTRIBUTE, mapping.getName());
            infoMemento.putString(EXTENSION_ATTRIBUTE, mapping.getExtension());
            infoMemento.putString("mode", mapping.isBinary() ? BINARY_VALUE : TEXT_VALUE);
        }
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            try {
                stream = new FileOutputStream(location);
                writer = new OutputStreamWriter((OutputStream)stream, ENCODING);
                memento.save((Writer)writer);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not write to transfer mode xml file", (Throwable)e);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not close writer for transfer mode xml file", (Throwable)e);
            }
        }
    }

    private String getFileLocation() {
        return this.plugin.getStateLocation().append(FILENAME).toOSString();
    }
}

