/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.ArrayList;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemConnectAllSubSystemsAction
extends SystemBaseAction {
    private ISystemRegistry sr = null;

    public SystemConnectAllSubSystemsAction(Shell shell) {
        super(SystemResources.ACTION_CONNECT_ALL_LABEL, SystemResources.ACTION_CONNECT_ALL_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.sr = RSEUIPlugin.getTheSystemRegistry();
    }

    public boolean checkObjectType(Object obj) {
        return obj instanceof IHost && !this.sr.areAllSubSystemsConnected((IHost)obj);
    }

    public void run() {
        ArrayList<IConnectorService> failedSystems = new ArrayList<IConnectorService>();
        IHost conn = (IHost)this.getFirstSelection();
        try {
            this.getShell();
            ISubSystem[] subsystems = conn.getSubSystems();
            int i = 0;
            while (i < subsystems.length) {
                ISubSystem subsystem = subsystems[i];
                IConnectorService system = subsystem.getConnectorService();
                if (!subsystem.isConnected() && !failedSystems.contains(system)) {
                    try {
                        subsystem.connect(false);
                    }
                    catch (Exception e) {
                        failedSystems.add(system);
                        if (e instanceof InterruptedException) break;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }
}

