/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.dialogs;

import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.filters.ISystemFilterStringEditPaneListener;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemUnNamedFilterDialog
extends SystemPromptDialog
implements ISystemFilterStringEditPaneListener {
    protected SystemFilterStringEditPane editpane;
    protected String outputFilterString;
    protected ISystemFilterPoolReferenceManagerProvider provider;

    public SystemUnNamedFilterDialog(Shell shell) {
        this(shell, SystemResources.RESID_CRTFILTER_TITLE);
    }

    public SystemUnNamedFilterDialog(Shell shell, String title) {
        super(shell, title);
        this.setOutputObject(null);
        this.setHelp();
    }

    protected void setHelp() {
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        this.provider = provider;
    }

    public void setFilterStringEditPane(SystemFilterStringEditPane editPane) {
        this.editpane = editPane;
    }

    public String getFilterString() {
        return this.outputFilterString;
    }

    protected Control getInitialFocusControl() {
        return this.editpane.getInitialFocusControl();
    }

    protected Control createInner(Composite parent) {
        this.editpane = this.getFilterStringEditPane(this.getShell());
        this.editpane.setSystemFilterPoolReferenceManagerProvider(this.provider);
        Control composite = this.editpane.createContents(parent);
        this.editpane.addChangeListener(this);
        return composite;
    }

    protected SystemFilterStringEditPane getFilterStringEditPane(Shell shell) {
        if (this.editpane == null) {
            this.editpane = new SystemFilterStringEditPane(shell);
        }
        return this.editpane;
    }

    protected boolean processOK() {
        SystemMessage errorMessage = this.editpane.verify();
        if (errorMessage != null) {
            return false;
        }
        this.outputFilterString = this.editpane.getFilterString();
        return super.processOK();
    }

    protected boolean processCancel() {
        return super.processCancel();
    }

    public void setPageComplete(boolean complete) {
    }

    public void filterStringChanged(SystemMessage message) {
        if (message != null) {
            this.setErrorMessage(message);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete(message == null);
    }

    public void backupChangedState() {
    }

    public void restoreChangedState() {
    }
}

