/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.messages;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SystemMessageLine
extends Composite
implements ISystemMessageLine {
    private Button moreButton;
    private Label image;
    private Text widget;
    private MyMessage infoMessage = null;
    private MyMessage errorMessage = null;
    private static final int ERROR = 3;
    private static final int WARNING = 2;
    private static final int INFO = 1;
    private static final int NONE = 0;

    public SystemMessageLine(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 2;
        layout.marginWidth = 3;
        this.setLayout((Layout)layout);
        this.image = new Label((Composite)this, 0);
        this.image.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.widget = new Text((Composite)this, 12);
        this.widget.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.widget.setBackground(parent.getBackground());
        this.moreButton = new Button((Composite)this, 0);
        this.moreButton.setImage(RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.systemhelpIcon"));
        this.moreButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.moreButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MyMessage message;
                if (e.getSource().equals(SystemMessageLine.this.moreButton) && (message = SystemMessageLine.this.getCurrentMessage()) != null) {
                    SystemMessage m = message.toSystemMessage();
                    Shell shell = SystemMessageLine.this.getShell();
                    SystemMessageDialog dialog = new SystemMessageDialog(shell, m);
                    dialog.openWithDetails();
                }
            }
        });
        this.moreButton.setToolTipText(SystemResources.RESID_MSGLINE_TIP);
        this.moreButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                this.getHelp(e);
            }

            public void getHelp(AccessibleEvent e) {
                e.result = SystemMessageLine.this.moreButton.getToolTipText();
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                SystemMessageLine.this.adjustText();
                SystemMessageLine.this.layout();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SystemMessageLine.this.widget.dispose();
                SystemMessageLine.this.moreButton.dispose();
                SystemMessageLine.this.image.dispose();
            }
        });
        this.showCurrentMessage();
    }

    public void clearMessage() {
        this.infoMessage = null;
        this.showCurrentMessage();
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
        this.showCurrentMessage();
    }

    public void setMessage(SystemMessage message) {
        this.infoMessage = new MySystemMessage(message);
        if (this.infoMessage.isError()) {
            this.infoMessage = new MyImpromptuMessage(0, message.getLevelOneText(), message.getLevelTwoText());
        }
        this.showCurrentMessage();
    }

    public void setMessage(String message) {
        this.infoMessage = new MyImpromptuMessage(1, message);
        this.showCurrentMessage();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = new MyImpromptuMessage(3, message);
        this.showCurrentMessage();
    }

    public void setErrorMessage(SystemMessage message) {
        this.logMessage(message);
        this.errorMessage = new MySystemMessage(message);
        this.showCurrentMessage();
    }

    public void setErrorMessage(Throwable throwable) {
        SystemMessage message = RSEUIPlugin.getPluginMessage("RSEF8002");
        message.makeSubstitution((Object)throwable);
        this.setErrorMessage(message);
    }

    public String getMessage() {
        String result = this.infoMessage != null ? this.infoMessage.getText() : null;
        return result;
    }

    public String getErrorMessage() {
        String result = this.errorMessage != null ? this.errorMessage.getText() : null;
        return result;
    }

    public SystemMessage getSystemErrorMessage() {
        SystemMessage result = this.errorMessage != null ? this.errorMessage.toSystemMessage() : null;
        return result;
    }

    private MyMessage getCurrentMessage() {
        return this.errorMessage != null ? this.errorMessage : this.infoMessage;
    }

    private void showCurrentMessage() {
        MyMessage message = this.getCurrentMessage();
        this.setIcon(message);
        this.setText(message);
        this.setMoreButton(message);
        this.layout();
    }

    private void setIcon(MyMessage message) {
        Image t = message == null ? null : message.getImage();
        this.image.setImage(t);
    }

    private void setText(MyMessage message) {
        String text = "";
        String toolTip = null;
        Color color = null;
        if (message != null) {
            text = message.getText();
            toolTip = message.getTooltip();
            color = message.getColor();
        }
        this.widget.setToolTipText(toolTip);
        this.widget.setForeground(color);
        this.widget.setText(text);
        this.widget.setData((Object)text);
        this.widget.setVisible(text.length() > 0);
        this.adjustText();
    }

    private void setMoreButton(MyMessage message) {
        boolean visible = message != null && message.hasMore();
        this.moreButton.setVisible(visible);
    }

    private void adjustText() {
        GC gc = new GC((Drawable)this.widget);
        int maxWidth = this.getSize().x;
        maxWidth -= this.moreButton.getSize().x;
        maxWidth -= this.image.getSize().x;
        maxWidth = (maxWidth -= 17) >= 0 ? maxWidth : 0;
        String text = (String)this.widget.getData();
        if (text != null) {
            if (gc.stringExtent((String)text).x > maxWidth) {
                StringBuffer head = new StringBuffer(text);
                int n = head.length();
                head.append("...");
                while (n > 0) {
                    text = head.toString();
                    if (gc.stringExtent((String)text).x <= maxWidth) break;
                    head.deleteCharAt(--n);
                }
                if (n == 0) {
                    text = "";
                }
            }
            this.widget.setText(text);
        }
        gc.dispose();
    }

    private void logMessage(SystemMessage message) {
        MySystemMessage m = new MySystemMessage(message);
        Object[] data = ((MyMessage)m).getData();
        int i = 0;
        while (i < data.length) {
            Object object = data[i];
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(((MyMessage)m).getID());
            buffer.append(": SUB#");
            buffer.append(Integer.toString(i));
            buffer.append(":");
            buffer.append(object.toString());
            this.logMessage(((MyMessage)m).getType(), buffer.toString(), false);
            ++i;
        }
        this.logMessage(((MyMessage)m).getType(), ((MyMessage)m).getID(), ((MyMessage)m).isStrange());
    }

    private void logMessage(int type, String text, boolean stackTrace) {
        boolean logging = RSEUIPlugin.getDefault().getLoggingSystemMessageLine();
        if (logging) {
            switch (type) {
                case 3: {
                    Exception e = stackTrace ? new Exception("Stack Trace") : null;
                    SystemBasePlugin.logError(text, e);
                    break;
                }
                case 2: {
                    SystemBasePlugin.logWarning(text);
                    break;
                }
                default: {
                    SystemBasePlugin.logInfo(text);
                }
            }
        }
    }

    private class MyImpromptuMessage
    extends MyMessage {
        private int type = 0;
        private String text1 = "";
        private String text2 = null;

        MyImpromptuMessage(int type, String text1) {
            this.type = type;
            this.text1 = text1;
        }

        MyImpromptuMessage(int type, String text1, String text2) {
            this.type = type;
            this.text1 = text1;
            this.text2 = text2;
        }

        public SystemMessage toSystemMessage() {
            String id = null;
            Object[] data = null;
            if (this.text2 == null) {
                id = this.isError() ? "RSEO1012" : "RSEO1010";
                data = new Object[]{this.text1};
            } else {
                id = this.isError() ? "RSEO1002" : "RSEO1000";
                data = new Object[]{this.text1, this.text2};
            }
            SystemMessage result = RSEUIPlugin.getPluginMessage(id, data);
            return result;
        }

        String getID() {
            return null;
        }

        String getText() {
            return this.text1;
        }

        String getTooltip() {
            return this.text1;
        }

        boolean hasMore() {
            return this.text2 != null;
        }

        boolean isStrange() {
            return false;
        }

        Object[] getData() {
            return new Object[0];
        }

        int getType() {
            return this.type;
        }
    }

    private abstract class MyMessage {
        private MyMessage() {
        }

        Image getImage() {
            int type = this.getType();
            switch (type) {
                case 3: {
                    return JFaceResources.getImage((String)"dialog_message_error_image");
                }
                case 2: {
                    return JFaceResources.getImage((String)"dialog_messasge_warning_image");
                }
                case 1: {
                    return JFaceResources.getImage((String)"dialog_messasge_info_image");
                }
            }
            return JFaceResources.getImage((String)"dialog_messasge_info_image");
        }

        Color getColor() {
            int type = this.getType();
            switch (type) {
                case 3: {
                    return this.getColor("MESSAGE_ERROR_COLOR");
                }
                case 2: {
                    return this.getColor("MESSAGE_WARNING_COLOR");
                }
                case 1: {
                    return this.getColor("MESSAGE_INFORMATION_COLOR");
                }
            }
            return this.getColor("MESSAGE_INFORMATION_COLOR");
        }

        private Color getColor(String symbolicName) {
            ColorRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
            Color result = registry.get(symbolicName);
            return result;
        }

        boolean isError() {
            return this.getType() == 3;
        }

        abstract String getID();

        abstract String getText();

        abstract String getTooltip();

        abstract boolean hasMore();

        abstract SystemMessage toSystemMessage();

        abstract int getType();

        abstract Object[] getData();

        abstract boolean isStrange();
    }

    private class MySystemMessage
    extends MyMessage {
        private SystemMessage message = null;

        MySystemMessage(SystemMessage message) {
            this.message = message;
        }

        SystemMessage toSystemMessage() {
            return this.message;
        }

        String getID() {
            return this.message.getFullMessageID();
        }

        String getText() {
            return this.message.getLevelOneText();
        }

        String getTooltip() {
            return String.valueOf(this.message.getFullMessageID()) + ": " + this.getText();
        }

        boolean hasMore() {
            String text2 = this.message.getLevelTwoText();
            return text2 != null && text2.length() > 0;
        }

        boolean isStrange() {
            return this.message.getIndicator() == 'U';
        }

        Object[] getData() {
            Object[] result = this.message.getSubVariables();
            if (result == null) {
                result = new Object[]{};
            }
            return result;
        }

        int getType() {
            int result = 0;
            if (this.message != null) {
                switch (this.message.getIndicator()) {
                    case 'C': 
                    case 'I': 
                    case 'Q': {
                        result = 1;
                        break;
                    }
                    case 'E': 
                    case 'U': {
                        result = 3;
                        break;
                    }
                    case 'W': {
                        result = 2;
                        break;
                    }
                    default: {
                        result = 0;
                    }
                }
            }
            return result;
        }
    }
}

