/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.view.ISystemSelectAllTarget;
import org.eclipse.rse.ui.view.team.SystemTeamViewPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SystemTeamView
extends TreeViewer
implements ISystemSelectAllTarget,
ISystemResourceChangeListener {
    private SystemTeamViewPart teamViewPart;

    public SystemTeamView(Composite parent, SystemTeamViewPart teamViewPart) {
        super(parent);
        this.teamViewPart = teamViewPart;
        SystemWidgetHelpers.setHelp((Control)this.getTree(), "org.eclipse.rse.ui.teamview");
    }

    public SystemTeamView(Composite parent, int style, SystemTeamViewPart teamViewPart) {
        super(parent, style);
        this.teamViewPart = teamViewPart;
        SystemWidgetHelpers.setHelp((Control)this.getTree(), "org.eclipse.rse.ui.teamview");
    }

    public SystemTeamView(Tree tree, SystemTeamViewPart teamViewPart) {
        super(tree);
        this.teamViewPart = teamViewPart;
        SystemWidgetHelpers.setHelp((Control)this.getTree(), "org.eclipse.rse.ui.teamview");
    }

    public SystemTeamViewPart getTeamViewPart() {
        return this.teamViewPart;
    }

    public Object[] getElementNodes(Object element) {
        Widget w = this.findItem(element);
        if (w != null && w instanceof TreeItem) {
            return this.getElementNodes((TreeItem)w);
        }
        return null;
    }

    public Object[] getElementNodes(TreeItem item) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(item.getData());
        while (item != null) {
            if ((item = item.getParentItem()) == null) continue;
            v.addElement(item.getData());
        }
        Object[] nodes = new Object[v.size()];
        int idx = 0;
        while (idx < nodes.length) {
            nodes[idx] = v.elementAt(idx);
            ++idx;
        }
        return nodes;
    }

    public TreeItem findTreeItem(Object dataObject) {
        Widget widget = this.findItem(dataObject);
        if (widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    public TreeItem findChildTreeItem(TreeItem parentItem, Object dataObject) {
        TreeItem[] childItems = parentItem.getItems();
        TreeItem childItem = null;
        int idx = 0;
        while (childItem == null && idx < childItems.length) {
            if (childItems[idx].getData() != null && childItems[idx].getData().equals(dataObject)) {
                childItem = childItems[idx];
            }
            ++idx;
        }
        return childItem;
    }

    public void updatePropertySheet() {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        int type = event.getType();
        switch (type) {
            case 91: {
                this.collapseToLevel(this.getInput(), -1);
            }
        }
    }

    public Shell getShell() {
        return super.getControl().getShell();
    }

    public boolean enableSelectAll(IStructuredSelection selection) {
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length != 1) {
            return false;
        }
        TreeItem ti = items[0];
        int count = this.getItemCount((Item)ti);
        if (count == 1 && this.getItems((Item)ti)[0].getData() == null) {
            count = 0;
        }
        return count > 0;
    }

    public void doSelectAll(IStructuredSelection selection) {
        Tree tree = this.getTree();
        TreeItem[] currSel = tree.getSelection();
        TreeItem[] childItems = currSel[0].getItems();
        if (childItems.length == 0) {
            return;
        }
        tree.setSelection(childItems);
        Object[] childObjects = new Object[childItems.length];
        int idx = 0;
        while (idx < childObjects.length) {
            childObjects[idx] = childItems[idx].getData();
            ++idx;
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(childObjects)));
    }

    public void collapseSelected() {
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int idx = 0;
            while (idx < selectedItems.length) {
                selectedItems[idx].setExpanded(false);
                ++idx;
            }
        }
    }

    public void expandSelected() {
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int idx = 0;
            while (idx < selectedItems.length) {
                if (!selectedItems[idx].getExpanded()) {
                    this.createChildren((Widget)selectedItems[idx]);
                }
                selectedItems[idx].setExpanded(true);
                ++idx;
            }
        }
    }
}

